/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.operators;

import dr.geo.AbstractPolygon2D;
import dr.geo.GeoSpatialDistribution;
import dr.geo.MultiRegionGeoSpatialDistribution;
import dr.geo.operators.UniformGeoSpatialOperator;
import dr.inference.distribution.AbstractDistributionLikelihood;
import dr.inference.distribution.CachedDistributionLikelihood;
import dr.inference.distribution.MultivariateDistributionLikelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.UniformOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UniformGeoSpatialOperatorParser
extends AbstractXMLObjectParser {
    public static final String UNIFORM_OPERATOR = "uniformGeoSpatialOperator";
    public static final String LOWER = "lower";
    public static final String UPPER = "upper";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(Parameter.class), new XORRule(new ElementRule(MultivariateDistributionLikelihood.class), new ElementRule(CachedDistributionLikelihood.class))};

    @Override
    public String getParserName() {
        return UNIFORM_OPERATOR;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Serializable serializable;
        double d = xMLObject.getDoubleAttribute("weight");
        Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
        if (parameter.getDimension() == 0) {
            throw new XMLParseException("parameter with 0 dimension.");
        }
        MultivariateDistributionLikelihood multivariateDistributionLikelihood = (MultivariateDistributionLikelihood)xMLObject.getChild(MultivariateDistributionLikelihood.class);
        if (multivariateDistributionLikelihood == null) {
            serializable = (CachedDistributionLikelihood)xMLObject.getChild(CachedDistributionLikelihood.class);
            AbstractDistributionLikelihood abstractDistributionLikelihood = ((CachedDistributionLikelihood)serializable).getDistributionLikelihood();
            if (!(abstractDistributionLikelihood instanceof MultivariateDistributionLikelihood)) {
                throw new XMLParseException("invalid likelihood type in " + xMLObject.getId());
            }
            multivariateDistributionLikelihood = (MultivariateDistributionLikelihood)abstractDistributionLikelihood;
        }
        serializable = new ArrayList();
        if (multivariateDistributionLikelihood.getDistribution() instanceof MultiRegionGeoSpatialDistribution) {
            for (GeoSpatialDistribution geoSpatialDistribution : ((MultiRegionGeoSpatialDistribution)multivariateDistributionLikelihood.getDistribution()).getRegions()) {
                serializable.add(geoSpatialDistribution.getRegion());
            }
        } else if (multivariateDistributionLikelihood.getDistribution() instanceof GeoSpatialDistribution) {
            serializable.add(((GeoSpatialDistribution)multivariateDistributionLikelihood.getDistribution()).getRegion());
        } else {
            throw new XMLParseException("Multivariate distribution must be either a GeoSpatialDistribution or a MultiRegionGeoSpatialDistribution");
        }
        return new UniformGeoSpatialOperator(parameter, d, (List<AbstractPolygon2D>)((Object)serializable));
    }

    @Override
    public String getParserDescription() {
        return "An operator that picks new parameter values uniformly at random.";
    }

    @Override
    public Class getReturnType() {
        return UniformOperator.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

