/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.evomodel.tree.TreeModel;
import dr.inference.distribution.RandomField;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class GriddedWeights
extends AbstractModel
implements RandomField.WeightProvider {
    private final TreeModel tree;
    private final boolean rescaleByRootHeight;
    private final Parameter gridPoints;

    public GriddedWeights(TreeModel treeModel, Parameter parameter, boolean bl) {
        super("Weight Provider with grid points");
        this.tree = treeModel;
        this.rescaleByRootHeight = bl;
        this.gridPoints = parameter;
    }

    @Override
    public double weight(int n, int n2) {
        if (Math.abs(n - n2) != 1) {
            return 0.0;
        }
        int n3 = Math.max(n, n2);
        double d = n3 >= this.gridPoints.getDimension() ? (this.gridPoints.getParameterValue(n3 - 1) < this.tree.getNodeHeight(this.tree.getRoot()) ? this.tree.getNodeHeight(this.tree.getRoot()) : this.gridPoints.getParameterValue(n3 - 1) + (this.gridPoints.getParameterValue(n3 - 1) - this.gridPoints.getParameterValue(n3 - 2)) / 2.0) : this.gridPoints.getParameterValue(n3);
        double d2 = n3 == 1 ? 0.0 : this.gridPoints.getParameterValue(n3 - 2);
        return 2.0 / (d - d2) * this.getFieldScalar();
    }

    private double getFieldScalar() {
        if (this.rescaleByRootHeight) {
            return this.tree.getNodeHeight(this.tree.getRoot());
        }
        return 1.0;
    }

    @Override
    public int getDimension() {
        return this.gridPoints.getDimension();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public boolean isUsed() {
        return false;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void setId(String string) {
    }
}

