/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.logging.Logger;

public class RandomWalkModel
extends AbstractModelLikelihood {
    private final ParametricDistributionModel distribution;
    private final boolean logScale;
    private Parameter data;
    protected boolean likelihoodKnown;
    private boolean forwardOrder;

    public RandomWalkModel(ParametricDistributionModel parametricDistributionModel, Parameter parameter, boolean bl, boolean bl2) {
        super(null);
        this.distribution = parametricDistributionModel;
        this.forwardOrder = bl;
        this.logScale = bl2;
        this.data = parameter;
        if (parametricDistributionModel != null) {
            this.addModel(parametricDistributionModel);
        }
        double d = Double.NEGATIVE_INFINITY;
        if (bl2) {
            d = 0.0;
        }
        this.addVariable(parameter);
        if (parameter instanceof CompoundParameter) {
            CompoundParameter compoundParameter = (CompoundParameter)parameter;
            for (int i = 0; i < compoundParameter.getParameterCount(); ++i) {
                Parameter parameter2 = compoundParameter.getParameter(i);
                parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, d, parameter2.getDimension()));
            }
        } else {
            parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, d, parameter.getDimension()));
        }
        Logger.getLogger("dr.inference").info("Setting up a first-order random walk:");
        Logger.getLogger("dr.inference").info("\tData parameter: " + parameter.getId());
        Logger.getLogger("dr.inference").info("\tOn scale: " + (bl2 ? "log" : "real"));
        Logger.getLogger("dr.inference").info("\tDistribution: " + parametricDistributionModel.getId());
        Logger.getLogger("dr.inference").info("\tIf you publish results using this model, please cite Suchard and Lemey (in preparation)\n");
    }

    protected double calculateLogLikelihood() {
        int n = this.data.getDimension();
        double d = 0.0;
        double d2 = this.data.getParameterValue(0);
        if (this.logScale) {
            d2 = Math.log(d2);
        }
        for (int i = 1; i < n; ++i) {
            double d3 = this.data.getParameterValue(i);
            if (this.logScale) {
                d3 = Math.log(d3);
            }
            d += this.distribution.logPdf(d3 - d2);
            if (this.logScale) {
                d -= d3;
            }
            d2 = d3;
        }
        return d;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        return this.calculateLogLikelihood();
    }

    @Override
    public void makeDirty() {
    }
}

