/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.GradientProvider;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;

public class SoftBoundUniformDistribution
extends AbstractContinuousDistribution
implements Distribution,
GradientProvider,
Citable {
    private final double lowerBound;
    private final double upperBound;
    private final double lowerProbability;
    private final double upperProbability;
    public static Citation CITATION = new Citation(new Author[]{new Author("Z", "Yang"), new Author("B", "Rannala")}, "Bayesian Estimation of Species Divergence Times Under a Molecular Clock Using Multiple Fossil Calibrations with Soft Bounds", 2006, "Molecular Biology and Evolution", 23, 212, 226, Citation.Status.PUBLISHED);

    public SoftBoundUniformDistribution(double d, double d2, double d3, double d4) {
        this.lowerBound = d;
        this.upperBound = d2;
        this.lowerProbability = d3;
        this.upperProbability = d4;
    }

    @Override
    public double pdf(double d) {
        if (d > this.lowerBound && d < this.upperBound) {
            return (1.0 - this.lowerProbability - this.upperProbability) / (this.upperBound - this.lowerBound);
        }
        if (d < this.lowerBound) {
            double d2 = (1.0 - this.lowerProbability - this.upperProbability) * this.lowerBound / (this.lowerProbability * (this.upperBound - this.lowerBound));
            return this.lowerProbability * d2 / this.lowerBound * Math.pow(d / this.lowerBound, d2 - 1.0);
        }
        double d3 = (1.0 - this.lowerProbability - this.upperProbability) / (this.upperProbability * (this.upperBound - this.lowerBound));
        return this.upperProbability * d3 / Math.exp(d3 * (d - this.upperBound));
    }

    @Override
    public double logPdf(double d) {
        if (d > this.lowerBound && d < this.upperBound) {
            return Math.log((1.0 - this.lowerProbability - this.upperProbability) / (this.upperBound - this.lowerBound));
        }
        if (d < this.lowerBound) {
            double d2 = (1.0 - this.lowerProbability - this.upperProbability) * this.lowerBound / (this.lowerProbability * (this.upperBound - this.lowerBound));
            return Math.log(this.lowerProbability * d2 / this.lowerBound) + (d2 - 1.0) * Math.log(d / this.lowerBound);
        }
        double d3 = (1.0 - this.lowerProbability - this.upperProbability) / (this.upperProbability * (this.upperBound - this.lowerBound));
        return Math.log(this.upperProbability * d3) - d3 * (d - this.upperBound);
    }

    @Override
    public double cdf(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double quantile(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double mean() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double variance() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public UnivariateFunction getProbabilityDensityFunction() {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getInitialDomain(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getDomainLowerBound(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    protected double getDomainUpperBound(double d) {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        throw new RuntimeException("Not yet implemented!");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.PRIOR_MODELS;
    }

    @Override
    public String getDescription() {
        return "Uniform distribution with soft bound.";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double d = (Double)object;
        if (d > this.lowerBound && d < this.upperBound) {
            return new double[]{0.0};
        }
        if (d < this.lowerBound) {
            double d2 = (1.0 - this.lowerProbability - this.upperProbability) * this.lowerBound / (this.lowerProbability * (this.upperBound - this.lowerBound));
            return new double[]{(d2 - 1.0) / d};
        }
        double d3 = (1.0 - this.lowerProbability - this.upperProbability) / (this.upperProbability * (this.upperBound - this.lowerBound));
        return new double[]{-d3};
    }
}

