/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution.shrinkage;

import dr.inference.distribution.shrinkage.OldBayesianBridgeLikelihood;
import dr.inference.model.Parameter;
import dr.math.distributions.NormalDistribution;

public class OldJointBayesianBridge
extends OldBayesianBridgeLikelihood {
    private final Parameter localScale;

    public OldJointBayesianBridge(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4) {
        super(parameter, parameter2, parameter4);
        this.localScale = parameter3;
        this.addVariable(parameter3);
    }

    @Override
    double calculateLogLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d += NormalDistribution.logPdf(this.coefficients.getParameterValue(i), 0.0, this.getStandardDeviation(i));
        }
        return d;
    }

    @Override
    double[] calculateGradientLogDensity() {
        double[] dArray = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = NormalDistribution.gradLogPdf(this.coefficients.getParameterValue(i), 0.0, this.getStandardDeviation(i));
        }
        return dArray;
    }

    @Override
    public Parameter getLocalScale() {
        return this.localScale;
    }

    private double getStandardDeviation(int n) {
        return this.globalScale.getParameterValue(0) * this.localScale.getParameterValue(n);
    }
}

