/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.loggers;

import dr.inference.loggers.LogFormatter;
import dr.inference.trace.Trace;
import dr.inference.trace.TraceType;
import java.util.ArrayList;
import java.util.List;

public class ArrayLogFormatter
implements LogFormatter {
    String heading;
    String[] labels = null;
    List<String> lines = new ArrayList<String>();
    List<Trace> traces = new ArrayList<Trace>();
    boolean echo = false;

    public ArrayLogFormatter(boolean bl) {
        this.echo = bl;
    }

    @Override
    public void startLogging(String string) {
    }

    @Override
    public void logHeading(String string) {
        this.heading = string;
        this.echo(string);
    }

    @Override
    public void logLine(String string) {
        this.lines.add(string);
        this.echo(string);
    }

    @Override
    public void logLabels(String[] stringArray) {
        if (this.labels == null) {
            this.labels = stringArray;
            for (String string : stringArray) {
                this.traces.add(new Trace(string, TraceType.REAL));
            }
        } else {
            throw new RuntimeException("logLabels() method should only be called once!");
        }
        this.echo(stringArray);
    }

    @Override
    public void logValues(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.traces.get(i).add(Double.parseDouble(stringArray[i]));
        }
        this.echo(stringArray);
    }

    @Override
    public void stopLogging() {
    }

    public List<Trace> getTraces() {
        return this.traces;
    }

    private void echo(String string) {
        if (this.echo) {
            System.out.println(string);
        }
    }

    private void echo(String[] stringArray) {
        if (this.echo) {
            for (String string : stringArray) {
                System.out.print(string + "\t");
            }
            System.out.println();
        }
    }
}

