/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.IndianBuffetProcessPrior;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.operators.BitFlipOperator;

public class IBPBitFlipOperator
extends BitFlipOperator {
    IndianBuffetProcessPrior IBP;
    MatrixParameterInterface sparsity;

    public IBPBitFlipOperator(Parameter parameter, double d, IndianBuffetProcessPrior indianBuffetProcessPrior) {
        super(parameter, d, true);
        this.sparsity = (MatrixParameterInterface)parameter;
        this.IBP = indianBuffetProcessPrior;
    }

    @Override
    public double doOperation(Likelihood likelihood) {
        return super.doOperation(likelihood);
    }

    protected double sum(int n) {
        double d = 0.0;
        int n2 = n / this.sparsity.getRowDimension();
        for (int i = 0; i < this.sparsity.getRowDimension(); ++i) {
            d += this.sparsity.getParameterValue(i, n2);
        }
        return d;
    }

    protected int getDimension() {
        return this.sparsity.getRowDimension();
    }
}

