/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.GeneralOperator;
import dr.inference.operators.PathDependent;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLSyntaxRule;

public class LoadingsRotationOperator
extends AbstractAdaptableOperator
implements GeneralOperator,
PathDependent {
    private final AbstractAdaptableOperator baseOperator;
    private final MatrixParameterInterface parameter;
    public static final String PARSER_NAME = "loadingsRotationOperator";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) {
            AbstractAdaptableOperator abstractAdaptableOperator = (AbstractAdaptableOperator)xMLObject.getChild(AbstractAdaptableOperator.class);
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            return new LoadingsRotationOperator(abstractAdaptableOperator, matrixParameterInterface);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(AbstractAdaptableOperator.class), new ElementRule(MatrixParameterInterface.class)};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return LoadingsRotationOperator.class;
        }

        @Override
        public String getParserName() {
            return LoadingsRotationOperator.PARSER_NAME;
        }
    };

    public LoadingsRotationOperator(AbstractAdaptableOperator abstractAdaptableOperator, MatrixParameterInterface matrixParameterInterface) {
        super(abstractAdaptableOperator.mode, abstractAdaptableOperator.getTargetAcceptanceProbability());
        this.baseOperator = abstractAdaptableOperator;
        this.parameter = matrixParameterInterface;
    }

    @Override
    public String getOperatorName() {
        return "loadingsRotationOperator:" + this.baseOperator.getOperatorName();
    }

    @Override
    public double doOperation(Likelihood likelihood) {
        this.syncBaseOperator();
        double d = this.baseOperator.doOperation(likelihood);
        double d2 = likelihood.getLogLikelihood();
        this.reflect();
        double d3 = likelihood.getLogLikelihood();
        if (d2 != d3) {
            throw new RuntimeException("Fix this");
        }
        return d;
    }

    private void reflect() {
        boolean bl = false;
        int n = Math.min(this.parameter.getRowDimension(), this.parameter.getColumnDimension());
        for (int i = 0; i < n; ++i) {
            if (!(this.parameter.getParameterValue(i, i) < 0.0)) continue;
            bl = true;
            for (int j = i; j < this.parameter.getRowDimension(); ++j) {
                this.parameter.setParameterValueQuietly(j, i, -this.parameter.getParameterValue(j, i));
            }
        }
        if (bl) {
            this.parameter.fireParameterChangedEvent();
        }
    }

    @Override
    public double doOperation() {
        this.syncBaseOperator();
        double d = this.baseOperator.doOperation();
        this.reflect();
        return d;
    }

    private void syncBaseOperator() {
        this.baseOperator.setAcceptCount(this.getAcceptCount());
        this.baseOperator.setRejectCount(this.getRejectCount());
        this.baseOperator.setSumDeviation(this.getSumDeviation());
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.baseOperator.setAdaptableParameter(d);
    }

    @Override
    protected double getAdaptableParameterValue() {
        return this.baseOperator.getAdaptableParameter();
    }

    @Override
    public double getRawParameter() {
        return this.baseOperator.getRawParameter();
    }

    @Override
    public String getAdaptableParameterName() {
        return this.baseOperator.getAdaptableParameterName();
    }
}

