/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.state;

import dr.inference.markovchain.MarkovChain;
import dr.inference.model.Model;
import dr.inference.state.StateSaver;
import dr.inference.state.StateSaverChainListener;

public class TimedStateSaverChainListener
extends StateSaverChainListener {
    private final long endTime;

    public TimedStateSaverChainListener(StateSaver stateSaver, int n) {
        super(stateSaver, -1L, false);
        this.endTime = TimedStateSaverChainListener.getTimeInSeconds() + (long)n;
    }

    @Override
    public void currentState(long l, MarkovChain markovChain, Model model) {
        if (TimedStateSaverChainListener.getTimeInSeconds() >= this.endTime) {
            double d = markovChain.getCurrentScore();
            this.stateSaver.saveState(markovChain, l, d);
            markovChain.pleaseStop();
        }
    }

    private static long getTimeInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }
}

