/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PathSamplingAnalysis {
    public static final String PATH_SAMPLING_ANALYSIS = "pathSamplingAnalysis";
    public static final String RESULT_FILE_NAME = "resultsFileName";
    public static final String LIKELIHOOD_COLUMN = "likelihoodColumn";
    public static final String THETA_COLUMN = "thetaColumn";
    public static final String FORMAT = "%5.5g";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("fileName", "The traceName of a BEAST log file (can not include trees, which should be logged separately)"), new StringAttributeRule("resultsFileName", "The name of the output file to which the path sampling estimate will be written", true), new ElementRule("thetaColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")}), new ElementRule("likelihoodColumn", new XMLSyntaxRule[]{new StringAttributeRule("name", "The column name")})};

        @Override
        public String getParserName() {
            return PathSamplingAnalysis.PATH_SAMPLING_ANALYSIS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getStringAttribute("fileName");
            String string2 = null;
            if (xMLObject.hasAttribute(PathSamplingAnalysis.RESULT_FILE_NAME)) {
                string2 = xMLObject.getStringAttribute(PathSamplingAnalysis.RESULT_FILE_NAME);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            System.out.println(n + " file(s) found with marginal likelihood samples");
            try {
                Object object;
                Object object2;
                String string3 = "";
                List<Double> list = null;
                List<Double> list2 = null;
                for (int i = 0; i < n; ++i) {
                    object2 = new File(stringTokenizer.nextToken());
                    object = ((File)object2).getName();
                    String string4 = ((File)object2).getParent();
                    if (!((File)object2).isAbsolute()) {
                        string4 = string4 == null ? System.getProperty("user.dir") : Paths.get(System.getProperty("user.dir"), string4).toString();
                    }
                    String string5 = System.getProperty("file.name.prefix");
                    String string6 = System.getProperty("file.separator");
                    if (string5 != null) {
                        if (string5.trim().length() == 0 || string5.contains(string6)) {
                            throw new XMLParseException("The specified file name prefix is illegal.");
                        }
                        object2 = new File(string4, string5 + (String)object);
                    } else {
                        object2 = new File(string4, (String)object);
                    }
                    string = ((File)object2).getAbsolutePath();
                    XMLObject xMLObject2 = xMLObject.getChild(PathSamplingAnalysis.LIKELIHOOD_COLUMN);
                    string3 = xMLObject2.getStringAttribute("name");
                    xMLObject2 = xMLObject.getChild(PathSamplingAnalysis.THETA_COLUMN);
                    String string7 = xMLObject2.getStringAttribute("name");
                    LogFileTraces logFileTraces = new LogFileTraces(string, (File)object2);
                    logFileTraces.loadTraces();
                    long l = logFileTraces.getMaxState();
                    long l2 = xMLObject.getAttribute("burnIn", l / 5L);
                    if (l2 < 0L || l2 >= l) {
                        l2 = l / 5L;
                        System.out.println("WARNING: Burn-in larger than total number of states - using 20%");
                    }
                    l2 = 0L;
                    logFileTraces.setBurnIn(l2);
                    int n2 = -1;
                    int n3 = -1;
                    for (int j = 0; j < logFileTraces.getTraceCount(); ++j) {
                        String string8 = logFileTraces.getTraceName(j);
                        if (string8.trim().equals(string3)) {
                            n2 = j;
                        }
                        if (!string8.trim().equals(string7)) continue;
                        n3 = j;
                    }
                    if (n2 == -1) {
                        throw new XMLParseException("Column '" + string3 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (n3 == -1) {
                        throw new XMLParseException("Column '" + string7 + "' can not be found for " + this.getParserName() + " element.");
                    }
                    if (list == null && list2 == null) {
                        list = logFileTraces.getValues(n2);
                        list2 = logFileTraces.getValues(n3);
                        continue;
                    }
                    list.addAll(logFileTraces.getValues(n2));
                    list2.addAll(logFileTraces.getValues(n3));
                }
                PathSamplingAnalysis pathSamplingAnalysis = new PathSamplingAnalysis(string3, list, list2);
                System.out.println(pathSamplingAnalysis.toString());
                if (string2 != null) {
                    object2 = new FileWriter(string2, true);
                    object = new BufferedWriter((Writer)object2);
                    ((Writer)object).write(pathSamplingAnalysis.toString());
                    ((BufferedWriter)object).flush();
                    ((BufferedWriter)object).close();
                }
                return pathSamplingAnalysis;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
            }
            catch (IOException iOException) {
                throw new XMLParseException(iOException.getMessage());
            }
            catch (TraceException traceException) {
                throw new XMLParseException(traceException.getMessage());
            }
        }

        @Override
        public String getParserDescription() {
            return "Performs a trace analysis.";
        }

        @Override
        public Class getReturnType() {
            return PathSamplingAnalysis.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private boolean logBayesFactorCalculated = false;
    private double logBayesFactor;
    private double innerArea;
    private final List<Double> logLikelihoodSample;
    private final List<Double> thetaSample;
    private List<Double> meanLogLikelihood;
    private List<Double> mlContribution;
    private final String logLikelihoodName;
    List<Double> orderedTheta;

    PathSamplingAnalysis(String string, List<Double> list, List<Double> list2) {
        this.logLikelihoodSample = list;
        this.logLikelihoodName = string;
        this.thetaSample = list2;
    }

    public double getLogBayesFactor() {
        if (!this.logBayesFactorCalculated) {
            this.calculateBF();
        }
        return this.logBayesFactor;
    }

    private void calculateBF() {
        HashMap hashMap = new HashMap();
        this.orderedTheta = new ArrayList<Double>();
        for (int i = 0; i < this.logLikelihoodSample.size(); ++i) {
            if (!hashMap.containsKey(this.thetaSample.get(i))) {
                hashMap.put(this.thetaSample.get(i), new ArrayList());
                this.orderedTheta.add(this.thetaSample.get(i));
            }
            ((List)hashMap.get(this.thetaSample.get(i))).add(this.logLikelihoodSample.get(i));
        }
        Collections.sort(this.orderedTheta);
        this.meanLogLikelihood = new ArrayList<Double>();
        for (double d : this.orderedTheta) {
            double d2 = 0.0;
            int n = 0;
            List list = (List)hashMap.get(d);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                double d3 = (Double)iterator.next();
                d2 += d3;
                ++n;
            }
            this.meanLogLikelihood.add(d2 / (double)n);
        }
        this.mlContribution = new ArrayList<Double>();
        this.logBayesFactor = 0.0;
        this.innerArea = 0.0;
        for (int i = 0; i < this.meanLogLikelihood.size() - 1; ++i) {
            double d;
            d = (this.meanLogLikelihood.get(i + 1) + this.meanLogLikelihood.get(i)) / 2.0 * (this.orderedTheta.get(i + 1) - this.orderedTheta.get(i));
            this.logBayesFactor += d;
            this.mlContribution.add(d);
            if (i <= 0 || i >= this.meanLogLikelihood.size() - 1) continue;
            this.innerArea += (this.meanLogLikelihood.get(i + 1) + this.meanLogLikelihood.get(i)) / 2.0 * (this.orderedTheta.get(i + 1) - this.orderedTheta.get(i));
        }
        this.logBayesFactorCalculated = true;
    }

    public String toString() {
        double d = this.getLogBayesFactor();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PathParameter\tMeanPathLikelihood\tMLContribution\n");
        for (int i = 0; i < this.orderedTheta.size(); ++i) {
            stringBuffer.append(String.format(FORMAT, this.orderedTheta.get(i)));
            stringBuffer.append("\t");
            stringBuffer.append(String.format(FORMAT, this.meanLogLikelihood.get(i)));
            stringBuffer.append("\t");
            if (i != this.orderedTheta.size() - 1) {
                stringBuffer.append(String.format(FORMAT, this.mlContribution.get(i)));
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nlog marginal likelihood (using path sampling) from " + this.logLikelihoodName + " = " + d + "\n");
        stringBuffer.append("\nInner area for path parameter in (" + String.format(FORMAT, this.orderedTheta.get(1)) + "," + String.format(FORMAT, this.orderedTheta.get(this.orderedTheta.size() - 2)) + ") = " + String.format(FORMAT, this.innerArea));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

