/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import dr.math.MathUtils;
import dr.math.MultivariateFunction;
import dr.math.MultivariateIntegral;
import java.util.Arrays;
import java.util.HashMap;

public class MultivariateMonteCarloIntegral
implements MultivariateIntegral {
    private int sampleSize;
    private int bins;

    public MultivariateMonteCarloIntegral(int n, int n2) {
        this.sampleSize = n;
        this.bins = n2;
    }

    public MultivariateMonteCarloIntegral(int n) {
        this(n, 1);
    }

    @Override
    public double integrate(MultivariateFunction multivariateFunction, double[] dArray, double[] dArray2) {
        int n = multivariateFunction.getNumArguments();
        int n2 = this.bins * n;
        double[] dArray3 = new double[n];
        double d = 1.0;
        for (int i = 0; i < n; ++i) {
            d *= dArray2[i] - dArray[i];
        }
        HashMap<Integer, double[]> hashMap = new HashMap<Integer, double[]>();
        double[] dArray4 = new double[n];
        block1: for (int i = 0; i < n2; ++i) {
            hashMap.put(i, Arrays.copyOf(dArray4, n));
            for (int j = 0; j < n; ++j) {
                if (dArray4[j] + dArray3[j] < dArray2[j]) {
                    int n3 = j;
                    dArray4[n3] = dArray4[n3] + dArray3[j];
                    continue block1;
                }
                dArray4[j] = dArray[j];
            }
        }
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 1; j <= this.sampleSize; ++j) {
                double[] dArray5 = new double[n];
                for (int k = 0; k < dArray5.length; ++k) {
                    dArray5[k] = ((double[])hashMap.get(i))[k] + MathUtils.nextDouble() * dArray3[k];
                }
                d2 += multivariateFunction.evaluate(dArray5);
            }
        }
        return d2 *= d / ((double)this.sampleSize * (double)n2);
    }

    protected int getSampleSize() {
        return this.sampleSize;
    }

    protected int getBins() {
        return this.bins;
    }
}

