/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import cern.jet.stat.Gamma;
import dr.math.distributions.KernelDensityEstimatorDistribution;
import dr.stats.DiscreteStatistics;
import java.util.Random;

public class GammaKDEDistribution
extends KernelDensityEstimatorDistribution {
    public GammaKDEDistribution(Double[] doubleArray) {
        this(doubleArray, null);
    }

    public GammaKDEDistribution(Double[] doubleArray, Double d) {
        super(doubleArray, 0.0, Double.POSITIVE_INFINITY, d);
    }

    @Override
    public double getFromPoint() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double getToPoint() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void processBounds(Double d, Double d2) {
        if (d > DiscreteStatistics.min(this.sample)) {
            throw new RuntimeException("Sample min out of bounds.  Gamma kernel for use with positive data only: " + DiscreteStatistics.min(this.sample));
        }
        if (d2 < DiscreteStatistics.max(this.sample)) {
            throw new RuntimeException("Sample max out of bounds" + DiscreteStatistics.max(this.sample));
        }
        this.lowerBound = d;
        this.upperBound = d2;
    }

    @Override
    protected void setBandWidth(Double d) {
        if (d == null) {
            double d2 = DiscreteStatistics.stdev(this.sample);
            this.bandWidth = d2 * Math.pow(this.N, -0.2);
        } else {
            this.bandWidth = d;
        }
    }

    @Override
    protected double evaluateKernel(double d) {
        double d2 = d >= 2.0 * this.bandWidth ? d / this.bandWidth : 0.25 * Math.pow(d / this.bandWidth, 2.0) + 1.0;
        double d3 = this.bandWidth;
        double d4 = 0.0;
        for (int i = 0; i < this.N; ++i) {
            d4 += Math.pow(this.sample[i], d2 - 1.0) * Math.exp(-this.sample[i] / d3) / (Math.pow(d3, d2) * this.gamma(d2));
        }
        return d4 / (double)this.N;
    }

    private double gamma(double d) {
        return Gamma.gamma(d);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        Random random = new Random(1234L);
        Double[] doubleArray = new Double[10000000];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = random.nextDouble();
        }
        GammaKDEDistribution gammaKDEDistribution = new GammaKDEDistribution(doubleArray);
        for (int i = 0; i < 100; ++i) {
            gammaKDEDistribution.evaluateKernel(random.nextDouble());
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Time: " + (l2 - l));
    }
}

