/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.branchratemodel.DefaultBranchRateModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.treelikelihood.AbstractTreeLikelihood;
import dr.oldevomodel.treelikelihood.ArbitraryPrecisionLikelihoodCore;
import dr.oldevomodel.treelikelihood.GeneralLikelihoodCore;
import dr.oldevomodel.treelikelihood.LikelihoodCore;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.math.BigDecimal;
import java.util.logging.Logger;

@Deprecated
public class PrecisionTestTreeLikelihood
extends AbstractTreeLikelihood {
    public static final String TREE_LIKELIHOOD = "precisionTestTreeLikelihood";
    public static final String USE_AMBIGUITIES = "useAmbiguities";
    public static final String ALLOW_MISSING_TAXA = "allowMissingTaxa";
    public static final String STORE_PARTIALS = "storePartials";
    public static final String USE_SCALING = "useScaling";
    public static final String FORCE_JAVA_CORE = "forceJavaCore";
    private double[] rootPartials = null;
    private BigDecimal[] precisionRootPartials = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("useAmbiguities", true), AttributeRule.newBooleanRule("allowMissingTaxa", true), AttributeRule.newBooleanRule("storePartials", true), new ElementRule(PatternList.class), new ElementRule(TreeModel.class), new ElementRule(SiteModel.class), new ElementRule(BranchRateModel.class, true)};

        @Override
        public String getParserName() {
            return PrecisionTestTreeLikelihood.TREE_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.getAttribute(PrecisionTestTreeLikelihood.USE_AMBIGUITIES, false);
            boolean bl2 = xMLObject.getAttribute(PrecisionTestTreeLikelihood.ALLOW_MISSING_TAXA, false);
            boolean bl3 = xMLObject.getAttribute(PrecisionTestTreeLikelihood.STORE_PARTIALS, true);
            PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            SiteModel siteModel = (SiteModel)xMLObject.getChild(SiteModel.class);
            BranchRateModel branchRateModel = (BranchRateModel)xMLObject.getChild(BranchRateModel.class);
            return new PrecisionTestTreeLikelihood(patternList, treeModel, siteModel, branchRateModel, bl, bl2, bl3);
        }

        @Override
        public String getParserDescription() {
            return "This element represents the likelihood of a patternlist on a tree given the site model.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    protected final FrequencyModel frequencyModel;
    protected final SiteModel siteModel;
    protected final BranchRateModel branchRateModel;
    private final boolean storePartials;
    protected int[] siteCategories = null;
    protected double[] patternLogLikelihoods = null;
    protected double[] precisionPatternLogLikelihoods = null;
    protected int categoryCount;
    protected double[] probabilities;
    protected LikelihoodCore likelihoodCore;
    protected ArbitraryPrecisionLikelihoodCore precisionLikelihoodCore;

    public PrecisionTestTreeLikelihood(PatternList patternList, TreeModel treeModel, SiteModel siteModel, BranchRateModel branchRateModel, boolean bl, boolean bl2, boolean bl3) {
        super(TREE_LIKELIHOOD, patternList, treeModel);
        this.storePartials = bl3;
        try {
            int n;
            this.siteModel = siteModel;
            this.addModel(siteModel);
            this.frequencyModel = siteModel.getFrequencyModel();
            this.addModel(this.frequencyModel);
            this.categoryCount = siteModel.getCategoryCount();
            Logger logger = Logger.getLogger("dr.evomodel");
            String string = "Java general";
            this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
            this.precisionLikelihoodCore = new ArbitraryPrecisionLikelihoodCore(patternList.getStateCount(), 20);
            logger.info("PrecisionTestTreeLikelihood using " + string + " likelihood core");
            logger.info("  " + (bl ? "Using" : "Ignoring") + " ambiguities in tree likelihood.");
            if (branchRateModel != null) {
                this.branchRateModel = branchRateModel;
                logger.info("Branch rate model used: " + branchRateModel.getModelName());
            } else {
                this.branchRateModel = new DefaultBranchRateModel();
            }
            this.addModel(this.branchRateModel);
            this.probabilities = new double[this.stateCount * this.stateCount];
            this.likelihoodCore.initialize(this.nodeCount, this.patternCount, this.categoryCount, true);
            this.precisionLikelihoodCore.initialize(this.nodeCount, this.patternCount, this.categoryCount, true);
            int n2 = treeModel.getExternalNodeCount();
            int n3 = treeModel.getInternalNodeCount();
            for (n = 0; n < n2; ++n) {
                String string2 = treeModel.getTaxonId(n);
                int n4 = patternList.getTaxonIndex(string2);
                if (n4 == -1) {
                    if (!bl2) {
                        throw new TaxonList.MissingTaxonException("Taxon, " + string2 + ", in tree, " + treeModel.getId() + ", is not found in patternList, " + patternList.getId());
                    }
                    if (bl) {
                        this.setMissingPartials(this.likelihoodCore, n);
                        this.setMissingPartials(this.precisionLikelihoodCore, n);
                        continue;
                    }
                    this.setMissingStates(this.likelihoodCore, n);
                    this.setMissingStates(this.precisionLikelihoodCore, n);
                    continue;
                }
                if (bl) {
                    this.setPartials(this.likelihoodCore, patternList, this.categoryCount, n4, n);
                    this.setPartials(this.precisionLikelihoodCore, patternList, this.categoryCount, n4, n);
                    continue;
                }
                this.setStates(this.likelihoodCore, patternList, n4, n);
                this.setStates(this.precisionLikelihoodCore, patternList, n4, n);
            }
            for (n = 0; n < n3; ++n) {
                this.likelihoodCore.createNodePartials(n2 + n);
                this.precisionLikelihoodCore.createNodePartials(n2 + n);
            }
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            if (object instanceof TreeChangedEvent) {
                if (((TreeChangedEvent)object).isNodeChanged()) {
                    this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                } else if (((TreeChangedEvent)object).isTreeChanged()) {
                    System.err.println("Full tree update event - these events currently aren't used\nso either this is in error or a new feature is using them so remove this message.");
                    this.updateAllNodes();
                }
            }
        } else if (model == this.branchRateModel) {
            if (n == -1) {
                this.updateAllNodes();
            } else {
                this.updateNode(this.treeModel.getNode(n));
            }
        } else if (model == this.frequencyModel) {
            this.updateAllNodes();
        } else if (model instanceof SiteModel) {
            this.updateAllNodes();
        } else {
            throw new RuntimeException("Unknown componentChangedEvent");
        }
        super.handleModelChangedEvent(model, object, n);
    }

    @Override
    protected void storeState() {
        if (this.storePartials) {
            this.likelihoodCore.storeState();
            this.precisionLikelihoodCore.storeState();
        }
        super.storeState();
    }

    @Override
    protected void restoreState() {
        if (this.storePartials) {
            this.likelihoodCore.restoreState();
            this.precisionLikelihoodCore.restoreState();
        } else {
            this.updateAllNodes();
        }
        super.restoreState();
    }

    @Override
    protected double calculateLogLikelihood() {
        int n;
        if (this.patternLogLikelihoods == null) {
            this.patternLogLikelihoods = new double[this.patternCount];
        }
        if (this.precisionPatternLogLikelihoods == null) {
            this.precisionPatternLogLikelihoods = new double[this.patternCount];
        }
        NodeRef nodeRef = this.treeModel.getRoot();
        this.traverse(this.treeModel, nodeRef);
        double d = 0.0;
        for (int i = 0; i < this.patternCount; ++i) {
            d += this.patternLogLikelihoods[i] * this.patternWeights[i];
        }
        double d2 = 0.0;
        for (n = 0; n < this.patternCount; ++n) {
            d2 += this.precisionPatternLogLikelihoods[n] * this.patternWeights[n];
        }
        if (Math.abs(d - d2) > 1.0E-5) {
            System.out.println("logL = " + d + " precision logL = " + d2);
        }
        if (d == Double.NEGATIVE_INFINITY) {
            this.likelihoodCore.setUseScaling(true);
            this.updateAllNodes();
            this.updateAllPatterns();
            this.traverse(this.treeModel, nodeRef);
            d = 0.0;
            for (n = 0; n < this.patternCount; ++n) {
                d += this.patternLogLikelihoods[n] * this.patternWeights[n];
            }
            if (Math.abs(d - d2) > 1.0E-5) {
                System.out.println("scaled logL = " + d + " precision logL = " + d2);
            }
        }
        for (n = 0; n < this.nodeCount; ++n) {
            this.updateNode[n] = false;
        }
        return d;
    }

    private boolean traverse(Tree tree, NodeRef nodeRef) {
        int n;
        boolean bl = false;
        int n2 = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nodeRef2 != null && this.updateNode[n2]) {
            double d = this.branchRateModel.getBranchRate(tree, nodeRef);
            double d2 = d * (tree.getNodeHeight(nodeRef2) - tree.getNodeHeight(nodeRef));
            if (d2 < 0.0) {
                throw new RuntimeException("Negative branch length: " + d2);
            }
            this.likelihoodCore.setNodeMatrixForUpdate(n2);
            this.precisionLikelihoodCore.setNodeMatrixForUpdate(n2);
            for (n = 0; n < this.categoryCount; ++n) {
                double d3 = this.siteModel.getRateForCategory(n) * d2;
                this.siteModel.getSubstitutionModel().getTransitionProbabilities(d3, this.probabilities);
                this.likelihoodCore.setNodeMatrix(n2, n, this.probabilities);
                this.precisionLikelihoodCore.setNodeMatrix(n2, n, this.probabilities);
            }
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            boolean bl2 = this.traverse(tree, nodeRef3);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            boolean bl3 = this.traverse(tree, nodeRef4);
            if (bl2 || bl3) {
                n = nodeRef3.getNumber();
                int n3 = nodeRef4.getNumber();
                this.likelihoodCore.setNodePartialsForUpdate(n2);
                this.precisionLikelihoodCore.setNodePartialsForUpdate(n2);
                this.likelihoodCore.calculatePartials(n, n3, n2);
                this.precisionLikelihoodCore.calculatePartials(n, n3, n2);
                if (nodeRef2 == null) {
                    double[] dArray = this.frequencyModel.getFrequencies();
                    double[] dArray2 = this.getRootPartials();
                    this.likelihoodCore.calculateLogLikelihoods(dArray2, dArray, this.patternLogLikelihoods);
                    BigDecimal[] bigDecimalArray = this.getPrecisionRootPartials();
                    this.precisionLikelihoodCore.calculateLogLikelihoods(bigDecimalArray, dArray, this.precisionPatternLogLikelihoods);
                }
                bl = true;
            }
        }
        return bl;
    }

    public final double[] getRootPartials() {
        if (this.rootPartials == null) {
            this.rootPartials = new double[this.patternCount * this.stateCount];
        }
        int n = this.treeModel.getRoot().getNumber();
        double[] dArray = this.siteModel.getCategoryProportions();
        this.likelihoodCore.integratePartials(n, dArray, this.rootPartials);
        return this.rootPartials;
    }

    public final BigDecimal[] getPrecisionRootPartials() {
        if (this.precisionRootPartials == null) {
            this.precisionRootPartials = new BigDecimal[this.patternCount * this.stateCount];
        }
        int n = this.treeModel.getRoot().getNumber();
        double[] dArray = this.siteModel.getCategoryProportions();
        this.precisionLikelihoodCore.integratePartials(n, dArray, this.precisionRootPartials);
        return this.precisionRootPartials;
    }
}

