/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Nucleotides;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.oldevomodel.sitemodel.GammaSiteModel;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.treelikelihood.AbstractTreeLikelihood;
import dr.oldevomodel.treelikelihood.AminoAcidLikelihoodCore;
import dr.oldevomodel.treelikelihood.GeneralLikelihoodCore;
import dr.oldevomodel.treelikelihood.LikelihoodCore;
import dr.oldevomodel.treelikelihood.NativeNucleotideLikelihoodCore;
import dr.oldevomodel.treelikelihood.NucleotideLikelihoodCore;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
public class PurifyingGammaTreeLikelihood
extends AbstractTreeLikelihood {
    public static final String PURIFYING_GAMMA_TREE_LIKELIHOOD = "purifyingGammaTreeLikelihood";
    public static final String SUBSTITUTION_MODEL = "substitutionModel";
    public static final String HALF_LIFE = "halfLife";
    public static final String SUBSTITUTION_RATE = "substitutionRate";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("substitutionRate", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("halfLife", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule(PatternList.class), new ElementRule(TreeModel.class), new ElementRule(GammaSiteModel.class)};

        @Override
        public String getParserName() {
            return PurifyingGammaTreeLikelihood.PURIFYING_GAMMA_TREE_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(PurifyingGammaTreeLikelihood.SUBSTITUTION_RATE);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(PurifyingGammaTreeLikelihood.HALF_LIFE);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            PatternList patternList = (PatternList)xMLObject.getChild(PatternList.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            GammaSiteModel gammaSiteModel = (GammaSiteModel)xMLObject.getChild(GammaSiteModel.class);
            try {
                return new PurifyingGammaTreeLikelihood(patternList, treeModel, gammaSiteModel, parameter, parameter2, false);
            }
            catch (TaxonList.MissingTaxonException missingTaxonException) {
                throw new XMLParseException(missingTaxonException.toString());
            }
        }

        @Override
        public String getParserDescription() {
            return "This element represents the likelihood of a patternlist on a tree given the site model.";
        }

        @Override
        public Class getReturnType() {
            return Likelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    protected FrequencyModel frequencyModel = null;
    protected GammaSiteModel siteModel = null;
    protected Parameter substitutionRateParameter = null;
    protected Parameter halfLifeParameter = null;
    private double[] nodeTimes = null;
    protected double[] branchRates = null;
    protected int[] siteCategories = null;
    protected double[] rootPartials = null;
    protected double[] patternLogLikelihoods = null;
    protected double[] gammaCategoryRates = null;
    protected int gammaCategoryCount;
    protected int categoryCount;
    protected double[] probabilities;
    protected LikelihoodCore likelihoodCore;

    public PurifyingGammaTreeLikelihood(PatternList patternList, TreeModel treeModel, GammaSiteModel gammaSiteModel, Parameter parameter, Parameter parameter2, boolean bl) throws TaxonList.MissingTaxonException {
        super(PURIFYING_GAMMA_TREE_LIKELIHOOD, patternList, treeModel);
        try {
            int n;
            this.siteModel = gammaSiteModel;
            this.addModel(gammaSiteModel);
            this.frequencyModel = gammaSiteModel.getFrequencyModel();
            this.addModel(this.frequencyModel);
            this.substitutionRateParameter = parameter;
            this.addVariable(parameter);
            this.halfLifeParameter = parameter2;
            this.addVariable(parameter2);
            this.categoryCount = this.gammaCategoryCount = gammaSiteModel.getCategoryCount();
            if (patternList.getDataType() instanceof Nucleotides) {
                if (NativeNucleotideLikelihoodCore.isAvailable()) {
                    System.out.println("TreeLikelihood using native nucleotide likelihood core.");
                    this.likelihoodCore = new NativeNucleotideLikelihoodCore();
                } else {
                    System.out.println("TreeLikelihood using Java nucleotide likelihood core.");
                    this.likelihoodCore = new NucleotideLikelihoodCore();
                }
            } else if (patternList.getDataType() instanceof AminoAcids) {
                System.out.println("TreeLikelihood using Java amino acid likelihood core.");
                this.likelihoodCore = new AminoAcidLikelihoodCore();
            } else {
                System.out.println("TreeLikelihood using Java general likelihood core.");
                this.likelihoodCore = new GeneralLikelihoodCore(patternList.getStateCount());
            }
            this.probabilities = new double[this.stateCount * this.stateCount];
            this.likelihoodCore.initialize(this.nodeCount, this.patternCount, this.categoryCount, true);
            int n2 = treeModel.getExternalNodeCount();
            int n3 = treeModel.getInternalNodeCount();
            for (n = 0; n < n2; ++n) {
                String string = treeModel.getTaxonId(n);
                int n4 = patternList.getTaxonIndex(string);
                if (n4 == -1) {
                    throw new TaxonList.MissingTaxonException("Taxon, " + string + ", in tree, " + treeModel.getId() + ", is not found in patternList, " + patternList.getId());
                }
                if (bl) {
                    this.setPartials(this.likelihoodCore, patternList, this.categoryCount, n4, n);
                    continue;
                }
                this.setStates(this.likelihoodCore, patternList, n4, n);
            }
            for (n = 0; n < n3; ++n) {
                this.likelihoodCore.createNodePartials(n2 + n);
            }
        }
        catch (TaxonList.MissingTaxonException missingTaxonException) {
            throw new RuntimeException(missingTaxonException.toString());
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.treeModel) {
            if (object instanceof TreeChangedEvent) {
                if (((TreeChangedEvent)object).isNodeChanged()) {
                    this.updateNodeAndChildren(((TreeChangedEvent)object).getNode());
                } else {
                    this.updateAllNodes();
                }
            }
        } else if (model == this.frequencyModel) {
            this.updateAllNodes();
        } else if (model instanceof SiteModel) {
            this.updateAllNodes();
        } else {
            throw new RuntimeException("Unknown componentChangedEvent");
        }
        super.handleModelChangedEvent(model, object, n);
    }

    public void handleParameterChangedEvent(Parameter parameter, int n) {
        if (parameter == this.substitutionRateParameter || parameter == this.halfLifeParameter) {
            this.updateAllNodes();
        }
    }

    @Override
    protected void storeState() {
        this.likelihoodCore.storeState();
        super.storeState();
    }

    @Override
    protected void restoreState() {
        this.likelihoodCore.restoreState();
        super.restoreState();
    }

    @Override
    protected double calculateLogLikelihood() {
        NodeRef nodeRef = this.treeModel.getRoot();
        if (this.rootPartials == null) {
            this.rootPartials = new double[this.patternCount * this.stateCount];
        }
        if (this.patternLogLikelihoods == null) {
            this.patternLogLikelihoods = new double[this.patternCount];
        }
        if (this.gammaCategoryRates == null) {
            this.gammaCategoryRates = new double[this.gammaCategoryCount];
        }
        for (int i = 0; i < this.gammaCategoryCount; ++i) {
            this.gammaCategoryRates[i] = this.siteModel.getRateForCategory(i);
        }
        double d = this.siteModel.getMutationRateParameter().getParameterValue(0);
        double d2 = this.substitutionRateParameter.getParameterValue(0);
        double d3 = Math.log(2.0) / this.halfLifeParameter.getParameterValue(0);
        if (this.nodeTimes == null) {
            this.nodeTimes = new double[this.treeModel.getNodeCount()];
        }
        this.calculateNodeTimes(this.treeModel, nodeRef);
        this.traverse(this.treeModel, nodeRef, d, d2, d3);
        for (int i = 0; i < this.nodeCount; ++i) {
            this.updateNode[i] = false;
        }
        double d4 = 0.0;
        for (int i = 0; i < this.patternCount; ++i) {
            d4 += this.patternLogLikelihoods[i] * this.patternWeights[i];
        }
        if (Double.isNaN(d4)) {
            throw new RuntimeException("Likelihood NaN");
        }
        return d4;
    }

    private double calculateNodeTimes(TreeModel treeModel, NodeRef nodeRef) {
        NodeRef nodeRef2 = treeModel.getParent(nodeRef);
        double d = 0.0;
        if (!treeModel.isExternal(nodeRef)) {
            NodeRef nodeRef3 = treeModel.getChild(nodeRef, 0);
            double d2 = this.calculateNodeTimes(treeModel, nodeRef3);
            NodeRef nodeRef4 = treeModel.getChild(nodeRef, 1);
            double d3 = this.calculateNodeTimes(treeModel, nodeRef4);
            d = (d2 + d3) / 2.0;
        }
        if (nodeRef2 == null) {
            return 0.0;
        }
        double d4 = treeModel.getNodeHeight(nodeRef2) - treeModel.getNodeHeight(nodeRef);
        double d5 = d + d4;
        this.nodeTimes[nodeRef.getNumber()] = d;
        return d5;
    }

    private double rateIntegral(double d, double d2, double d3, double d4) {
        return d3 * d - (d2 - d3) / d4 * (Math.exp(-d4 * d) - 1.0);
    }

    private boolean traverse(Tree tree, NodeRef nodeRef, double d, double d2, double d3) {
        boolean bl = false;
        int n = nodeRef.getNumber();
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (nodeRef2 != null && this.updateNode[n]) {
            double d4 = this.nodeTimes[nodeRef.getNumber()];
            double d5 = tree.getNodeHeight(nodeRef2) - tree.getNodeHeight(nodeRef);
            double d6 = d4 + d5;
            for (int i = 0; i < this.categoryCount; ++i) {
                double d7 = this.rateIntegral(d6, d, d2 * this.gammaCategoryRates[i], d3);
                if (d4 > 0.0) {
                    d7 -= this.rateIntegral(d4, d, d2 * this.gammaCategoryRates[i], d3);
                }
                this.siteModel.getTransitionProbabilities(d7, this.probabilities);
                this.likelihoodCore.setNodeMatrix(n, i, this.probabilities);
            }
            bl = true;
        }
        if (!tree.isExternal(nodeRef)) {
            NodeRef nodeRef3 = tree.getChild(nodeRef, 0);
            boolean bl2 = this.traverse(tree, nodeRef3, d, d2, d3);
            NodeRef nodeRef4 = tree.getChild(nodeRef, 1);
            boolean bl3 = this.traverse(tree, nodeRef4, d, d2, d3);
            if (bl2 || bl3) {
                int n2 = nodeRef3.getNumber();
                int n3 = nodeRef4.getNumber();
                this.likelihoodCore.calculatePartials(n2, n3, n);
                if (nodeRef2 == null) {
                    double[] dArray = this.frequencyModel.getFrequencies();
                    double[] dArray2 = this.siteModel.getCategoryProportions();
                    this.likelihoodCore.integratePartials(n, dArray2, this.rootPartials);
                    this.likelihoodCore.calculateLogLikelihoods(this.rootPartials, dArray, this.patternLogLikelihoods);
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("createElement not implemented");
    }
}

