/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public interface DataTable<T> {
    public int getColumnCount();

    public int getRowCount();

    public String[] getColumnLabels();

    public String[] getRowLabels();

    public T getColumn(int var1);

    public T getRow(int var1);

    public T[] getData();

    public static class Text
    implements DataTable<String[]> {
        private String[] columnLabels;
        private String[] rowLabels;
        private String[][] data;

        private Text(Reader reader, boolean bl, boolean bl2, boolean bl3) throws IOException {
            this(reader, bl, bl2, false, bl3);
        }

        private Text(Reader reader, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
            Object object;
            ArrayList<Object> arrayList;
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bl4 ? "," : "\t";
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                throw new IllegalArgumentException("Empty file");
            }
            int n = -1;
            if (bl) {
                String string3;
                arrayList = new ArrayList<Object>();
                object = new StringTokenizer(string2, string);
                if (bl2 && !string2.startsWith(string)) {
                    string3 = ((StringTokenizer)object).nextToken().trim();
                    if (bl3) {
                        arrayList.add(string3);
                    }
                }
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string3 = ((StringTokenizer)object).nextToken().trim();
                    arrayList.add(string3);
                }
                this.columnLabels = new String[arrayList.size()];
                arrayList.toArray(this.columnLabels);
                n = arrayList.size();
                string2 = bufferedReader.readLine();
            }
            arrayList = new ArrayList();
            object = new ArrayList();
            int n2 = 1;
            while (string2 != null) {
                Object object2;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
                if (n == -1) {
                    n = stringTokenizer.countTokens();
                    if (bl2) {
                        --n;
                    }
                }
                if (bl2) {
                    object2 = stringTokenizer.nextToken().trim();
                    arrayList.add(object2);
                }
                object2 = new String[n];
                int n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object2[n3] = stringTokenizer.nextToken().trim();
                    ++n3;
                }
                if (n3 != n - (bl3 ? 1 : 0)) {
                    throw new IllegalArgumentException("Wrong number of values on row " + (n2 + 1) + ", expecting " + n + " but actually " + n3);
                }
                object.add(object2);
                string2 = bufferedReader.readLine();
                ++n2;
            }
            if (bl2) {
                this.rowLabels = new String[arrayList.size()];
                arrayList.toArray(this.rowLabels);
            }
            this.data = new String[object.size()][];
            object.toArray((T[])this.data);
        }

        @Override
        public int getColumnCount() {
            return this.data[0].length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String[] getColumnLabels() {
            return this.columnLabels;
        }

        @Override
        public String[] getRowLabels() {
            return this.rowLabels;
        }

        @Override
        public String[] getColumn(int n) {
            String[] stringArray = new String[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                stringArray[i] = this.data[i][n];
            }
            return stringArray;
        }

        @Override
        public String[] getRow(int n) {
            return this.data[n];
        }

        public String[][] getData() {
            return this.data;
        }

        public static DataTable<String[]> parse(Reader reader) throws IOException {
            return new Text(reader, true, true, false);
        }

        public static DataTable<String[]> parse(Reader reader, boolean bl) throws IOException {
            return new Text(reader, true, true, bl);
        }

        public static DataTable<String[]> parse(Reader reader, boolean bl, boolean bl2) throws IOException {
            return new Text(reader, bl, bl2, false);
        }

        public static DataTable<String[]> parse(Reader reader, boolean bl, boolean bl2, boolean bl3) throws IOException {
            return new Text(reader, bl, bl2, bl3);
        }

        public static DataTable<String[]> parse(Reader reader, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
            return new Text(reader, bl, bl2, bl3, bl4);
        }
    }

    public static class Double
    implements DataTable<double[]> {
        private String[] columnLabels;
        private String[] rowLabels;
        private double[][] data;

        private Double(Reader reader, boolean bl, boolean bl2, boolean bl3) throws IOException {
            this(reader, bl, bl2, false, bl3);
        }

        private Double(Reader reader, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
            Object object;
            ArrayList<Object> arrayList;
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string2 = bufferedReader.readLine();
            if (string2 == null) {
                throw new IllegalArgumentException("Empty file");
            }
            int n = -1;
            String string3 = string = bl4 ? "," : "\t";
            if (bl) {
                String string4;
                arrayList = new ArrayList<Object>();
                object = new StringTokenizer(string2, string);
                if (bl2 && !string2.startsWith(string)) {
                    string4 = ((StringTokenizer)object).nextToken().trim();
                    if (bl3) {
                        arrayList.add(string4);
                    }
                }
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string4 = ((StringTokenizer)object).nextToken().trim();
                    arrayList.add(string4);
                }
                this.columnLabels = new String[arrayList.size()];
                arrayList.toArray(this.columnLabels);
                n = arrayList.size();
                string2 = bufferedReader.readLine();
            }
            arrayList = new ArrayList();
            object = new ArrayList();
            int n2 = 1;
            while (string2 != null) {
                Object object2;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
                if (n == -1) {
                    n = stringTokenizer.countTokens();
                    if (bl2) {
                        --n;
                    }
                }
                if (bl2) {
                    object2 = stringTokenizer.nextToken().trim();
                    arrayList.add(object2);
                }
                object2 = new double[n];
                int n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    try {
                        object2[n3] = java.lang.Double.valueOf(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        object2[n3] = java.lang.Double.NaN;
                    }
                    ++n3;
                }
                if (n3 != n - (bl3 ? 1 : 0)) {
                    throw new IllegalArgumentException("Wrong number of values on row " + (n2 + 1) + ", expecting " + n + " but actually " + n3);
                }
                object.add(object2);
                string2 = bufferedReader.readLine();
                ++n2;
            }
            if (bl2) {
                this.rowLabels = new String[arrayList.size()];
                arrayList.toArray(this.rowLabels);
            }
            this.data = new double[object.size()][];
            object.toArray((T[])this.data);
        }

        @Override
        public int getColumnCount() {
            return this.columnLabels.length;
        }

        @Override
        public int getRowCount() {
            return this.rowLabels.length;
        }

        @Override
        public String[] getColumnLabels() {
            return this.columnLabels;
        }

        @Override
        public String[] getRowLabels() {
            return this.rowLabels;
        }

        @Override
        public double[] getColumn(int n) {
            double[] dArray = new double[this.data.length];
            for (int i = 0; i < this.data.length; ++i) {
                dArray[i] = this.data[i][n];
            }
            return dArray;
        }

        @Override
        public double[] getRow(int n) {
            return this.data[n];
        }

        public double[][] getData() {
            return this.data;
        }

        public static DataTable<double[]> parse(Reader reader) throws IOException {
            return new Double(reader, true, true, false);
        }

        public static DataTable<double[]> parse(Reader reader, boolean bl) throws IOException {
            return new Double(reader, true, true, bl);
        }

        public static DataTable<double[]> parse(Reader reader, boolean bl, boolean bl2) throws IOException {
            return new Double(reader, bl, bl2, false);
        }

        public static DataTable<double[]> parse(Reader reader, boolean bl, boolean bl2, boolean bl3) throws IOException {
            return new Double(reader, bl, bl2, bl3);
        }
    }
}

