/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.math.matrixAlgebra.WrappedMatrix;
import dr.util.Transform;

public class LKJCholeskyTransformConstrained
extends Transform.MultivariateTransform {
    int dimVector;

    public LKJCholeskyTransformConstrained(int n) {
        super(n * (n - 1) / 2);
        this.dimVector = n;
    }

    @Override
    protected double[] inverse(double[] dArray) {
        for (int i = 0; i < this.dim; ++i) {
            assert (dArray[i] <= 1.0 && dArray[i] >= -1.0) : "CPCs must be between -1.0 and 1.0";
        }
        WrappedMatrix.WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix = new WrappedMatrix.WrappedStrictlyUpperTriangularMatrix(this.dimVector);
        WrappedMatrix.WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix2 = new WrappedMatrix.WrappedStrictlyUpperTriangularMatrix(dArray, this.dimVector, 1.0);
        for (int i = 1; i < this.dimVector; ++i) {
            double d = 1.0;
            for (int j = 0; j < i; ++j) {
                double d2 = wrappedStrictlyUpperTriangularMatrix2.get(j, i);
                wrappedStrictlyUpperTriangularMatrix.set(j, i, d2 * d);
                d *= Math.sqrt(1.0 - d2 * d2);
            }
        }
        return wrappedStrictlyUpperTriangularMatrix.getBuffer();
    }

    @Override
    protected double[] transform(double[] dArray) {
        WrappedMatrix.WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix = new WrappedMatrix.WrappedStrictlyUpperTriangularMatrix(dArray, this.dimVector);
        WrappedMatrix.WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix2 = new WrappedMatrix.WrappedStrictlyUpperTriangularMatrix(this.dimVector);
        for (int i = 1; i < this.dimVector; ++i) {
            double d = 1.0;
            for (int j = 0; j < i; ++j) {
                double d2 = wrappedStrictlyUpperTriangularMatrix.get(j, i) / d;
                wrappedStrictlyUpperTriangularMatrix2.set(j, i, d2);
                d *= Math.sqrt(1.0 - d2 * d2);
            }
        }
        return wrappedStrictlyUpperTriangularMatrix2.getBuffer();
    }

    @Override
    public boolean isInInteriorDomain(double[] dArray) {
        WrappedMatrix.WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix = new WrappedMatrix.WrappedStrictlyUpperTriangularMatrix(dArray, this.dimVector);
        if (Math.abs(wrappedStrictlyUpperTriangularMatrix.get(0, 0)) >= 1.0) {
            return false;
        }
        for (int i = 1; i < this.dimVector; ++i) {
            double d = 0.0;
            for (int j = 0; j < i; ++j) {
                d += Math.pow(wrappedStrictlyUpperTriangularMatrix.get(j, i), 2.0);
            }
            if (!(d >= 1.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("Not relevant for the LKJ transform.");
    }

    @Override
    public String getTransformName() {
        return "LKJCholeskyTransform";
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected double getLogJacobian(double[] dArray) {
        double[] dArray2 = this.transform(dArray);
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.dimVector - 2; ++i) {
            ++n;
            for (int j = i + 2; j < this.dimVector; ++j) {
                d += (double)(j - i - 1) * (Math.log1p(-dArray2[n]) + Math.log1p(dArray2[n]));
                ++n;
            }
        }
        return -0.5 * d;
    }

    @Override
    public double[] getGradientLogJacobianInverse(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        for (int i = 0; i < this.dimVector - 2; ++i) {
            ++n;
            for (int j = i + 2; j < this.dimVector; ++j) {
                dArray2[n] = (double)(-(j - i - 1)) * dArray[n] / (1.0 - Math.pow(dArray[n], 2.0));
                ++n;
            }
        }
        return dArray2;
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        double[][] dArray2 = new double[this.dim][this.dim];
        WrappedMatrix.WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix = new WrappedMatrix.WrappedStrictlyUpperTriangularMatrix(dArray, this.dimVector, 1.0);
        for (int i = 1; i < this.dimVector; ++i) {
            for (int j = 0; j < i; ++j) {
                this.recursionJacobian(dArray2, wrappedStrictlyUpperTriangularMatrix, j, i);
            }
        }
        return dArray2;
    }

    private void recursionJacobian(double[][] dArray, WrappedMatrix.WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix, int n, int n2) {
        int n3;
        WrappedMatrix.WrappedStrictlyUpperTriangularMatrix wrappedStrictlyUpperTriangularMatrix2 = new WrappedMatrix.WrappedStrictlyUpperTriangularMatrix(dArray[this.posStrict(n, n2)], this.dimVector);
        double d = 1.0;
        for (n3 = 0; n3 < n; ++n3) {
            d *= Math.sqrt(1.0 - Math.pow(wrappedStrictlyUpperTriangularMatrix.get(n3, n2), 2.0));
        }
        wrappedStrictlyUpperTriangularMatrix2.set(n, n2, d);
        double d2 = wrappedStrictlyUpperTriangularMatrix.get(n, n2);
        d *= -d2 / Math.sqrt(1.0 - Math.pow(d2, 2.0));
        for (n3 = n + 1; n3 < n2; ++n3) {
            d2 = wrappedStrictlyUpperTriangularMatrix.get(n3, n2);
            wrappedStrictlyUpperTriangularMatrix2.set(n3, n2, d2 * d);
            d *= Math.sqrt(1.0 - Math.pow(d2, 2.0));
        }
    }

    private int posStrict(int n, int n2) {
        return n * (2 * this.dimVector - n - 1) / 2 + (n2 - n - 1);
    }
}

