/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.util.Attribute;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class AttributeParser
extends AbstractXMLObjectParser {
    public static final String ATTRIBUTE = "attr";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("name", "The name to give to this attribute"), new ElementRule(Object.class)};

    @Override
    public String getParserName() {
        return ATTRIBUTE;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        String string = xMLObject.getStringAttribute(NAME);
        if (xMLObject.hasAttribute(VALUE)) {
            return new Attribute.Default<Object>(string, xMLObject.getAttribute(VALUE));
        }
        Object object = xMLObject.getChild(0);
        return new Attribute.Default<Object>(string, object);
    }

    @Override
    public String getParserDescription() {
        return "This element represents a name/value pair.";
    }

    @Override
    public Class getReturnType() {
        return Attribute.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

