/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.distances;

import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.distances.BasicDistanceMatrix;
import jebl.evolution.distances.CannotBuildDistanceMatrixException;
import jebl.evolution.distances.ModelBasedDistanceMatrix;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.State;
import jebl.util.ProgressListener;

public class TamuraNeiDistanceMatrix
extends BasicDistanceMatrix {
    public TamuraNeiDistanceMatrix(Alignment alignment, ProgressListener progress, boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) throws CannotBuildDistanceMatrixException {
        super(alignment.getTaxa(), new Initializer().getDistances(alignment, progress, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable));
    }

    public TamuraNeiDistanceMatrix(Alignment alignment, ProgressListener progress) throws CannotBuildDistanceMatrixException {
        this(alignment, progress, false);
    }

    static class Initializer
    extends ModelBasedDistanceMatrix
    implements BasicDistanceMatrix.PairwiseDistanceCalculator {
        private Alignment alignment;
        private double constA1;
        private double constA2;
        private double constC;

        Initializer() {
        }

        public double calculatePairwiseDistance(int taxon1, int taxon2) throws CannotBuildDistanceMatrixException {
            block13: {
                double a2;
                double a1;
                double Q;
                double sumTsAG = 0.0;
                double sumTsCT = 0.0;
                double sumTv = 0.0;
                double sumWeight = 0.0;
                boolean noGapsPairFound = false;
                for (Pattern pattern : this.alignment.getPatterns()) {
                    State state1 = pattern.getState(taxon1);
                    State state2 = pattern.getState(taxon2);
                    double weight = pattern.getWeight();
                    if (state1.isAmbiguous() || state2.isAmbiguous()) continue;
                    noGapsPairFound = true;
                    if (state1 != state2) {
                        if (Nucleotides.isTransition(state1, state2)) {
                            if (Nucleotides.isPurine(state1)) {
                                sumTsAG += weight;
                            } else {
                                sumTsCT += weight;
                            }
                        } else {
                            sumTv += weight;
                        }
                    }
                    sumWeight += weight;
                }
                if (!noGapsPairFound) {
                    throw new CannotBuildDistanceMatrixException("Tamura-Nei", this.getTaxonName(taxon1), this.getTaxonName(taxon2));
                }
                while (true) {
                    int adjustment;
                    double P1 = sumTsAG / sumWeight;
                    double P2 = sumTsCT / sumWeight;
                    Q = sumTv / sumWeight;
                    a1 = 1.0 - P1 * (1.0 / (2.0 * this.constA1)) - Q * (1.0 / (2.0 * this.freqR));
                    a2 = 1.0 - P2 * (1.0 / (2.0 * this.constA2)) - Q * (1.0 / (2.0 * this.freqY));
                    if (a1 <= 0.0) {
                        adjustment = (int)(1.0 + sumWeight * -a1 / (1.0 / (2.0 * this.constA1) - 1.0));
                        if (!((sumTsAG -= (double)adjustment) < 0.0)) {
                            sumWeight -= (double)adjustment;
                            continue;
                        }
                    } else {
                        if (!(a2 <= 0.0)) break;
                        adjustment = (int)(1.0 + sumWeight * -a2 / (1.0 / (2.0 * this.constA2) - 1.0));
                        if (!((sumTsCT -= (double)adjustment) < 0.0)) {
                            sumWeight -= (double)adjustment;
                            continue;
                        }
                    }
                    break block13;
                    break;
                }
                double b = 1.0 - Q / (2.0 * this.constC);
                if (!(b <= 0.0)) {
                    double distance = -2.0 * ((this.constC - this.constA1 * this.freqY - this.constA2 * this.freqR) * Math.log(b) + this.constA1 * Math.log(a1) + this.constA2 * Math.log(a2));
                    return Math.min(distance, 1000.0);
                }
            }
            return 1000.0;
        }

        private String getTaxonName(int index) {
            return this.alignment.getSequenceList().get(index).getTaxon().getName();
        }

        double[][] getDistances(Alignment alignment, ProgressListener progress, boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) throws CannotBuildDistanceMatrixException {
            this.alignment = alignment;
            int stateCount = alignment.getSequenceType().getCanonicalStateCount();
            if (stateCount != 4) {
                throw new IllegalArgumentException("Tamura NeiDistanceMatrix must have nucleotide patterns");
            }
            double[] freqs = this.getFrequenciesSafe(alignment);
            double freqA = freqs[Nucleotides.A_STATE.getIndex()];
            double freqC = freqs[Nucleotides.C_STATE.getIndex()];
            double freqG = freqs[Nucleotides.G_STATE.getIndex()];
            double freqT = freqs[Nucleotides.T_STATE.getIndex()];
            this.constA1 = freqA * (freqG / this.freqR);
            this.constA2 = freqT * (freqC / this.freqY);
            this.constC = this.freqR * this.freqY;
            assert (this.constA1 > 0.0 && this.constA2 > 0.0 && this.constC > 0.0);
            int dimension = alignment.getTaxa().size();
            return BasicDistanceMatrix.buildDistancesMatrix(this, dimension, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable, progress);
        }
    }
}

