/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.ConsensusTreeBuilder;
import jebl.evolution.trees.MutableRootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.FixedBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GreedyUnrootedConsensusTreeBuilder
extends ConsensusTreeBuilder<Tree> {
    private final Tree[] trees;
    private final Taxon outGroup;
    private final double supportThreshold;
    private final boolean debug = false;

    GreedyUnrootedConsensusTreeBuilder(Tree[] trees, Taxon outGroup, double supportThreshold) {
        super(trees);
        this.trees = trees;
        this.outGroup = outGroup;
        this.supportThreshold = supportThreshold;
    }

    GreedyUnrootedConsensusTreeBuilder(Tree[] trees, Taxon outGroup, double supportThreshold, String supportAttributeName, boolean asPercent) {
        super(trees, supportAttributeName, asPercent);
        this.trees = trees;
        this.outGroup = outGroup;
        this.supportThreshold = supportThreshold;
    }

    @Override
    public String getMethodDescription() {
        return this.getSupportDescription(this.supportThreshold) + " greedy clustering";
    }

    private String subTreeRep(Tree t, Node n, Node root) {
        if (t.isExternal(n)) {
            return t.getTaxon(n).getName();
        }
        StringBuilder b = new StringBuilder();
        for (Node x : t.getAdjacencies(n)) {
            if (x == root) continue;
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(this.subTreeRep(t, x, n));
        }
        return '(' + b.toString() + ')';
    }

    private String tipsAsText(FixedBitSet b) {
        String names = "(";
        int i = b.nextOnBit(0);
        while (i >= 0) {
            names = names + ((Taxon)this.taxons.get(i)).getName() + ",";
            i = b.nextOnBit(i + 1);
        }
        return names + ")";
    }

    @Override
    public final Tree build() {
        try {
            Map.Entry<FixedBitSet, Support> e;
            Support s;
            double psupport;
            LinkedHashMap<FixedBitSet, Support> support = new LinkedHashMap<FixedBitSet, Support>();
            double[] sumBranchesOfExternal = new double[this.taxons.size()];
            int nTree = 0;
            for (Tree tree : this.trees) {
                int initialCapacity = tree.getNodes().size();
                LinkedHashSet<Node> scanSet = new LinkedHashSet<Node>(initialCapacity);
                LinkedHashMap<Node, FixedBitSet> doneSet = new LinkedHashMap<Node, FixedBitSet>(initialCapacity);
                for (Node n : tree.getExternalNodes()) {
                    FixedBitSet b = new FixedBitSet(this.nExternalNodes);
                    int position = this.taxons.indexOf(tree.getTaxon(n));
                    b.set(position);
                    doneSet.put(n, b);
                    for (Node a : tree.getAdjacencies(n)) {
                        scanSet.add(a);
                    }
                    int n2 = position;
                    sumBranchesOfExternal[n2] = sumBranchesOfExternal[n2] + tree.getEdgeLength(n, tree.getAdjacencies(n).get(0));
                }
                int nInternalEdges = this.nExternalNodes - 3;
                ArrayList<Node> intr = new ArrayList<Node>(tree.getInternalNodes());
                while (scanSet.size() > 0) {
                    LinkedHashSet<Node> nextScanSet = new LinkedHashSet<Node>(initialCapacity);
                    for (Node n : scanSet) {
                        int nDone = 0;
                        List<Node> adjacencies = tree.getAdjacencies(n);
                        for (Node a : adjacencies) {
                            if (!doneSet.containsKey(a)) continue;
                            ++nDone;
                        }
                        if (nDone + 1 < adjacencies.size()) {
                            nextScanSet.add(n);
                            continue;
                        }
                        if (nDone < adjacencies.size()) {
                            Support s2;
                            FixedBitSet b = new FixedBitSet(this.nExternalNodes);
                            Node notDone = null;
                            for (Node a : adjacencies) {
                                if (doneSet.containsKey(a)) {
                                    FixedBitSet subSet = (FixedBitSet)doneSet.get(a);
                                    if (subSet == null) assert (false);
                                    b.union(subSet);
                                    continue;
                                }
                                notDone = a;
                            }
                            double branch = tree.getEdgeLength(n, notDone);
                            doneSet.put(n, new FixedBitSet(b));
                            nextScanSet.remove(n);
                            if (!b.contains(0)) {
                                b.complement();
                            }
                            if ((s2 = (Support)support.get(b)) == null) {
                                s2 = new Support();
                                support.put(b, s2);
                            }
                            s2.add(branch);
                            --nInternalEdges;
                            nextScanSet.add(notDone);
                            continue;
                        }
                        doneSet.put(n, null);
                    }
                    scanSet = nextScanSet;
                }
                if (!this.fireSetProgress(0.9 * (double)(++nTree) / (double)this.trees.length)) continue;
                return null;
            }
            Comparator<Map.Entry<FixedBitSet, Support>> comparator = new Comparator<Map.Entry<FixedBitSet, Support>>(){

                @Override
                public int compare(Map.Entry<FixedBitSet, Support> o1, Map.Entry<FixedBitSet, Support> o2) {
                    return o2.getValue().nTreesWithClade - o1.getValue().nTreesWithClade;
                }
            };
            PriorityQueue<Map.Entry<FixedBitSet, Support>> queue = new PriorityQueue<Map.Entry<FixedBitSet, Support>>(support.size(), comparator);
            for (Map.Entry s3 : support.entrySet()) {
                queue.add(s3);
            }
            MutableRootedTree consTree = new MutableRootedTree();
            ArrayList<Node> internalNodes = new ArrayList<Node>(this.nExternalNodes);
            ArrayList<FixedBitSet> internalNodesTips = new ArrayList<FixedBitSet>(this.nExternalNodes);
            assert (this.taxons.size() == this.nExternalNodes);
            internalNodesTips.add(new FixedBitSet(this.nExternalNodes));
            Node[] nodes = new Node[this.nExternalNodes];
            for (int nt = 0; nt < this.taxons.size(); ++nt) {
                nodes[nt] = consTree.createExternalNode((Taxon)this.taxons.get(nt));
                ((FixedBitSet)internalNodesTips.get(0)).set(nt);
            }
            internalNodes.add(consTree.createInternalNode(Arrays.asList(nodes)));
            while (queue.peek() != null && !((psupport = 1.0 * (double)(s = (e = queue.poll()).getValue()).nTreesWithClade / (double)this.trees.length) < this.supportThreshold)) {
                FixedBitSet splitTips = e.getKey();
                boolean found = false;
                for (int nsub = internalNodesTips.size() - 1; nsub >= 0; --nsub) {
                    int nSplit = ((FixedBitSet)internalNodesTips.get(nsub)).intersectCardinality(splitTips);
                    FixedBitSet allNodeTips = (FixedBitSet)internalNodesTips.get(nsub);
                    if (nSplit <= 0 || nSplit >= allNodeTips.cardinality()) continue;
                    FixedBitSet sharedTips = new FixedBitSet(allNodeTips);
                    sharedTips.intersect(splitTips);
                    if (!sharedTips.equals(splitTips)) {
                        sharedTips.complement();
                        sharedTips.intersect(allNodeTips);
                        if (!sharedTips.equals(FixedBitSet.complement(splitTips))) continue;
                    }
                    found = true;
                    ArrayList<Integer> split = new ArrayList<Integer>();
                    Node n = (Node)internalNodes.get(nsub);
                    int l = 0;
                    List<Node> children = consTree.getChildren(n);
                    for (Node ch : children) {
                        if (consTree.isExternal(ch)) {
                            if (sharedTips.contains(this.taxons.indexOf(consTree.getTaxon(ch)))) {
                                split.add(l);
                            }
                        } else {
                            int o = internalNodes.indexOf(ch);
                            int i = ((FixedBitSet)internalNodesTips.get(o)).intersectCardinality(sharedTips);
                            if (i == ((FixedBitSet)internalNodesTips.get(o)).cardinality()) {
                                split.add(l);
                            } else if (i > 0) {
                                found = false;
                                break;
                            }
                        }
                        ++l;
                    }
                    if (!found || split.size() >= children.size()) {
                        found = false;
                        break;
                    }
                    if (split.size() == 0) {
                        System.out.println("Bug??");
                        assert (false);
                    }
                    Node detached = consTree.detachChildren(n, split);
                    double length = s.sumBranches / (double)s.nTreesWithClade;
                    consTree.setLength(detached, length);
                    detached.setAttribute(this.getSupportAttributeName(), this.isSupportAsPercent() ? 100.0 * psupport : psupport);
                    internalNodes.add(nsub + 1, detached);
                    internalNodesTips.add(nsub + 1, new FixedBitSet(sharedTips));
                    break;
                }
                if (!(psupport >= 0.5) || found) continue;
                System.out.println("Bug??");
                assert (false);
            }
            for (int nt = 0; nt < this.taxons.size(); ++nt) {
                Node n = consTree.getNode((Taxon)this.taxons.get(nt));
                consTree.setLength(n, sumBranchesOfExternal[nt] / (double)this.trees.length);
            }
            if (this.outGroup != null) {
                Node out = consTree.getNode(this.outGroup);
                LinkedHashSet<String> a = new LinkedHashSet<String>();
                a.add(this.getSupportAttributeName());
                consTree.reRootWithOutgroup(out, a);
            }
            consTree.setConceptuallyUnrooted(true);
            this.fireSetProgress(1.0);
            return consTree;
        }
        catch (Graph.NoEdgeException noEdgeException) {
            return null;
        }
    }

    static final class Support {
        private int nTreesWithClade = 0;
        private double sumBranches = 0.0;

        Support() {
        }

        public final void add(double branch) {
            this.sumBranches += branch;
            ++this.nTreesWithClade;
        }
    }
}

