/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Arrays;
import no.uib.cipr.matrix.sparse.CompRowMatrix;
import no.uib.cipr.matrix.sparse.Preconditioner;
import no.uib.cipr.matrix.sparse.UnitLowerCompRowMatrix;
import no.uib.cipr.matrix.sparse.UpperCompRowMatrix;

public class ILU
implements Preconditioner {
    private final CompRowMatrix LU;
    private Matrix L;
    private Matrix U;
    private final Vector y;

    public ILU(CompRowMatrix LU) {
        if (!LU.isSquare()) {
            throw new IllegalArgumentException("ILU only applies to square matrices");
        }
        this.LU = LU;
        int n = LU.numRows();
        this.y = new DenseVector(n);
    }

    public Vector apply(Vector b, Vector x) {
        this.L.solve(b, this.y);
        return this.U.solve(this.y, x);
    }

    public Vector transApply(Vector b, Vector x) {
        this.U.transSolve(b, this.y);
        return this.L.transSolve(this.y, x);
    }

    public void setMatrix(Matrix A) {
        this.LU.set(A);
        this.factor();
    }

    private void factor() {
        int n = this.LU.numRows();
        int[] colind = this.LU.getColumnIndices();
        int[] rowptr = this.LU.getRowPointers();
        double[] data = this.LU.getData();
        int[] diagind = this.findDiagonalIndices(n, colind, rowptr);
        for (int k = 1; k < n; ++k) {
            for (int i = rowptr[k]; i < diagind[k]; ++i) {
                int index = colind[i];
                double LUii = data[diagind[index]];
                if (LUii == 0.0) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i + 1) + " during ILU process");
                }
                int n2 = i;
                double d = data[n2] / LUii;
                data[n2] = d;
                double LUki = d;
                int l = rowptr[k] + 1;
                for (int j = diagind[index] + 1; j < rowptr[index + 1]; ++j) {
                    while (l < rowptr[k + 1] && colind[l] < colind[j]) {
                        ++l;
                    }
                    if (colind[l] != colind[j]) continue;
                    int n3 = l;
                    data[n3] = data[n3] - LUki * data[j];
                }
            }
        }
        this.L = new UnitLowerCompRowMatrix(this.LU, diagind);
        this.U = new UpperCompRowMatrix(this.LU, diagind);
    }

    private int[] findDiagonalIndices(int m, int[] colind, int[] rowptr) {
        int[] diagind = new int[m];
        for (int k = 0; k < m; ++k) {
            diagind[k] = Arrays.binarySearch(colind, k, rowptr[k], rowptr[k + 1]);
            if (diagind[k] >= 0) continue;
            throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
        }
        return diagind;
    }
}

