/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.io;

import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.VectorInfo;
import cern.colt.matrix.io.VectorSize;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.LinkedList;

public class MatrixVectorReader
extends BufferedReader {
    private StreamTokenizer st;

    public MatrixVectorReader(Reader reader) {
        super(reader);
        this.setup();
    }

    public MatrixVectorReader(Reader reader, int n) {
        super(reader, n);
        this.setup();
    }

    private void setup() {
        this.st = new StreamTokenizer(this);
        this.st.resetSyntax();
        this.st.eolIsSignificant(false);
        this.st.lowerCaseMode(true);
        this.st.wordChars(48, 57);
        this.st.wordChars(45, 46);
        this.st.wordChars(0, 255);
        this.st.commentChar(37);
        this.st.whitespaceChars(32, 32);
        this.st.whitespaceChars(9, 14);
    }

    public void add(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] + n;
        }
    }

    private String readTrimmedLine() throws IOException {
        String string = this.readLine();
        if (string != null) {
            return string.trim();
        }
        throw new EOFException();
    }

    public MatrixInfo readMatrixInfo() throws IOException {
        String[] stringArray = this.readTrimmedLine().split(" +");
        if (stringArray.length != 5) {
            throw new IOException("Current line unparsable. It must consist of 5 tokens");
        }
        if (!stringArray[0].equalsIgnoreCase("%%MatrixMarket")) {
            throw new IOException("Not in Matrix Market exchange format");
        }
        if (!stringArray[1].equalsIgnoreCase("matrix")) {
            throw new IOException("Expected \"matrix\", got " + stringArray[1]);
        }
        boolean bl = false;
        if (stringArray[2].equalsIgnoreCase("coordinate")) {
            bl = true;
        } else if (stringArray[2].equalsIgnoreCase("array")) {
            bl = false;
        } else {
            throw new IOException("Unknown layout " + stringArray[2]);
        }
        MatrixInfo.MatrixField matrixField = null;
        if (stringArray[3].equalsIgnoreCase("real")) {
            matrixField = MatrixInfo.MatrixField.Real;
        } else if (stringArray[3].equalsIgnoreCase("integer")) {
            matrixField = MatrixInfo.MatrixField.Integer;
        } else if (stringArray[3].equalsIgnoreCase("complex")) {
            matrixField = MatrixInfo.MatrixField.Complex;
        } else if (stringArray[3].equalsIgnoreCase("pattern")) {
            matrixField = MatrixInfo.MatrixField.Pattern;
        } else {
            throw new IOException("Unknown field specification " + stringArray[3]);
        }
        MatrixInfo.MatrixSymmetry matrixSymmetry = null;
        if (stringArray[4].equalsIgnoreCase("general")) {
            matrixSymmetry = MatrixInfo.MatrixSymmetry.General;
        } else if (stringArray[4].equalsIgnoreCase("symmetric")) {
            matrixSymmetry = MatrixInfo.MatrixSymmetry.Symmetric;
        } else if (stringArray[4].equalsIgnoreCase("skew-symmetric")) {
            matrixSymmetry = MatrixInfo.MatrixSymmetry.SkewSymmetric;
        } else if (stringArray[4].equalsIgnoreCase("Hermitian")) {
            matrixSymmetry = MatrixInfo.MatrixSymmetry.Hermitian;
        } else {
            throw new IOException("Unknown symmetry specification " + stringArray[4]);
        }
        return new MatrixInfo(bl, matrixField, matrixSymmetry);
    }

    public VectorInfo readVectorInfo() throws IOException {
        String[] stringArray = this.readTrimmedLine().split(" +");
        if (stringArray.length != 4) {
            throw new IOException("Current line unparsable. It must consist of 4 tokens");
        }
        if (!stringArray[0].equalsIgnoreCase("%%MatrixMarket")) {
            throw new IOException("Not in Matrix Market exchange format");
        }
        if (!stringArray[1].equalsIgnoreCase("vector")) {
            throw new IOException("Expected \"vector\", got " + stringArray[1]);
        }
        boolean bl = false;
        if (stringArray[2].equalsIgnoreCase("coordinate")) {
            bl = true;
        } else if (stringArray[2].equalsIgnoreCase("array")) {
            bl = false;
        } else {
            throw new IOException("Unknown layout " + stringArray[2]);
        }
        VectorInfo.VectorField vectorField = null;
        if (stringArray[3].equalsIgnoreCase("real")) {
            vectorField = VectorInfo.VectorField.Real;
        } else if (stringArray[3].equalsIgnoreCase("integer")) {
            vectorField = VectorInfo.VectorField.Integer;
        } else if (stringArray[3].equalsIgnoreCase("complex")) {
            vectorField = VectorInfo.VectorField.Complex;
        } else if (stringArray[3].equalsIgnoreCase("pattern")) {
            vectorField = VectorInfo.VectorField.Pattern;
        } else {
            throw new IOException("Unknown field specification " + stringArray[3]);
        }
        return new VectorInfo(bl, vectorField);
    }

    public boolean hasInfo() throws IOException {
        this.mark(1024);
        String[] stringArray = this.readTrimmedLine().split(" +");
        this.reset();
        return stringArray[0].equalsIgnoreCase("%%MatrixMarket");
    }

    public String[] readComments() throws IOException {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (true) {
            this.mark(1024);
            String string = this.readTrimmedLine();
            if (string.length() <= 0) continue;
            if (string.charAt(0) != '%') break;
            linkedList.add(string.substring(1));
        }
        this.reset();
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public MatrixSize readMatrixSize(MatrixInfo matrixInfo) throws IOException {
        int n = this.getInt();
        int n2 = this.getInt();
        if (matrixInfo.isDense()) {
            return new MatrixSize(n, n2, matrixInfo);
        }
        int n3 = this.getInt();
        return new MatrixSize(n, n2, n3);
    }

    public MatrixSize readArraySize() throws IOException {
        int n = this.getInt();
        int n2 = this.getInt();
        return new MatrixSize(n, n2, n * n2);
    }

    public MatrixSize readCoordinateSize() throws IOException {
        int n = this.getInt();
        int n2 = this.getInt();
        int n3 = this.getInt();
        return new MatrixSize(n, n2, n3);
    }

    public VectorSize readVectorSize(VectorInfo vectorInfo) throws IOException {
        int n = this.getInt();
        if (vectorInfo.isDense()) {
            return new VectorSize(n);
        }
        int n2 = this.getInt();
        return new VectorSize(n, n2);
    }

    public VectorSize readVectorArraySize() throws IOException {
        int n = this.getInt();
        return new VectorSize(n);
    }

    public VectorSize readVectorCoordinateSize() throws IOException {
        int n = this.getInt();
        int n2 = this.getInt();
        return new VectorSize(n, n2);
    }

    public void readArray(double[] dArray) throws IOException {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getDouble();
        }
    }

    public void readArray(float[] fArray) throws IOException {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.getFloat();
        }
    }

    public void readArray(int[] nArray) throws IOException {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt();
        }
    }

    public void readArray(long[] lArray) throws IOException {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.getLong();
        }
    }

    public void readArray(double[] dArray, double[] dArray2) throws IOException {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.getDouble();
            dArray2[i] = this.getDouble();
        }
    }

    public void readArray(float[] fArray, float[] fArray2) throws IOException {
        int n = fArray.length;
        if (n != fArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.getFloat();
            fArray2[i] = this.getFloat();
        }
    }

    public void readCoordinate(int[] nArray, double[] dArray) throws IOException {
        int n = nArray.length;
        if (n != dArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            dArray[i] = this.getDouble();
        }
    }

    public void readCoordinate(int[] nArray, float[] fArray) throws IOException {
        int n = nArray.length;
        if (n != fArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            fArray[i] = this.getFloat();
        }
    }

    public void readCoordinate(int[] nArray, int[] nArray2) throws IOException {
        int n = nArray.length;
        if (n != nArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            nArray2[i] = this.getInt();
        }
    }

    public void readCoordinate(int[] nArray, long[] lArray) throws IOException {
        int n = nArray.length;
        if (n != lArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            lArray[i] = this.getLong();
        }
    }

    public void readCoordinate(int[] nArray, float[] fArray, float[] fArray2) throws IOException {
        int n = nArray.length;
        if (n != fArray.length || n != fArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            fArray[i] = this.getFloat();
            fArray2[i] = this.getFloat();
        }
    }

    public void readCoordinate(int[] nArray, double[] dArray, double[] dArray2) throws IOException {
        int n = nArray.length;
        if (n != dArray.length || n != dArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            dArray[i] = this.getDouble();
            dArray2[i] = this.getDouble();
        }
    }

    public void readPattern(int[] nArray) throws IOException {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
        }
    }

    public void readCoordinate(int[] nArray, int[] nArray2, double[] dArray) throws IOException {
        int n = nArray.length;
        if (n != nArray2.length || n != dArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            nArray2[i] = this.getInt() - 1;
            dArray[i] = this.getDouble();
        }
    }

    public void readCoordinate(int[] nArray, int[] nArray2, float[] fArray) throws IOException {
        int n = nArray.length;
        if (n != nArray2.length || n != fArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            nArray2[i] = this.getInt() - 1;
            fArray[i] = this.getFloat();
        }
    }

    public void readCoordinate(int[] nArray, int[] nArray2, int[] nArray3) throws IOException {
        int n = nArray.length;
        if (n != nArray2.length || n != nArray3.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            nArray2[i] = this.getInt() - 1;
            nArray3[i] = this.getInt();
        }
    }

    public void readCoordinate(int[] nArray, int[] nArray2, long[] lArray) throws IOException {
        int n = nArray.length;
        if (n != nArray2.length || n != lArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            nArray2[i] = this.getInt() - 1;
            lArray[i] = this.getLong();
        }
    }

    public void readPattern(int[] nArray, int[] nArray2) throws IOException {
        int n = nArray.length;
        if (n != nArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            nArray2[i] = this.getInt() - 1;
        }
    }

    public void readCoordinate(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) throws IOException {
        int n = nArray.length;
        if (n != nArray2.length || n != dArray.length || n != dArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            nArray2[i] = this.getInt() - 1;
            dArray[i] = this.getDouble();
            dArray2[i] = this.getDouble();
        }
    }

    public void readCoordinate(int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) throws IOException {
        int n = nArray.length;
        if (n != nArray2.length || n != fArray.length || n != fArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.getInt() - 1;
            nArray2[i] = this.getInt() - 1;
            fArray[i] = this.getFloat();
            fArray2[i] = this.getFloat();
        }
    }

    private int getInt() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Integer.parseInt(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private long getLong() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Long.parseLong(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private double getDouble() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Double.parseDouble(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }

    private float getFloat() throws IOException {
        this.st.nextToken();
        if (this.st.ttype == -3) {
            return Float.parseFloat(this.st.sval);
        }
        if (this.st.ttype == -1) {
            throw new EOFException("End-of-File encountered during parsing");
        }
        throw new IOException("Unknown token found during parsing");
    }
}

