/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import junit.framework.TestCase;

public abstract class DComplexMatrix1DTest
extends TestCase {
    protected DComplexMatrix1D A;
    protected DComplexMatrix1D B;
    protected int SIZE = 170;
    protected double TOL = 1.0E-10;
    protected DoubleFunctions F = DoubleFunctions.functions;

    public DComplexMatrix1DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        ConcurrencyUtils.setThreadsBeginN_1D(1);
        for (n = 0; n < (int)this.A.size(); ++n) {
            this.A.setQuick(n, new double[]{Math.random(), Math.random()});
        }
        for (n = 0; n < (int)this.A.size(); ++n) {
            this.B.setQuick(n, new double[]{Math.random(), Math.random()});
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunction() {
        double[] dArray = new double[2];
        for (int i = 0; i < (int)this.A.size(); ++i) {
            dArray = DComplex.plus(dArray, DComplex.square(this.A.getQuick(i)));
        }
        double[] dArray2 = this.A.aggregate(DComplexFunctions.plus, DComplexFunctions.square);
        this.assertEquals(dArray, dArray2, this.TOL);
    }

    public void testAggregateComplexMatrix1DComplexComplexFunctionComplexComplexFunction() {
        double[] dArray = this.A.aggregate(this.B, DComplexFunctions.plus, DComplexFunctions.mult);
        double[] dArray2 = new double[2];
        for (int i = 0; i < (int)this.A.size(); ++i) {
            dArray2 = DComplex.plus(dArray2, DComplex.mult(this.A.getQuick(i), this.B.getQuick(i)));
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    public void testAssignComplexComplexFunction() {
        DComplexMatrix1D dComplexMatrix1D = this.A.copy();
        this.A.assign(DComplexFunctions.acos);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double[] dArray = DComplex.acos(dComplexMatrix1D.getQuick(i));
            this.assertEquals(dArray, this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexMatrix1D() {
        this.A.assign(this.B);
        DComplexMatrix1DTest.assertTrue((this.A.size() == this.B.size() ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(this.B.getQuick(i), this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexMatrix1DComplexComplexFunction() {
        DComplexMatrix1D dComplexMatrix1D = this.A.copy();
        this.A.assign(this.B, DComplexFunctions.div);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(DComplex.div(dComplexMatrix1D.getQuick(i), this.B.getQuick(i)), this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexProcedureComplexComplexFunction() {
        DComplexProcedure dComplexProcedure = new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 0.1;
            }
        };
        DComplexMatrix1D dComplexMatrix1D = this.A.copy();
        this.A.assign(dComplexProcedure, DComplexFunctions.tan);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if (DComplex.abs(dComplexMatrix1D.getQuick(i)) > 0.1) {
                this.assertEquals(DComplex.tan(dComplexMatrix1D.getQuick(i)), this.A.getQuick(i), this.TOL);
                continue;
            }
            this.assertEquals(dComplexMatrix1D.getQuick(i), this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexProcedureDoubleArray() {
        DComplexProcedure dComplexProcedure = new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return DComplex.abs(dArray) > 0.1;
            }
        };
        DComplexMatrix1D dComplexMatrix1D = this.A.copy();
        double[] dArray = new double[]{-1.0, -1.0};
        this.A.assign(dComplexProcedure, dArray);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if (DComplex.abs(dComplexMatrix1D.getQuick(i)) > 0.1) {
                this.assertEquals(dArray, this.A.getQuick(i), this.TOL);
                continue;
            }
            this.assertEquals(dComplexMatrix1D.getQuick(i), this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexRealFunction() {
        DComplexMatrix1D dComplexMatrix1D = this.A.copy();
        this.A.assign(DComplexFunctions.abs);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double[] dArray = this.A.getQuick(i);
            DComplexMatrix1DTest.assertEquals((double)DComplex.abs(dComplexMatrix1D.getQuick(i)), (double)dArray[0], (double)this.TOL);
            DComplexMatrix1DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
        }
    }

    public void testAssignDoubleArray() {
        int n;
        double[] dArray = new double[2 * (int)this.A.size()];
        for (n = 0; n < 2 * (int)this.A.size(); ++n) {
            dArray[n] = Math.random();
        }
        this.A.assign(dArray);
        for (n = 0; n < (int)this.A.size(); ++n) {
            double[] dArray2 = this.A.getQuick(n);
            DComplexMatrix1DTest.assertEquals((double)dArray[2 * n], (double)dArray2[0], (double)this.TOL);
            DComplexMatrix1DTest.assertEquals((double)dArray[2 * n + 1], (double)dArray2[1], (double)this.TOL);
        }
    }

    public void testAssignDoubleDouble() {
        double d = Math.random();
        double d2 = Math.random();
        this.A.assign(d, d2);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double[] dArray = this.A.getQuick(i);
            DComplexMatrix1DTest.assertEquals((double)d, (double)dArray[0], (double)this.TOL);
            DComplexMatrix1DTest.assertEquals((double)d2, (double)dArray[1], (double)this.TOL);
        }
    }

    public void testAssignImaginary() {
        DComplexMatrix1D dComplexMatrix1D = this.A.copy();
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.random((int)this.A.size());
        this.A.assignImaginary(doubleMatrix1D);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double[] dArray = this.A.getQuick(i);
            DComplexMatrix1DTest.assertEquals((double)dComplexMatrix1D.getQuick(i)[0], (double)dArray[0], (double)this.TOL);
            DComplexMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)dArray[1], (double)this.TOL);
        }
    }

    public void testAssignReal() {
        DComplexMatrix1D dComplexMatrix1D = this.A.copy();
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.random((int)this.A.size());
        this.A.assignReal(doubleMatrix1D);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double[] dArray = this.A.getQuick(i);
            DComplexMatrix1DTest.assertEquals((double)dComplexMatrix1D.getQuick(i)[1], (double)dArray[1], (double)this.TOL);
            DComplexMatrix1DTest.assertEquals((double)doubleMatrix1D.getQuick(i), (double)dArray[0], (double)this.TOL);
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DComplexMatrix1DTest.assertEquals((int)((int)this.A.size()), (int)n);
    }

    public void testEqualsDouble() {
        double[] dArray = new double[]{1.0, 2.0};
        this.A.assign(dArray[0], dArray[1]);
        boolean bl = this.A.equals(dArray);
        DComplexMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(new double[]{2.0, 2.0});
        DComplexMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        DComplexMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        DComplexMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testGetImaginaryPart() {
        DoubleMatrix1D doubleMatrix1D = this.A.getImaginaryPart();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DComplexMatrix1DTest.assertEquals((double)this.A.getQuick(i)[1], (double)doubleMatrix1D.getQuick(i), (double)this.TOL);
        }
    }

    public void testGetRealPart() {
        DoubleMatrix1D doubleMatrix1D = this.A.getRealPart();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            DComplexMatrix1DTest.assertEquals((double)this.A.getQuick(i)[0], (double)doubleMatrix1D.getQuick(i), (double)this.TOL);
        }
    }

    public void testGetNonZerosIntArrayListArrayListOfdouble() {
        IntArrayList intArrayList = new IntArrayList();
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        this.A.getNonZeros(intArrayList, arrayList);
        DComplexMatrix1DTest.assertEquals((int)((int)this.A.size()), (int)intArrayList.size());
        DComplexMatrix1DTest.assertEquals((int)((int)this.A.size()), (int)arrayList.size());
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(this.A.getQuick(intArrayList.get(i)), arrayList.get(i), this.TOL);
            DComplexMatrix1DTest.assertTrue((arrayList.get(i)[0] != 0.0 || arrayList.get(i)[1] != 0.0 ? 1 : 0) != 0);
        }
    }

    public void testReshapeIntInt() {
        int n = 10;
        int n2 = 17;
        DComplexMatrix2D dComplexMatrix2D = this.A.reshape(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.assertEquals(this.A.getQuick(n3++), dComplexMatrix2D.getQuick(j, i), this.TOL);
            }
        }
    }

    public void testReshapeIntIntInt() {
        int n = 2;
        int n2 = 5;
        int n3 = 17;
        DComplexMatrix3D dComplexMatrix3D = this.A.reshape(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    this.assertEquals(this.A.getQuick(n4++), dComplexMatrix3D.getQuick(i, k, j), this.TOL);
                }
            }
        }
    }

    public void testSwap() {
        DComplexMatrix1D dComplexMatrix1D = this.A.copy();
        DComplexMatrix1D dComplexMatrix1D2 = this.B.copy();
        this.A.swap(this.B);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(dComplexMatrix1D2.getQuick(i), this.A.getQuick(i), this.TOL);
            this.assertEquals(dComplexMatrix1D.getQuick(i), this.B.getQuick(i), this.TOL);
        }
    }

    public void testToArray() {
        double[] dArray = this.A.toArray();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double[] dArray2 = this.A.getQuick(i);
            DComplexMatrix1DTest.assertEquals((double)dArray2[0], (double)dArray[2 * i], (double)this.TOL);
            DComplexMatrix1DTest.assertEquals((double)dArray2[1], (double)dArray[2 * i + 1], (double)this.TOL);
        }
    }

    public void testToArrayDoubleArray() {
        double[] dArray = new double[2 * (int)this.A.size()];
        this.A.toArray(dArray);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            double[] dArray2 = this.A.getQuick(i);
            DComplexMatrix1DTest.assertEquals((double)dArray2[0], (double)dArray[2 * i], (double)this.TOL);
            DComplexMatrix1DTest.assertEquals((double)dArray2[1], (double)dArray[2 * i + 1], (double)this.TOL);
        }
    }

    public void testViewFlip() {
        DComplexMatrix1D dComplexMatrix1D = this.A.viewFlip();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(this.A.getQuick((int)this.A.size() - 1 - i), dComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewPart() {
        DComplexMatrix1D dComplexMatrix1D = this.A.viewPart((int)this.A.size() / 2, (int)this.A.size() / 3);
        for (int i = 0; i < (int)this.A.size() / 3; ++i) {
            this.assertEquals(this.A.getQuick((int)this.A.size() / 2 + i), dComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewSelectionComplexProcedure() {
        DComplexMatrix1D dComplexMatrix1D = this.A.viewSelection(new DComplexProcedure(){

            public boolean apply(double[] dArray) {
                return dArray[0] < dArray[1];
            }
        });
        int n = 0;
        while ((long)n < dComplexMatrix1D.size()) {
            double[] dArray = dComplexMatrix1D.getQuick(n);
            if (dArray[0] >= dArray[1]) {
                DComplexMatrix1DTest.fail();
            }
            ++n;
        }
    }

    public void testViewSelectionIntArray() {
        int[] nArray = new int[]{(int)this.A.size() / 6, (int)this.A.size() / 5, (int)this.A.size() / 4, (int)this.A.size() / 3, (int)this.A.size() / 2};
        DComplexMatrix1D dComplexMatrix1D = this.A.viewSelection(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            this.assertEquals(this.A.getQuick(nArray[i]), dComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewStrides() {
        int n = 3;
        DComplexMatrix1D dComplexMatrix1D = this.A.viewStrides(n);
        int n2 = 0;
        while ((long)n2 < dComplexMatrix1D.size()) {
            this.assertEquals(this.A.getQuick(n2 * n), dComplexMatrix1D.getQuick(n2), this.TOL);
            ++n2;
        }
    }

    public void testZDotProductComplexMatrix1D() {
        double[] dArray = this.A.zDotProduct(this.B);
        double[] dArray2 = new double[2];
        for (int i = 0; i < (int)this.A.size(); ++i) {
            dArray2 = DComplex.plus(dArray2, DComplex.mult(DComplex.conj(this.B.getQuick(i)), this.A.getQuick(i)));
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    public void testZDotProductComplexMatrix1DIntInt() {
        double[] dArray = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10);
        double[] dArray2 = new double[2];
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            dArray2 = DComplex.plus(dArray2, DComplex.mult(DComplex.conj(this.B.getQuick(i)), this.A.getQuick(i)));
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    public void testZDotProductComplexMatrix1DIntIntIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        this.B.getNonZeros(intArrayList, arrayList);
        double[] dArray = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10, intArrayList);
        double[] dArray2 = new double[2];
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            dArray2 = DComplex.plus(dArray2, DComplex.mult(this.A.getQuick(i), DComplex.conj(this.B.getQuick(i))));
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    public void testZSum() {
        double[] dArray = this.A.zSum();
        double[] dArray2 = new double[2];
        for (int i = 0; i < (int)this.A.size(); ++i) {
            dArray2 = DComplex.plus(dArray2, this.A.getQuick(i));
        }
        this.assertEquals(dArray2, dArray, this.TOL);
    }

    protected void assertEquals(double[] dArray, double[] dArray2, double d) {
        for (int i = 0; i < dArray2.length; ++i) {
            DComplexMatrix1DTest.assertEquals((double)dArray[i], (double)dArray2[i], (double)d);
        }
    }
}

