/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.SparseCCDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SparseRCDoubleMatrix2D;
import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_happly;
import edu.emory.mathcs.csparsej.tdouble.Dcs_ipvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_pvec;
import edu.emory.mathcs.csparsej.tdouble.Dcs_qr;
import edu.emory.mathcs.csparsej.tdouble.Dcs_sqr;
import edu.emory.mathcs.csparsej.tdouble.Dcs_usolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_utsolve;

public class SparseDoubleQRDecomposition {
    private Dcs_common.Dcss S;
    private Dcs_common.Dcsn N;
    private DoubleMatrix2D R;
    private DoubleMatrix2D V;
    private int m;
    private int n;
    private boolean rcMatrix = false;

    public SparseDoubleQRDecomposition(DoubleMatrix2D doubleMatrix2D, int n) {
        Dcs_common.Dcs dcs;
        DoubleProperty.DEFAULT.checkSparse(doubleMatrix2D);
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        this.m = doubleMatrix2D.rows();
        this.n = doubleMatrix2D.columns();
        if (doubleMatrix2D instanceof SparseRCDoubleMatrix2D) {
            this.rcMatrix = true;
            dcs = this.m >= this.n ? ((SparseRCDoubleMatrix2D)doubleMatrix2D).getColumnCompressed().elements() : ((SparseRCDoubleMatrix2D)doubleMatrix2D).getColumnCompressed().getTranspose().elements();
        } else {
            dcs = this.m >= this.n ? (Dcs_common.Dcs)doubleMatrix2D.elements() : ((SparseCCDoubleMatrix2D)doubleMatrix2D).getTranspose().elements();
        }
        this.S = Dcs_sqr.cs_sqr((int)n, (Dcs_common.Dcs)dcs, (boolean)true);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Dcs_qr.cs_qr((Dcs_common.Dcs)dcs, (Dcs_common.Dcss)this.S);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_qr()");
        }
    }

    public DoubleMatrix2D getV() {
        if (this.V == null) {
            this.V = new SparseCCDoubleMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.V = ((SparseCCDoubleMatrix2D)this.V).getRowCompressed();
            }
        }
        return this.V.copy();
    }

    public double[] getBeta() {
        if (this.N.B == null) {
            return null;
        }
        double[] dArray = new double[this.N.B.length];
        System.arraycopy(this.N.B, 0, dArray, 0, this.N.B.length);
        return dArray;
    }

    public DoubleMatrix2D getR() {
        if (this.R == null) {
            this.R = new SparseCCDoubleMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCDoubleMatrix2D)this.R).getRowCompressed();
            }
        }
        return this.R.copy();
    }

    public Dcs_common.Dcss getSymbolicAnalysis() {
        Dcs_common.Dcss dcss = new Dcs_common.Dcss();
        dcss.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        dcss.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        dcss.lnz = this.S.lnz;
        dcss.m2 = this.S.m2;
        dcss.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        dcss.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        dcss.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        dcss.unz = this.S.unz;
        return dcss;
    }

    public boolean hasFullRank() {
        if (this.R == null) {
            this.R = new SparseCCDoubleMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.R = ((SparseCCDoubleMatrix2D)this.R).getRowCompressed();
            }
        }
        int n = Math.min(this.m, this.n);
        for (int i = 0; i < n; ++i) {
            if (this.R.getQuick(i, i) != 0.0) continue;
            return false;
        }
        return true;
    }

    public void solve(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() != (long)Math.max(this.m, this.n)) {
            throw new IllegalArgumentException("The size b must be equal to max(A.rows(), A.columns()).");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        double[] dArray = doubleMatrix1D.isView() ? (double[])doubleMatrix1D.copy().elements() : (double[])doubleMatrix1D.elements();
        if (this.m >= this.n) {
            double[] dArray2 = new double[this.S != null ? this.S.m2 : 1];
            Dcs_ipvec.cs_ipvec((int[])this.S.pinv, (double[])dArray, (double[])dArray2, (int)this.m);
            for (int i = 0; i < this.n; ++i) {
                Dcs_happly.cs_happly((Dcs_common.Dcs)this.N.L, (int)i, (double)this.N.B[i], (double[])dArray2);
            }
            Dcs_usolve.cs_usolve((Dcs_common.Dcs)this.N.U, (double[])dArray2);
            Dcs_ipvec.cs_ipvec((int[])this.S.q, (double[])dArray2, (double[])dArray, (int)this.n);
        } else {
            double[] dArray3 = new double[this.S != null ? this.S.m2 : 1];
            Dcs_pvec.cs_pvec((int[])this.S.q, (double[])dArray, (double[])dArray3, (int)this.m);
            Dcs_utsolve.cs_utsolve((Dcs_common.Dcs)this.N.U, (double[])dArray3);
            for (int i = this.m - 1; i >= 0; --i) {
                Dcs_happly.cs_happly((Dcs_common.Dcs)this.N.L, (int)i, (double)this.N.B[i], (double[])dArray3);
            }
            Dcs_pvec.cs_pvec((int[])this.S.pinv, (double[])dArray3, (double[])dArray, (int)this.n);
        }
    }
}

