/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.PersistentObject;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;

public class FComplexFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FComplexFactory2D dense = new FComplexFactory2D();
    public static final FComplexFactory2D sparse = new FComplexFactory2D();

    protected FComplexFactory2D() {
    }

    public FComplexMatrix2D appendColumns(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2) {
        if (fComplexMatrix2D2.rows() > fComplexMatrix2D.rows()) {
            fComplexMatrix2D2 = fComplexMatrix2D2.viewPart(0, 0, fComplexMatrix2D.rows(), fComplexMatrix2D2.columns());
        } else if (fComplexMatrix2D2.rows() < fComplexMatrix2D.rows()) {
            fComplexMatrix2D = fComplexMatrix2D.viewPart(0, 0, fComplexMatrix2D2.rows(), fComplexMatrix2D.columns());
        }
        int n = fComplexMatrix2D.columns();
        int n2 = fComplexMatrix2D2.columns();
        int n3 = fComplexMatrix2D.rows();
        FComplexMatrix2D fComplexMatrix2D3 = this.make(n3, n + n2);
        fComplexMatrix2D3.viewPart(0, 0, n3, n).assign(fComplexMatrix2D);
        fComplexMatrix2D3.viewPart(0, n, n3, n2).assign(fComplexMatrix2D2);
        return fComplexMatrix2D3;
    }

    public FComplexMatrix2D appendColumn(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D.size() > (long)fComplexMatrix2D.rows()) {
            fComplexMatrix1D = fComplexMatrix1D.viewPart(0, fComplexMatrix2D.rows());
        } else if (fComplexMatrix1D.size() < (long)fComplexMatrix2D.rows()) {
            fComplexMatrix2D = fComplexMatrix2D.viewPart(0, 0, (int)fComplexMatrix1D.size(), fComplexMatrix2D.columns());
        }
        int n = fComplexMatrix2D.columns();
        int n2 = 1;
        int n3 = fComplexMatrix2D.rows();
        FComplexMatrix2D fComplexMatrix2D2 = this.make(n3, n + n2);
        fComplexMatrix2D2.viewPart(0, 0, n3, n).assign(fComplexMatrix2D);
        fComplexMatrix2D2.viewColumn(n).assign(fComplexMatrix1D);
        return fComplexMatrix2D2;
    }

    public FComplexMatrix2D appendRows(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2) {
        if (fComplexMatrix2D2.columns() > fComplexMatrix2D.columns()) {
            fComplexMatrix2D2 = fComplexMatrix2D2.viewPart(0, 0, fComplexMatrix2D2.rows(), fComplexMatrix2D.columns());
        } else if (fComplexMatrix2D2.columns() < fComplexMatrix2D.columns()) {
            fComplexMatrix2D = fComplexMatrix2D.viewPart(0, 0, fComplexMatrix2D.rows(), fComplexMatrix2D2.columns());
        }
        int n = fComplexMatrix2D.rows();
        int n2 = fComplexMatrix2D2.rows();
        int n3 = fComplexMatrix2D.columns();
        FComplexMatrix2D fComplexMatrix2D3 = this.make(n + n2, n3);
        fComplexMatrix2D3.viewPart(0, 0, n, n3).assign(fComplexMatrix2D);
        fComplexMatrix2D3.viewPart(n, 0, n2, n3).assign(fComplexMatrix2D2);
        return fComplexMatrix2D3;
    }

    public FComplexMatrix2D appendRow(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D.size() > (long)fComplexMatrix2D.columns()) {
            fComplexMatrix1D = fComplexMatrix1D.viewPart(0, fComplexMatrix2D.columns());
        } else if (fComplexMatrix1D.size() < (long)fComplexMatrix2D.columns()) {
            fComplexMatrix2D = fComplexMatrix2D.viewPart(0, 0, fComplexMatrix2D.rows(), (int)fComplexMatrix1D.size());
        }
        int n = fComplexMatrix2D.rows();
        int n2 = 1;
        int n3 = fComplexMatrix2D.columns();
        FComplexMatrix2D fComplexMatrix2D2 = this.make(n + n2, n3);
        fComplexMatrix2D2.viewPart(0, 0, n, n3).assign(fComplexMatrix2D);
        fComplexMatrix2D2.viewRow(n).assign(fComplexMatrix1D);
        return fComplexMatrix2D2;
    }

    protected static void checkRectangularShape(float[][] fArray) {
        int n = -1;
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            if (n == -1) {
                n = fArray[i].length;
            }
            if (fArray[i].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(FComplexMatrix2D[][] fComplexMatrix2DArray) {
        int n = -1;
        for (int i = 0; i < fComplexMatrix2DArray.length; ++i) {
            if (fComplexMatrix2DArray[i] == null) continue;
            if (n == -1) {
                n = fComplexMatrix2DArray[i].length;
            }
            if (fComplexMatrix2DArray[i].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public FComplexMatrix2D compose(FComplexMatrix2D[][] fComplexMatrix2DArray) {
        int n;
        int n2;
        int n3;
        FComplexFactory2D.checkRectangularShape(fComplexMatrix2DArray);
        int n4 = fComplexMatrix2DArray.length;
        int n5 = 0;
        if (fComplexMatrix2DArray.length > 0) {
            n5 = fComplexMatrix2DArray[0].length;
        }
        FComplexMatrix2D fComplexMatrix2D = this.make(0, 0);
        if (n4 == 0 || n5 == 0) {
            return fComplexMatrix2D;
        }
        int[] nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            n3 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                FComplexMatrix2D fComplexMatrix2D2 = fComplexMatrix2DArray[n2][i];
                if (fComplexMatrix2D2 == null) continue;
                int n6 = fComplexMatrix2D2.columns();
                if (n3 > 0 && n6 > 0 && n6 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n6);
            }
            nArray[i] = n3;
        }
        int[] nArray2 = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = 0;
            for (int i = 0; i < n5; ++i) {
                FComplexMatrix2D fComplexMatrix2D3 = fComplexMatrix2DArray[n3][i];
                if (fComplexMatrix2D3 == null) continue;
                n = fComplexMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        for (int i = 0; i < n5; ++i) {
            n2 += nArray[i];
        }
        FComplexMatrix2D fComplexMatrix2D4 = this.make(n3, n2);
        int n7 = 0;
        for (n = 0; n < n4; ++n) {
            int n8 = 0;
            for (int i = 0; i < n5; ++i) {
                FComplexMatrix2D fComplexMatrix2D5 = fComplexMatrix2DArray[n][i];
                if (fComplexMatrix2D5 != null) {
                    fComplexMatrix2D4.viewPart(n7, n8, fComplexMatrix2D5.rows(), fComplexMatrix2D5.columns()).assign(fComplexMatrix2D5);
                }
                n8 += nArray[i];
            }
            n7 += nArray2[n];
        }
        return fComplexMatrix2D4;
    }

    public FComplexMatrix2D composeDiagonal(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2) {
        int n = fComplexMatrix2D.rows();
        int n2 = fComplexMatrix2D.columns();
        int n3 = fComplexMatrix2D2.rows();
        int n4 = fComplexMatrix2D2.columns();
        FComplexMatrix2D fComplexMatrix2D3 = this.make(n + n3, n2 + n4);
        fComplexMatrix2D3.viewPart(0, 0, n, n2).assign(fComplexMatrix2D);
        fComplexMatrix2D3.viewPart(n, n2, n3, n4).assign(fComplexMatrix2D2);
        return fComplexMatrix2D3;
    }

    public FComplexMatrix2D composeDiagonal(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2, FComplexMatrix2D fComplexMatrix2D3) {
        FComplexMatrix2D fComplexMatrix2D4 = this.make(fComplexMatrix2D.rows() + fComplexMatrix2D2.rows() + fComplexMatrix2D3.rows(), fComplexMatrix2D.columns() + fComplexMatrix2D2.columns() + fComplexMatrix2D3.columns());
        fComplexMatrix2D4.viewPart(0, 0, fComplexMatrix2D.rows(), fComplexMatrix2D.columns()).assign(fComplexMatrix2D);
        fComplexMatrix2D4.viewPart(fComplexMatrix2D.rows(), fComplexMatrix2D.columns(), fComplexMatrix2D2.rows(), fComplexMatrix2D2.columns()).assign(fComplexMatrix2D2);
        fComplexMatrix2D4.viewPart(fComplexMatrix2D.rows() + fComplexMatrix2D2.rows(), fComplexMatrix2D.columns() + fComplexMatrix2D2.columns(), fComplexMatrix2D3.rows(), fComplexMatrix2D3.columns()).assign(fComplexMatrix2D3);
        return fComplexMatrix2D4;
    }

    public FComplexMatrix2D composeBidiagonal(FComplexMatrix2D fComplexMatrix2D, FComplexMatrix2D fComplexMatrix2D2) {
        int n = fComplexMatrix2D.rows();
        int n2 = fComplexMatrix2D.columns();
        int n3 = fComplexMatrix2D2.rows();
        int n4 = fComplexMatrix2D2.columns();
        FComplexMatrix2D fComplexMatrix2D3 = this.make(n + n3 - 1, n2 + n4);
        fComplexMatrix2D3.viewPart(0, 0, n, n2).assign(fComplexMatrix2D);
        fComplexMatrix2D3.viewPart(n - 1, n2, n3, n4).assign(fComplexMatrix2D2);
        return fComplexMatrix2D3;
    }

    public void decompose(FComplexMatrix2D[][] fComplexMatrix2DArray, FComplexMatrix2D fComplexMatrix2D) {
        int n;
        int n2;
        int n3;
        int n4;
        FComplexFactory2D.checkRectangularShape(fComplexMatrix2DArray);
        int n5 = fComplexMatrix2DArray.length;
        int n6 = 0;
        if (fComplexMatrix2DArray.length > 0) {
            n6 = fComplexMatrix2DArray[0].length;
        }
        if (n5 == 0 || n6 == 0) {
            return;
        }
        int[] nArray = new int[n6];
        for (int i = 0; i < n6; ++i) {
            n4 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                FComplexMatrix2D fComplexMatrix2D2 = fComplexMatrix2DArray[n3][i];
                if (fComplexMatrix2D2 == null) continue;
                int n7 = fComplexMatrix2D2.columns();
                if (n4 > 0 && n7 > 0 && n7 != n4) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n4 = Math.max(n4, n7);
            }
            nArray[i] = n4;
        }
        int[] nArray2 = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 0;
            for (int i = 0; i < n6; ++i) {
                FComplexMatrix2D fComplexMatrix2D3 = fComplexMatrix2DArray[n4][i];
                if (fComplexMatrix2D3 == null) continue;
                n2 = fComplexMatrix2D3.rows();
                if (n3 > 0 && n2 > 0 && n2 != n3) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n3 = Math.max(n3, n2);
            }
            nArray2[n4] = n3;
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n4 += nArray2[n3];
        }
        n3 = 0;
        for (n = 0; n < n6; ++n) {
            n3 += nArray[n];
        }
        if (fComplexMatrix2D.rows() < n4 || fComplexMatrix2D.columns() < n3) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        n = 0;
        for (int i = 0; i < n5; ++i) {
            n2 = 0;
            for (int j = 0; j < n6; ++j) {
                FComplexMatrix2D fComplexMatrix2D4 = fComplexMatrix2DArray[i][j];
                if (fComplexMatrix2D4 != null) {
                    fComplexMatrix2D4.assign(fComplexMatrix2D.viewPart(n, n2, fComplexMatrix2D4.rows(), fComplexMatrix2D4.columns()));
                }
                n2 += nArray[j];
            }
            n += nArray2[i];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        FComplexMatrix2D[][] fComplexMatrix2DArray = new FComplexMatrix2D[][]{{null, this.make(2, 2, new float[]{1.0f, 2.0f}), null}, {this.make(4, 4, new float[]{3.0f, 4.0f}), null, this.make(4, 3, new float[]{5.0f, 6.0f})}, {null, this.make(2, 2, new float[]{7.0f, 8.0f}), null}};
        System.out.println("\n" + this.compose(fComplexMatrix2DArray));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object var6_1 = null;
        FComplexMatrix2D fComplexMatrix2D = this.make(2, 2, new float[]{1.0f, 2.0f});
        FComplexMatrix2D fComplexMatrix2D2 = this.make(4, 4, new float[]{3.0f, 4.0f});
        FComplexMatrix2D fComplexMatrix2D3 = this.make(4, 3, new float[]{5.0f, 6.0f});
        FComplexMatrix2D fComplexMatrix2D4 = this.make(2, 2, new float[]{7.0f, 8.0f});
        FComplexMatrix2D[][] fComplexMatrix2DArray = new FComplexMatrix2D[][]{{var6_1, fComplexMatrix2D, var6_1}, {fComplexMatrix2D2, var6_1, fComplexMatrix2D3}, {var6_1, fComplexMatrix2D4, var6_1}};
        FComplexMatrix2D fComplexMatrix2D5 = this.compose(fComplexMatrix2DArray);
        System.out.println("\n" + fComplexMatrix2D5);
        fComplexMatrix2D.assign(9.0f, 9.0f);
        fComplexMatrix2D2.assign(9.0f, 9.0f);
        fComplexMatrix2D3.assign(9.0f, 9.0f);
        fComplexMatrix2D4.assign(9.0f, 9.0f);
        this.decompose(fComplexMatrix2DArray, fComplexMatrix2D5);
        System.out.println(fComplexMatrix2D);
        System.out.println(fComplexMatrix2D2);
        System.out.println(fComplexMatrix2D3);
        System.out.println(fComplexMatrix2D4);
    }

    public FComplexMatrix2D diagonal(FComplexMatrix1D fComplexMatrix1D) {
        int n = (int)fComplexMatrix1D.size();
        FComplexMatrix2D fComplexMatrix2D = this.make(n, n);
        for (int i = 0; i < n; ++i) {
            fComplexMatrix2D.setQuick(i, i, fComplexMatrix1D.getQuick(i));
        }
        return fComplexMatrix2D;
    }

    public FComplexMatrix1D diagonal(FComplexMatrix2D fComplexMatrix2D) {
        int n = Math.min(fComplexMatrix2D.rows(), fComplexMatrix2D.columns());
        FComplexMatrix1D fComplexMatrix1D = this.make1D(n);
        for (int i = 0; i < n; ++i) {
            fComplexMatrix1D.setQuick(i, fComplexMatrix2D.getQuick(i, i));
        }
        return fComplexMatrix1D;
    }

    public FComplexMatrix2D identity(int n) {
        FComplexMatrix2D fComplexMatrix2D = this.make(n, n);
        float[] fArray = new float[]{1.0f, 0.0f};
        int n2 = n;
        while (--n2 >= 0) {
            fComplexMatrix2D.setQuick(n2, n2, fArray);
        }
        return fComplexMatrix2D;
    }

    public FComplexMatrix2D make(float[][] fArray) {
        if (this == sparse) {
            return new SparseFComplexMatrix2D(fArray);
        }
        return new DenseFComplexMatrix2D(fArray);
    }

    public FComplexMatrix2D make(int n, int n2) {
        if (this == sparse) {
            return new SparseFComplexMatrix2D(n, n2);
        }
        return new DenseFComplexMatrix2D(n, n2);
    }

    public FComplexMatrix2D make(int n, int n2, float[] fArray) {
        if (fArray[0] == 0.0f && fArray[1] == 0.0f) {
            return this.make(n, n2);
        }
        return this.make(n, n2).assign(fArray);
    }

    protected FComplexMatrix1D make1D(int n) {
        return this.make(0, 0).like1D(n);
    }

    public FComplexMatrix2D random(int n, int n2) {
        return this.make(n, n2).assign(FComplexFunctions.random());
    }

    public FComplexMatrix2D repeat(FComplexMatrix2D fComplexMatrix2D, int n, int n2) {
        int n3 = fComplexMatrix2D.rows();
        int n4 = fComplexMatrix2D.columns();
        FComplexMatrix2D fComplexMatrix2D2 = this.make(n3 * n, n4 * n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fComplexMatrix2D2.viewPart(n3 * i, n4 * j, n3, n4).assign(fComplexMatrix2D);
            }
        }
        return fComplexMatrix2D2;
    }

    public FComplexMatrix2D sample(int n, int n2, float[] fArray, float f) {
        FComplexMatrix2D fComplexMatrix2D = this.make(n, n2);
        this.sample(fComplexMatrix2D, fArray, f);
        return fComplexMatrix2D;
    }

    public FComplexMatrix2D sample(FComplexMatrix2D fComplexMatrix2D, float[] fArray, float f) {
        int n = fComplexMatrix2D.rows();
        int n2 = fComplexMatrix2D.columns();
        float f2 = 1.0E-5f;
        if (f < 0.0f - f2 || f > 1.0f + f2) {
            throw new IllegalArgumentException();
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        fComplexMatrix2D.assign(0.0f, 0.0f);
        int n3 = n * n2;
        int n4 = Math.round((float)n3 * f);
        if (n4 == 0) {
            return fComplexMatrix2D;
        }
        FloatRandomSamplingAssistant floatRandomSamplingAssistant = new FloatRandomSamplingAssistant(n4, n3, new FloatMersenneTwister());
        for (int i = 0; i < n3; ++i) {
            if (!floatRandomSamplingAssistant.sampleNextElement()) continue;
            int n5 = i / n2;
            int n6 = i % n2;
            fComplexMatrix2D.set(n5, n6, fArray);
        }
        return fComplexMatrix2D;
    }
}

