/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.Timer;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class BenchmarkSparseCCFloatMatrix2D {
    private static final Timer t = new Timer();
    private static int niters = 200;
    private static int[] nthreads;

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java cern.colt.matrix.tfloat.impl.BenchmarkSparseCCFloatMatrix2D fileName nthreads1 [nthreads2 ... nthreadsn]");
            System.exit(-1);
        }
        nthreads = new int[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            BenchmarkSparseCCFloatMatrix2D.nthreads[i - 1] = Integer.parseInt(stringArray[i]);
        }
        BenchmarkSparseCCFloatMatrix2D.benchmarkZMult(stringArray[0]);
    }

    public static void benchmarkZMult(String string) {
        SparseCCFloatMatrix2D sparseCCFloatMatrix2D = null;
        File file = new File(string);
        try {
            sparseCCFloatMatrix2D = new SparseFloatMatrix2D(new MatrixVectorReader(new FileReader(file))).getColumnCompressed(false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Benchmark of SparseCCFloatMatrix2D (" + file.getName() + ")");
        int n = sparseCCFloatMatrix2D.rows();
        int n2 = sparseCCFloatMatrix2D.cardinality();
        FloatMatrix1D floatMatrix1D = FloatFactory1D.dense.make(n, 1.0f);
        for (int i = 0; i < nthreads.length; ++i) {
            ConcurrencyUtils.setNumberOfThreads(nthreads[i]);
            System.out.println("\tNumber of threads = " + nthreads[i]);
            FloatMatrix1D floatMatrix1D2 = sparseCCFloatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, false);
            floatMatrix1D2 = sparseCCFloatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, false);
            t.reset().start();
            for (int j = 0; j < niters; ++j) {
                floatMatrix1D2 = sparseCCFloatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, false);
            }
            t.stop();
            double d = (double)t.nanos() / 1000.0 / (double)niters;
            System.out.println("\t\tAverage execution time of mat-vec-mult = " + t.millis() / (double)niters + " milliseconds");
            System.out.println("\t\tPerformance of mat-vec-mult = " + (double)(2 * n2) / d + " megaFLOPS");
            floatMatrix1D2 = sparseCCFloatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, true);
            floatMatrix1D2 = sparseCCFloatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, true);
            t.reset().start();
            for (int j = 0; j < niters; ++j) {
                floatMatrix1D2 = sparseCCFloatMatrix2D.zMult(floatMatrix1D, null, 1.0f, 0.0f, true);
            }
            t.stop();
            d = (double)t.nanos() / 1000.0 / (double)niters;
            System.out.println("\t\tAverage execution time of mat-trans-vec-mult = " + t.millis() / (double)niters + " milliseconds");
            System.out.println("\t\tPerformance of mat-trans-vec-mult = " + (double)(2 * n2) / d + " megaFLOPS");
        }
    }
}

