/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.DelegateFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DiagonalFloatMatrix2D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperFloatMatrix2D
extends FloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected FloatMatrix2D content;

    public FloatMatrix2D assign(final float[] fArray) {
        if (this.content instanceof DiagonalFloatMatrix2D) {
            int n = ((DiagonalFloatMatrix2D)this.content).dlength;
            final float[] fArray2 = ((DiagonalFloatMatrix2D)this.content).elements;
            if (fArray.length != n) {
                throw new IllegalArgumentException("Must have same length: length=" + fArray.length + " dlength=" + n);
            }
            int n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n2 = Math.min(n2, n);
                Future[] futureArray = new Future[n2];
                int n3 = n / n2;
                for (int i = 0; i < n2; ++i) {
                    final int n4 = i * n3;
                    final int n5 = i == n2 - 1 ? n : n4 + n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            for (int i = n4; i < n5; ++i) {
                                fArray2[i] = fArray[i];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                for (int i = 0; i < n; ++i) {
                    fArray2[i] = fArray[i];
                }
            }
            return this;
        }
        return super.assign(fArray);
    }

    public FloatMatrix2D assign(FloatMatrix2D floatMatrix2D, FloatFloatFunction floatFloatFunction) {
        this.checkShape(floatMatrix2D);
        if (floatMatrix2D instanceof WrapperFloatMatrix2D) {
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            FloatArrayList floatArrayList = new FloatArrayList();
            floatMatrix2D.getNonZeros(intArrayList, intArrayList2, floatArrayList);
            this.assign(floatMatrix2D, floatFloatFunction, intArrayList, intArrayList2);
        } else {
            super.assign(floatMatrix2D, floatFloatFunction);
        }
        return this;
    }

    public WrapperFloatMatrix2D(FloatMatrix2D floatMatrix2D) {
        block3: {
            if (floatMatrix2D != null) {
                try {
                    this.setUp(floatMatrix2D.rows(), floatMatrix2D.columns());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                    throw illegalArgumentException;
                }
            }
        }
        this.content = floatMatrix2D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized float getQuick(int n, int n2) {
        return this.content.getQuick(n, n2);
    }

    public boolean equals(float f) {
        if (this.content instanceof DiagonalFloatMatrix2D) {
            float f2 = FloatProperty.DEFAULT.tolerance();
            float[] fArray = (float[])this.content.elements();
            for (int i = 0; i < fArray.length; ++i) {
                float f3 = fArray[i];
                float f4 = Math.abs(f - f3);
                if (f4 != f4 && (f != f && f3 != f3 || f == f3)) {
                    f4 = 0.0f;
                }
                if (f4 <= f2) continue;
                return false;
            }
            return true;
        }
        return super.equals(f);
    }

    public boolean equals(Object object) {
        if (this.content instanceof DiagonalFloatMatrix2D && object instanceof DiagonalFloatMatrix2D) {
            float f = FloatProperty.DEFAULT.tolerance();
            if (this == object) {
                return true;
            }
            if (this == null || object == null) {
                return false;
            }
            DiagonalFloatMatrix2D diagonalFloatMatrix2D = (DiagonalFloatMatrix2D)this.content;
            DiagonalFloatMatrix2D diagonalFloatMatrix2D2 = (DiagonalFloatMatrix2D)object;
            if (diagonalFloatMatrix2D.columns() != diagonalFloatMatrix2D2.columns() || diagonalFloatMatrix2D.rows() != diagonalFloatMatrix2D2.rows() || diagonalFloatMatrix2D.diagonalIndex() != diagonalFloatMatrix2D2.diagonalIndex() || diagonalFloatMatrix2D.diagonalLength() != diagonalFloatMatrix2D2.diagonalLength()) {
                return false;
            }
            float[] fArray = diagonalFloatMatrix2D.elements();
            float[] fArray2 = diagonalFloatMatrix2D2.elements();
            for (int i = 0; i < fArray.length; ++i) {
                float f2 = fArray2[i];
                float f3 = fArray[i];
                float f4 = Math.abs(f2 - f3);
                if (f4 != f4 && (f2 != f2 && f3 != f3 || f2 == f3)) {
                    f4 = 0.0f;
                }
                if (f4 <= f) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    public FloatMatrix2D like(int n, int n2) {
        return this.content.like(n, n2);
    }

    public FloatMatrix1D like1D(int n) {
        return this.content.like1D(n);
    }

    public void dct2(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dct2(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dct2(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dctColumns(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dctColumns(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dctColumns(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dctRows(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dctRows(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dctRows(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst2(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dst2(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dst2(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dstColumns(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dstColumns(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dstColumns(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dstRows(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dstRows(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dstRows(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht2() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dht2();
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dht2();
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dhtColumns() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dhtColumns();
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dhtColumns();
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dhtRows() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dhtRows();
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.dhtRows();
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft2() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).fft2();
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.fft2();
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public DenseLargeFComplexMatrix2D getFft2() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getFft2();
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getFft2();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getIfft2(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getIfft2(bl);
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getIfft2(bl);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getFftColumns() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getFftColumns();
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getFftColumns();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getFftRows() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getFftRows();
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getFftRows();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getIfftColumns(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getIfftColumns(bl);
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getIfftColumns(bl);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getIfftRows(boolean bl) {
        if (this.isNoView) {
            return ((DenseLargeFloatMatrix2D)this.content).getIfftRows(bl);
        }
        return ((DenseLargeFloatMatrix2D)this.copy()).getIfftRows(bl);
    }

    public void idct2(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idct2(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idct2(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idctColumns(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idctColumns(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idctColumns(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idctRows(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idctRows(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idctRows(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst2(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idst2(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idst2(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idstColumns(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idstColumns(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idstColumns(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idstRows(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idstRows(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idstRows(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht2(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idht2(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idht2(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idhtColumns(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idhtColumns(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idhtColumns(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idhtRows(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idhtRows(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.idhtRows(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2(boolean bl) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).ifft2(bl);
            } else {
                DenseLargeFloatMatrix2D denseLargeFloatMatrix2D = (DenseLargeFloatMatrix2D)this.copy();
                denseLargeFloatMatrix2D.ifft2(bl);
                this.assign(denseLargeFloatMatrix2D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized void setQuick(int n, int n2, float f) {
        this.content.setQuick(n, n2, f);
    }

    public FloatMatrix1D vectorize() {
        final DenseFloatMatrix1D denseFloatMatrix1D = new DenseFloatMatrix1D((int)this.size());
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n2 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.columns : n3 + n2;
                final int n5 = i * n2 * this.rows;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n5;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperFloatMatrix2D.this.rows; ++j) {
                                denseFloatMatrix1D.setQuick(n++, WrapperFloatMatrix2D.this.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = 0;
            for (int i = 0; i < this.columns; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    denseFloatMatrix1D.setQuick(n6++, this.getQuick(j, i));
                }
            }
        }
        return denseFloatMatrix1D;
    }

    public FloatMatrix1D viewColumn(int n) {
        return this.viewDice().viewRow(n);
    }

    public FloatMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n, int n2) {
                return this.content.getQuick(n, this.columns - 1 - n2);
            }

            public synchronized void setQuick(int n, int n2, float f) {
                this.content.setQuick(n, this.columns - 1 - n2, f);
            }

            public synchronized float get(int n, int n2) {
                return this.content.get(n, this.columns - 1 - n2);
            }

            public synchronized void set(int n, int n2, float f) {
                this.content.set(n, this.columns - 1 - n2, f);
            }
        };
        wrapperFloatMatrix2D.isNoView = false;
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix2D viewDice() {
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n, int n2) {
                return this.content.getQuick(n2, n);
            }

            public synchronized void setQuick(int n, int n2, float f) {
                this.content.setQuick(n2, n, f);
            }

            public synchronized float get(int n, int n2) {
                return this.content.get(n2, n);
            }

            public synchronized void set(int n, int n2, float f) {
                this.content.set(n2, n, f);
            }
        };
        wrapperFloatMatrix2D.rows = this.columns;
        wrapperFloatMatrix2D.columns = this.rows;
        wrapperFloatMatrix2D.isNoView = false;
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix2D viewPart(final int n, final int n2, int n3, int n4) {
        this.checkBox(n, n2, n3, n4);
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n3, int n22) {
                return this.content.getQuick(n + n3, n2 + n22);
            }

            public synchronized void setQuick(int n3, int n22, float f) {
                this.content.setQuick(n + n3, n2 + n22, f);
            }

            public synchronized float get(int n3, int n22) {
                return this.content.get(n + n3, n2 + n22);
            }

            public synchronized void set(int n3, int n22, float f) {
                this.content.set(n + n3, n2 + n22, f);
            }
        };
        wrapperFloatMatrix2D.rows = n3;
        wrapperFloatMatrix2D.columns = n4;
        wrapperFloatMatrix2D.isNoView = false;
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix1D viewRow(int n) {
        this.checkRow(n);
        return new DelegateFloatMatrix1D(this, n);
    }

    public FloatMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n, int n2) {
                return this.content.getQuick(this.rows - 1 - n, n2);
            }

            public synchronized void setQuick(int n, int n2, float f) {
                this.content.setQuick(this.rows - 1 - n, n2, f);
            }

            public synchronized float get(int n, int n2) {
                return this.content.get(this.rows - 1 - n, n2);
            }

            public synchronized void set(int n, int n2, float f) {
                this.content.set(this.rows - 1 - n, n2, f);
            }
        };
        wrapperFloatMatrix2D.isNoView = false;
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        final int[] nArray3 = nArray;
        final int[] nArray4 = nArray2;
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n, int n2) {
                return this.content.getQuick(nArray3[n], nArray4[n2]);
            }

            public synchronized void setQuick(int n, int n2, float f) {
                this.content.setQuick(nArray3[n], nArray4[n2], f);
            }

            public synchronized float get(int n, int n2) {
                return this.content.get(nArray3[n], nArray4[n2]);
            }

            public synchronized void set(int n, int n2, float f) {
                this.content.set(nArray3[n], nArray4[n2], f);
            }
        };
        wrapperFloatMatrix2D.rows = nArray.length;
        wrapperFloatMatrix2D.columns = nArray2.length;
        wrapperFloatMatrix2D.isNoView = false;
        return wrapperFloatMatrix2D;
    }

    public FloatMatrix2D viewStrides(final int n, final int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperFloatMatrix2D wrapperFloatMatrix2D = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float getQuick(int n3, int n22) {
                return this.content.getQuick(n * n3, n2 * n22);
            }

            public synchronized void setQuick(int n3, int n22, float f) {
                this.content.setQuick(n * n3, n2 * n22, f);
            }

            public synchronized float get(int n3, int n22) {
                return this.content.get(n * n3, n2 * n22);
            }

            public synchronized void set(int n3, int n22, float f) {
                this.content.set(n * n3, n2 * n22, f);
            }
        };
        if (this.rows != 0) {
            wrapperFloatMatrix2D.rows = (this.rows - 1) / n + 1;
        }
        if (this.columns != 0) {
            wrapperFloatMatrix2D.columns = (this.columns - 1) / n2 + 1;
        }
        wrapperFloatMatrix2D.isNoView = false;
        return wrapperFloatMatrix2D;
    }

    protected FloatMatrix2D getContent() {
        return this.content;
    }

    protected FloatMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected FloatMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        throw new InternalError();
    }
}

