/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.PersistentObject;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.sampling.DoubleRandomSamplingAssistant;

public class LongFactory2D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongFactory2D dense = new LongFactory2D();
    public static final LongFactory2D sparse = new LongFactory2D();
    public static final LongFactory2D rowCompressed = new LongFactory2D();

    protected LongFactory2D() {
    }

    public LongMatrix2D appendColumns(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2) {
        if (longMatrix2D2.rows() > longMatrix2D.rows()) {
            longMatrix2D2 = longMatrix2D2.viewPart(0, 0, longMatrix2D.rows(), longMatrix2D2.columns());
        } else if (longMatrix2D2.rows() < longMatrix2D.rows()) {
            longMatrix2D = longMatrix2D.viewPart(0, 0, longMatrix2D2.rows(), longMatrix2D.columns());
        }
        int n = longMatrix2D.columns();
        int n2 = longMatrix2D2.columns();
        int n3 = longMatrix2D.rows();
        LongMatrix2D longMatrix2D3 = this.make(n3, n + n2);
        longMatrix2D3.viewPart(0, 0, n3, n).assign(longMatrix2D);
        longMatrix2D3.viewPart(0, n, n3, n2).assign(longMatrix2D2);
        return longMatrix2D3;
    }

    public LongMatrix2D appendColumn(LongMatrix2D longMatrix2D, LongMatrix1D longMatrix1D) {
        if (longMatrix1D.size() > (long)longMatrix2D.rows()) {
            longMatrix1D = longMatrix1D.viewPart(0, longMatrix2D.rows());
        } else if (longMatrix1D.size() < (long)longMatrix2D.rows()) {
            longMatrix2D = longMatrix2D.viewPart(0, 0, (int)longMatrix1D.size(), longMatrix2D.columns());
        }
        int n = longMatrix2D.columns();
        int n2 = 1;
        int n3 = longMatrix2D.rows();
        LongMatrix2D longMatrix2D2 = this.make(n3, n + n2);
        longMatrix2D2.viewPart(0, 0, n3, n).assign(longMatrix2D);
        longMatrix2D2.viewColumn(n).assign(longMatrix1D);
        return longMatrix2D2;
    }

    public LongMatrix2D appendRows(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2) {
        if (longMatrix2D2.columns() > longMatrix2D.columns()) {
            longMatrix2D2 = longMatrix2D2.viewPart(0, 0, longMatrix2D2.rows(), longMatrix2D.columns());
        } else if (longMatrix2D2.columns() < longMatrix2D.columns()) {
            longMatrix2D = longMatrix2D.viewPart(0, 0, longMatrix2D.rows(), longMatrix2D2.columns());
        }
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D2.rows();
        int n3 = longMatrix2D.columns();
        LongMatrix2D longMatrix2D3 = this.make(n + n2, n3);
        longMatrix2D3.viewPart(0, 0, n, n3).assign(longMatrix2D);
        longMatrix2D3.viewPart(n, 0, n2, n3).assign(longMatrix2D2);
        return longMatrix2D3;
    }

    public LongMatrix2D appendRow(LongMatrix2D longMatrix2D, LongMatrix1D longMatrix1D) {
        if (longMatrix1D.size() > (long)longMatrix2D.columns()) {
            longMatrix1D = longMatrix1D.viewPart(0, longMatrix2D.columns());
        } else if (longMatrix1D.size() < (long)longMatrix2D.columns()) {
            longMatrix2D = longMatrix2D.viewPart(0, 0, longMatrix2D.rows(), (int)longMatrix1D.size());
        }
        int n = longMatrix2D.rows();
        int n2 = 1;
        int n3 = longMatrix2D.columns();
        LongMatrix2D longMatrix2D2 = this.make(n + n2, n3);
        longMatrix2D2.viewPart(0, 0, n, n3).assign(longMatrix2D);
        longMatrix2D2.viewRow(n).assign(longMatrix1D);
        return longMatrix2D2;
    }

    public LongMatrix2D ascending(int n, int n2) {
        LongFunctions longFunctions = LongFunctions.longFunctions;
        return this.descending(n, n2).assign(LongFunctions.chain(LongFunctions.neg, LongFunctions.minus(n2 * n)));
    }

    protected static void checkRectangularShape(int[][] nArray) {
        int n = -1;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] == null) continue;
            if (n == -1) {
                n = nArray[n2].length;
            }
            if (nArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    protected static void checkRectangularShape(LongMatrix2D[][] longMatrix2DArray) {
        int n = -1;
        int n2 = longMatrix2DArray.length;
        while (--n2 >= 0) {
            if (longMatrix2DArray[n2] == null) continue;
            if (n == -1) {
                n = longMatrix2DArray[n2].length;
            }
            if (longMatrix2DArray[n2].length == n) continue;
            throw new IllegalArgumentException("All rows of array must have same number of columns.");
        }
    }

    public LongMatrix2D reshape(LongMatrix1D longMatrix1D, int n, int n2) {
        if (longMatrix1D.size() != (long)(n * n2)) {
            throw new IllegalArgumentException("a.size() != rows*columns");
        }
        LongMatrix2D longMatrix2D = this == sparse ? new SparseLongMatrix2D(n, n2) : new DenseLongMatrix2D(n, n2);
        for (int i = 0; i < n2; ++i) {
            longMatrix2D.viewColumn(i).assign(longMatrix1D.viewPart(i * n, n));
        }
        return longMatrix2D;
    }

    public LongMatrix2D compose(LongMatrix2D[][] longMatrix2DArray) {
        int n;
        int n2;
        int n3;
        LongFactory2D.checkRectangularShape(longMatrix2DArray);
        int n4 = longMatrix2DArray.length;
        int n5 = 0;
        if (longMatrix2DArray.length > 0) {
            n5 = longMatrix2DArray[0].length;
        }
        LongMatrix2D longMatrix2D = this.make(0, 0);
        if (n4 == 0 || n5 == 0) {
            return longMatrix2D;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                LongMatrix2D longMatrix2D2 = longMatrix2DArray[n2][n6];
                if (longMatrix2D2 == null) continue;
                int n7 = longMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                LongMatrix2D longMatrix2D3 = longMatrix2DArray[n3][n8];
                if (longMatrix2D3 == null) continue;
                n = longMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        LongMatrix2D longMatrix2D4 = this.make(n3, n2);
        int n10 = 0;
        for (n = 0; n < n4; ++n) {
            int n11 = 0;
            for (int i = 0; i < n5; ++i) {
                LongMatrix2D longMatrix2D5 = longMatrix2DArray[n][i];
                if (longMatrix2D5 != null) {
                    longMatrix2D4.viewPart(n10, n11, longMatrix2D5.rows(), longMatrix2D5.columns()).assign(longMatrix2D5);
                }
                n11 += nArray[i];
            }
            n10 += nArray2[n];
        }
        return longMatrix2D4;
    }

    public LongMatrix2D composeDiagonal(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = longMatrix2D2.rows();
        int n4 = longMatrix2D2.columns();
        LongMatrix2D longMatrix2D3 = this.make(n + n3, n2 + n4);
        longMatrix2D3.viewPart(0, 0, n, n2).assign(longMatrix2D);
        longMatrix2D3.viewPart(n, n2, n3, n4).assign(longMatrix2D2);
        return longMatrix2D3;
    }

    public LongMatrix2D composeDiagonal(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2, LongMatrix2D longMatrix2D3) {
        LongMatrix2D longMatrix2D4 = this.make(longMatrix2D.rows() + longMatrix2D2.rows() + longMatrix2D3.rows(), longMatrix2D.columns() + longMatrix2D2.columns() + longMatrix2D3.columns());
        longMatrix2D4.viewPart(0, 0, longMatrix2D.rows(), longMatrix2D.columns()).assign(longMatrix2D);
        longMatrix2D4.viewPart(longMatrix2D.rows(), longMatrix2D.columns(), longMatrix2D2.rows(), longMatrix2D2.columns()).assign(longMatrix2D2);
        longMatrix2D4.viewPart(longMatrix2D.rows() + longMatrix2D2.rows(), longMatrix2D.columns() + longMatrix2D2.columns(), longMatrix2D3.rows(), longMatrix2D3.columns()).assign(longMatrix2D3);
        return longMatrix2D4;
    }

    public LongMatrix2D composeBidiagonal(LongMatrix2D longMatrix2D, LongMatrix2D longMatrix2D2) {
        int n = longMatrix2D.rows();
        int n2 = longMatrix2D.columns();
        int n3 = longMatrix2D2.rows();
        int n4 = longMatrix2D2.columns();
        LongMatrix2D longMatrix2D3 = this.make(n + n3 - 1, n2 + n4);
        longMatrix2D3.viewPart(0, 0, n, n2).assign(longMatrix2D);
        longMatrix2D3.viewPart(n - 1, n2, n3, n4).assign(longMatrix2D2);
        return longMatrix2D3;
    }

    public void decompose(LongMatrix2D[][] longMatrix2DArray, LongMatrix2D longMatrix2D) {
        int n;
        int n2;
        int n3;
        LongFactory2D.checkRectangularShape(longMatrix2DArray);
        int n4 = longMatrix2DArray.length;
        int n5 = 0;
        if (longMatrix2DArray.length > 0) {
            n5 = longMatrix2DArray[0].length;
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        int[] nArray = new int[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            n3 = 0;
            n2 = n4;
            while (--n2 >= 0) {
                LongMatrix2D longMatrix2D2 = longMatrix2DArray[n2][n6];
                if (longMatrix2D2 == null) continue;
                int n7 = longMatrix2D2.columns();
                if (n3 > 0 && n7 > 0 && n7 != n3) {
                    throw new IllegalArgumentException("Different number of columns.");
                }
                n3 = Math.max(n3, n7);
            }
            nArray[n6] = n3;
        }
        int[] nArray2 = new int[n4];
        n3 = n4;
        while (--n3 >= 0) {
            n2 = 0;
            int n8 = n5;
            while (--n8 >= 0) {
                LongMatrix2D longMatrix2D3 = longMatrix2DArray[n3][n8];
                if (longMatrix2D3 == null) continue;
                n = longMatrix2D3.rows();
                if (n2 > 0 && n > 0 && n != n2) {
                    throw new IllegalArgumentException("Different number of rows.");
                }
                n2 = Math.max(n2, n);
            }
            nArray2[n3] = n2;
        }
        n3 = 0;
        n2 = n4;
        while (--n2 >= 0) {
            n3 += nArray2[n2];
        }
        n2 = 0;
        int n9 = n5;
        while (--n9 >= 0) {
            n2 += nArray[n9];
        }
        if (longMatrix2D.rows() < n3 || longMatrix2D.columns() < n2) {
            throw new IllegalArgumentException("Parts larger than matrix.");
        }
        n9 = 0;
        for (int i = 0; i < n4; ++i) {
            n = 0;
            for (int j = 0; j < n5; ++j) {
                LongMatrix2D longMatrix2D4 = longMatrix2DArray[i][j];
                if (longMatrix2D4 != null) {
                    longMatrix2D4.assign(longMatrix2D.viewPart(n9, n, longMatrix2D4.rows(), longMatrix2D4.columns()));
                }
                n += nArray[j];
            }
            n9 += nArray2[i];
        }
    }

    public void demo1() {
        System.out.println("\n\n");
        LongMatrix2D[][] longMatrix2DArray = new LongMatrix2D[][]{{null, this.make(2, 2, 1L), null}, {this.make(4, 4, 2L), null, this.make(4, 3, 3L)}, {null, this.make(2, 2, 4L), null}};
        System.out.println("\n" + this.compose(longMatrix2DArray));
        LongMatrix2D[][] longMatrix2DArray2 = new LongMatrix2D[][]{{this.identity(3), null}, {null, this.identity(3).viewColumnFlip()}, {this.identity(3).viewRowFlip(), null}};
        System.out.println("\n" + this.compose(longMatrix2DArray2));
        LongMatrix2D longMatrix2D = this.ascending(2, 2);
        LongMatrix2D longMatrix2D2 = this.descending(2, 2);
        Object var5_5 = null;
        LongMatrix2D[][] longMatrix2DArray3 = new LongMatrix2D[][]{{longMatrix2D, var5_5, longMatrix2D, var5_5}, {var5_5, longMatrix2D, var5_5, longMatrix2D2}};
        System.out.println("\n" + this.compose(longMatrix2DArray3));
    }

    public void demo2() {
        System.out.println("\n\n");
        Object var9_1 = null;
        LongMatrix2D longMatrix2D = this.make(2, 2, 1L);
        LongMatrix2D longMatrix2D2 = this.make(4, 4, 2L);
        LongMatrix2D longMatrix2D3 = this.make(4, 3, 3L);
        LongMatrix2D longMatrix2D4 = this.make(2, 2, 4L);
        LongMatrix2D[][] longMatrix2DArray = new LongMatrix2D[][]{{var9_1, longMatrix2D, var9_1}, {longMatrix2D2, var9_1, longMatrix2D3}, {var9_1, longMatrix2D4, var9_1}};
        LongMatrix2D longMatrix2D5 = this.compose(longMatrix2DArray);
        System.out.println("\n" + longMatrix2D5);
        longMatrix2D.assign(9L);
        longMatrix2D2.assign(9L);
        longMatrix2D3.assign(9L);
        longMatrix2D4.assign(9L);
        this.decompose(longMatrix2DArray, longMatrix2D5);
        System.out.println(longMatrix2D);
        System.out.println(longMatrix2D2);
        System.out.println(longMatrix2D3);
        System.out.println(longMatrix2D4);
    }

    public LongMatrix2D descending(int n, int n2) {
        LongMatrix2D longMatrix2D = this.make(n, n2);
        int n3 = 0;
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                longMatrix2D.setQuick(n4, n5, n3++);
            }
        }
        return longMatrix2D;
    }

    public LongMatrix2D diagonal(LongMatrix1D longMatrix1D) {
        int n = (int)longMatrix1D.size();
        LongMatrix2D longMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            longMatrix2D.setQuick(n2, n2, longMatrix1D.getQuick(n2));
        }
        return longMatrix2D;
    }

    public LongMatrix2D diagonal(int[] nArray) {
        int n = nArray.length;
        LongMatrix2D longMatrix2D = this.make(n, n);
        for (int i = 0; i < n; ++i) {
            longMatrix2D.setQuick(i, i, nArray[i]);
        }
        return longMatrix2D;
    }

    public LongMatrix1D diagonal(LongMatrix2D longMatrix2D) {
        int n = Math.min(longMatrix2D.rows(), longMatrix2D.columns());
        LongMatrix1D longMatrix1D = this.make1D(n);
        int n2 = n;
        while (--n2 >= 0) {
            longMatrix1D.setQuick(n2, longMatrix2D.getQuick(n2, n2));
        }
        return longMatrix1D;
    }

    public LongMatrix2D identity(int n) {
        LongMatrix2D longMatrix2D = this.make(n, n);
        int n2 = n;
        while (--n2 >= 0) {
            longMatrix2D.setQuick(n2, n2, 1L);
        }
        return longMatrix2D;
    }

    public LongMatrix2D make(long[][] lArray) {
        if (this == sparse) {
            return new SparseLongMatrix2D(lArray);
        }
        return new DenseLongMatrix2D(lArray);
    }

    public LongMatrix2D make(int[] nArray, int n) {
        int n2;
        int n3 = n2 = n != 0 ? nArray.length / n : 0;
        if (n * n2 != nArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        LongMatrix2D longMatrix2D = this.make(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                longMatrix2D.setQuick(i, j, nArray[i + j * n]);
            }
        }
        return longMatrix2D;
    }

    public LongMatrix2D make(int n, int n2) {
        if (this == sparse) {
            return new SparseLongMatrix2D(n, n2);
        }
        if (this == rowCompressed) {
            return new SparseRCLongMatrix2D(n, n2);
        }
        return new DenseLongMatrix2D(n, n2);
    }

    public LongMatrix2D make(int n, int n2, long l) {
        if (l == 0L) {
            return this.make(n, n2);
        }
        return this.make(n, n2).assign(l);
    }

    protected LongMatrix1D make1D(int n) {
        return this.make(0, 0).like1D(n);
    }

    public LongMatrix2D random(int n, int n2) {
        return this.make(n, n2).assign(LongFunctions.random());
    }

    public LongMatrix2D repeat(LongMatrix2D longMatrix2D, int n, int n2) {
        int n3 = longMatrix2D.rows();
        int n4 = longMatrix2D.columns();
        LongMatrix2D longMatrix2D2 = this.make(n3 * n, n4 * n2);
        int n5 = n;
        while (--n5 >= 0) {
            int n6 = n2;
            while (--n6 >= 0) {
                longMatrix2D2.viewPart(n3 * n5, n4 * n6, n3, n4).assign(longMatrix2D);
            }
        }
        return longMatrix2D2;
    }

    public LongMatrix2D sample(int n, int n2, int n3, int n4) {
        LongMatrix2D longMatrix2D = this.make(n, n2);
        this.sample(longMatrix2D, n3, n4);
        return longMatrix2D;
    }

    public LongMatrix2D sample(LongMatrix2D longMatrix2D, int n, int n2) {
        int n3 = longMatrix2D.rows();
        int n4 = longMatrix2D.columns();
        double d = 1.0E-9;
        if ((double)n2 < 0.0 - d || (double)n2 > 1.0 + d) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 1) {
            n2 = 1;
        }
        longMatrix2D.assign(0L);
        int n5 = n3 * n4;
        int n6 = Math.round(n5 * n2);
        if (n6 == 0) {
            return longMatrix2D;
        }
        DoubleRandomSamplingAssistant doubleRandomSamplingAssistant = new DoubleRandomSamplingAssistant(n6, n5, new DoubleMersenneTwister());
        for (int i = 0; i < n5; ++i) {
            if (!doubleRandomSamplingAssistant.sampleNextElement()) continue;
            int n7 = i / n4;
            int n8 = i % n4;
            longMatrix2D.set(n7, n8, n);
        }
        return longMatrix2D;
    }
}

