/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tlong;

import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongLongProcedure;
import cern.colt.function.tlong.LongProcedure;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import java.util.Date;

public class LongFunctions {
    public static final LongFunctions longFunctions = new LongFunctions();
    public static final LongFunction abs = new LongFunction(){

        public final long apply(long l) {
            return l < 0L ? -l : l;
        }
    };
    public static final LongFunction dec = new LongFunction(){

        public final long apply(long l) {
            return l--;
        }
    };
    public static final LongFunction factorial = new LongFunction(){

        public final long apply(long l) {
            return (long)DoubleArithmetic.factorial(l);
        }
    };
    public static final LongFunction identity = new LongFunction(){

        public final long apply(long l) {
            return l;
        }
    };
    public static final LongFunction inc = new LongFunction(){

        public final long apply(long l) {
            return l++;
        }
    };
    public static final LongFunction neg = new LongFunction(){

        public final long apply(long l) {
            return -l;
        }
    };
    public static final LongFunction not = new LongFunction(){

        public final long apply(long l) {
            return l ^ 0xFFFFFFFFFFFFFFFFL;
        }
    };
    public static final LongFunction sign = new LongFunction(){

        public final long apply(long l) {
            return l < 0L ? -1L : (l > 0L ? 1L : 0L);
        }
    };
    public static final LongFunction square = new LongFunction(){

        public final long apply(long l) {
            return l * l;
        }
    };
    public static final LongLongFunction and = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l & l2;
        }
    };
    public static final LongLongFunction compare = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l < l2 ? -1L : (l > l2 ? 1L : 0L);
        }
    };
    public static final LongLongFunction div = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l / l2;
        }
    };
    public static final LongLongFunction divNeg = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return -(l / l2);
        }
    };
    public static final LongLongFunction equals = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l == l2 ? 1L : 0L;
        }
    };
    public static final LongLongProcedure isEqual = new LongLongProcedure(){

        public final boolean apply(long l, long l2) {
            return l == l2;
        }
    };
    public static final LongLongProcedure isLess = new LongLongProcedure(){

        public final boolean apply(long l, long l2) {
            return l < l2;
        }
    };
    public static final LongLongProcedure isGreater = new LongLongProcedure(){

        public final boolean apply(long l, long l2) {
            return l > l2;
        }
    };
    public static final LongLongFunction max = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l >= l2 ? l : l2;
        }
    };
    public static final LongLongFunction min = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l <= l2 ? l : l2;
        }
    };
    public static final LongLongFunction minus = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l - l2;
        }
    };
    public static final LongLongFunction mod = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l % l2;
        }
    };
    public static final LongLongFunction mult = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l * l2;
        }
    };
    public static final LongLongFunction multNeg = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return -(l * l2);
        }
    };
    public static final LongLongFunction multSquare = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l * l2 * l2;
        }
    };
    public static final LongLongFunction or = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l | l2;
        }
    };
    public static final LongLongFunction plus = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l + l2;
        }
    };
    public static final LongLongFunction plusAbs = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return Math.abs(l) + Math.abs(l2);
        }
    };
    public static final LongLongFunction pow = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return (long)Math.pow(l, l2);
        }
    };
    public static final LongLongFunction shiftLeft = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l << (int)l2;
        }
    };
    public static final LongLongFunction shiftRightSigned = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l >> (int)l2;
        }
    };
    public static final LongLongFunction shiftRightUnsigned = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l >>> (int)l2;
        }
    };
    public static final LongLongFunction xor = new LongLongFunction(){

        public final long apply(long l, long l2) {
            return l ^ l2;
        }
    };

    protected LongFunctions() {
    }

    public static LongFunction and(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 & l;
            }
        };
    }

    public static LongFunction between(final long l, final long l2) {
        return new LongFunction(){

            public final long apply(long l3) {
                return l <= l3 && l3 <= l2 ? 1L : 0L;
            }
        };
    }

    public static LongFunction bindArg1(final LongLongFunction longLongFunction, final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return longLongFunction.apply(l, l2);
            }
        };
    }

    public static LongFunction bindArg2(final LongLongFunction longLongFunction, final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return longLongFunction.apply(l2, l);
            }
        };
    }

    public static LongFunction chain(final LongFunction longFunction, final LongFunction longFunction2) {
        return new LongFunction(){

            public final long apply(long l) {
                return longFunction.apply(longFunction2.apply(l));
            }
        };
    }

    public static LongLongFunction chain(final LongFunction longFunction, final LongLongFunction longLongFunction) {
        return new LongLongFunction(){

            public final long apply(long l, long l2) {
                return longFunction.apply(longLongFunction.apply(l, l2));
            }
        };
    }

    public static LongLongFunction chain(final LongLongFunction longLongFunction, final LongFunction longFunction, final LongFunction longFunction2) {
        return new LongLongFunction(){

            public final long apply(long l, long l2) {
                return longLongFunction.apply(longFunction.apply(l), longFunction2.apply(l2));
            }
        };
    }

    public static LongFunction compare(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 < l ? -1L : (l2 > l ? 1L : 0L);
            }
        };
    }

    public static LongFunction constant(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l;
            }
        };
    }

    public static LongFunction div(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 / l;
            }
        };
    }

    public static LongFunction equals(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 == l ? 1L : 0L;
            }
        };
    }

    public static LongProcedure isBetween(final long l, final long l2) {
        return new LongProcedure(){

            public final boolean apply(long l3) {
                return l <= l3 && l3 <= l2;
            }
        };
    }

    public static LongProcedure isEqual(final long l) {
        return new LongProcedure(){

            public final boolean apply(long l2) {
                return l2 == l;
            }
        };
    }

    public static LongProcedure isGreater(final long l) {
        return new LongProcedure(){

            public final boolean apply(long l2) {
                return l2 > l;
            }
        };
    }

    public static LongProcedure isLess(final long l) {
        return new LongProcedure(){

            public final boolean apply(long l2) {
                return l2 < l;
            }
        };
    }

    public static LongFunction max(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 >= l ? l2 : l;
            }
        };
    }

    public static LongFunction min(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 <= l ? l2 : l;
            }
        };
    }

    public static LongFunction minus(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 - l;
            }
        };
    }

    public static LongLongFunction minusMult(long l) {
        return LongFunctions.plusMultSecond(-l);
    }

    public static LongFunction mod(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 % l;
            }
        };
    }

    public static LongFunction mult(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 * l;
            }
        };
    }

    public static LongFunction or(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 | l;
            }
        };
    }

    public static LongFunction plus(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 + l;
            }
        };
    }

    public static LongLongFunction multSecond(final long l) {
        return new LongLongFunction(){

            public final long apply(long l3, long l2) {
                return l2 * l;
            }
        };
    }

    public static LongFunction pow(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return (long)Math.pow(l2, l);
            }
        };
    }

    public static LongLongFunction plusMultSecond(long l) {
        return new LongPlusMultSecond(l);
    }

    public static LongLongFunction plusMultFirst(long l) {
        return new LongPlusMultFirst(l);
    }

    public static LongFunction random() {
        return new DoubleMersenneTwister(new Date());
    }

    public static LongFunction shiftLeft(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 << (int)l;
            }
        };
    }

    public static LongFunction shiftRightSigned(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 >> (int)l;
            }
        };
    }

    public static LongFunction shiftRightUnsigned(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 >>> (int)l;
            }
        };
    }

    public static LongLongFunction swapArgs(final LongLongFunction longLongFunction) {
        return new LongLongFunction(){

            public final long apply(long l, long l2) {
                return longLongFunction.apply(l2, l);
            }
        };
    }

    public static LongFunction xor(final long l) {
        return new LongFunction(){

            public final long apply(long l2) {
                return l2 ^ l;
            }
        };
    }
}

