/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.DigitalNetBase2;
import umontreal.iro.lecuyer.hups.PointSetIterator;

public abstract class DigitalSequenceBase2
extends DigitalNetBase2 {
    public abstract void extendSequence(int var1);

    private int[] copyDigitalShift(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    private DigitalNetBase2 initNetVar(boolean bl) {
        DigitalNetBase2 digitalNetBase2 = new DigitalNetBase2();
        digitalNetBase2.dim = bl ? this.dim + 1 : this.dim;
        digitalNetBase2.numPoints = this.numPoints;
        digitalNetBase2.numCols = this.numCols;
        digitalNetBase2.numRows = this.numRows;
        digitalNetBase2.outDigits = this.outDigits;
        digitalNetBase2.normFactor = this.normFactor;
        digitalNetBase2.factor = new double[this.outDigits];
        digitalNetBase2.genMat = new int[digitalNetBase2.dim * this.numCols];
        digitalNetBase2.shiftStream = this.shiftStream;
        digitalNetBase2.capacityShift = this.capacityShift;
        digitalNetBase2.dimShift = this.dimShift;
        digitalNetBase2.digitalShift = this.copyDigitalShift(this.digitalShift);
        if (bl && this.shiftStream != null) {
            digitalNetBase2.addRandomShift(this.dimShift, this.dimShift + 1, this.shiftStream);
        }
        return digitalNetBase2;
    }

    public DigitalNetBase2 toNet() {
        DigitalNetBase2 digitalNetBase2 = this.initNetVar(false);
        for (int i = 0; i < this.dim * this.numCols; ++i) {
            digitalNetBase2.genMat[i] = this.genMat[i];
        }
        return digitalNetBase2;
    }

    public DigitalNetBase2 toNetShiftCj() {
        int n;
        DigitalNetBase2 digitalNetBase2 = this.initNetVar(true);
        for (n = (this.dim + 1) * this.numCols - 1; n >= this.numCols; --n) {
            digitalNetBase2.genMat[n] = this.genMat[n - this.numCols];
        }
        for (n = 0; n < this.numCols; ++n) {
            digitalNetBase2.genMat[n] = 1 << this.outDigits - this.numCols + n;
        }
        return digitalNetBase2;
    }

    public PointSetIterator iteratorShift() {
        return new DigitalNetBase2IteratorShiftGenerators();
    }

    public PointSetIterator iteratorShiftNoGray() {
        return new DigitalNetBase2IteratorShiftNoGray();
    }

    protected class DigitalNetBase2IteratorShiftNoGray
    extends DigitalNetBase2.DigitalNetBase2Iterator {
        private boolean shiftDimFlag = false;

        public DigitalNetBase2IteratorShiftNoGray() {
            this.dimS = DigitalSequenceBase2.this.dim + 1;
            if (DigitalSequenceBase2.this.digitalShift != null && DigitalSequenceBase2.this.dimShift < this.dimS) {
                DigitalSequenceBase2.this.addRandomShift(DigitalSequenceBase2.this.dimShift, this.dimS);
            }
            this.resetCurPointIndex();
        }

        public void init2() {
        }

        protected void addShiftToCache() {
            if (DigitalSequenceBase2.this.digitalShift == null) {
                for (int i = 0; i <= DigitalSequenceBase2.this.dim; ++i) {
                    this.cachedCurPoint[i] = 0;
                }
            } else {
                for (int i = 0; i <= DigitalSequenceBase2.this.dim; ++i) {
                    this.cachedCurPoint[i] = DigitalSequenceBase2.this.digitalShift[i];
                }
            }
        }

        public void setCurPointIndex(int n) {
            if (n == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            this.addShiftToCache();
            int n2 = 0;
            while (n >> n2 != 0) {
                if ((n >> n2 & 1) != 0) {
                    this.cachedCurPoint[0] = this.cachedCurPoint[0] ^ 1 << DigitalSequenceBase2.this.outDigits - DigitalSequenceBase2.this.numCols + n2;
                    for (int i = 1; i <= DigitalSequenceBase2.this.dim; ++i) {
                        int n3 = i;
                        this.cachedCurPoint[n3] = this.cachedCurPoint[n3] ^ DigitalSequenceBase2.this.genMat[(i - 1) * DigitalSequenceBase2.this.numCols + n2];
                    }
                }
                ++n2;
            }
        }

        public int resetToNextPoint() {
            if (this.curPointIndex + 1 >= DigitalSequenceBase2.this.numPoints) {
                return ++this.curPointIndex;
            }
            int n = this.curPointIndex ^ this.curPointIndex + 1;
            int n2 = 0;
            while (n >> n2 != 0) {
                if ((n >> n2 & 1) != 0) {
                    this.cachedCurPoint[0] = this.cachedCurPoint[0] ^ 1 << DigitalSequenceBase2.this.outDigits - DigitalSequenceBase2.this.numCols + n2;
                    for (int i = 1; i <= DigitalSequenceBase2.this.dim; ++i) {
                        int n3 = i;
                        this.cachedCurPoint[n3] = this.cachedCurPoint[n3] ^ DigitalSequenceBase2.this.genMat[(i - 1) * DigitalSequenceBase2.this.numCols + n2];
                    }
                }
                ++n2;
            }
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }
    }

    protected class DigitalNetBase2IteratorShiftGenerators
    extends DigitalNetBase2.DigitalNetBase2Iterator {
        public DigitalNetBase2IteratorShiftGenerators() {
            this.dimS = DigitalSequenceBase2.this.dim + 1;
            if (DigitalSequenceBase2.this.digitalShift != null && DigitalSequenceBase2.this.dimShift < this.dimS) {
                DigitalSequenceBase2.this.addRandomShift(DigitalSequenceBase2.this.dimShift, this.dimS);
            }
            this.resetCurPointIndex();
        }

        public void init2() {
        }

        protected void addShiftToCache() {
            if (DigitalSequenceBase2.this.digitalShift == null) {
                for (int i = 0; i < this.dimS; ++i) {
                    this.cachedCurPoint[i] = 0;
                }
            } else {
                for (int i = 0; i < this.dimS; ++i) {
                    this.cachedCurPoint[i] = DigitalSequenceBase2.this.digitalShift[i];
                }
            }
        }

        public void setCurPointIndex(int n) {
            if (n == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            this.addShiftToCache();
            int n2 = n ^ n >> 1;
            int n3 = 0;
            while (n2 >> n3 != 0) {
                if ((n2 >> n3 & 1) != 0) {
                    this.cachedCurPoint[0] = this.cachedCurPoint[0] ^ 1 << DigitalSequenceBase2.this.outDigits - DigitalSequenceBase2.this.numCols + n3;
                    for (int i = 1; i <= DigitalSequenceBase2.this.dim; ++i) {
                        int n4 = i;
                        this.cachedCurPoint[n4] = this.cachedCurPoint[n4] ^ DigitalSequenceBase2.this.genMat[(i - 1) * DigitalSequenceBase2.this.numCols + n3];
                    }
                }
                ++n3;
            }
        }

        public int resetToNextPoint() {
            int n = 0;
            while ((this.curPointIndex >> n & 1) != 0) {
                ++n;
            }
            if (n < DigitalSequenceBase2.this.numCols) {
                this.cachedCurPoint[0] = this.cachedCurPoint[0] ^ 1 << DigitalSequenceBase2.this.outDigits - DigitalSequenceBase2.this.numCols + n;
                for (int i = 1; i <= DigitalSequenceBase2.this.dim; ++i) {
                    int n2 = i;
                    this.cachedCurPoint[n2] = this.cachedCurPoint[n2] ^ DigitalSequenceBase2.this.genMat[(i - 1) * DigitalSequenceBase2.this.numCols + n];
                }
            }
            this.curCoordIndex = 0;
            return ++this.curPointIndex;
        }
    }
}

