/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.EmpiricalDist;
import umontreal.iro.lecuyer.util.Misc;

public class LoglogisticDist
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public LoglogisticDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return LoglogisticDist.density(this.alpha, this.beta, d);
    }

    public double cdf(double d) {
        return LoglogisticDist.cdf(this.alpha, this.beta, d);
    }

    public double barF(double d) {
        return LoglogisticDist.barF(this.alpha, this.beta, d);
    }

    public double inverseF(double d) {
        return LoglogisticDist.inverseF(this.alpha, this.beta, d);
    }

    public double getMean() {
        return LoglogisticDist.getMean(this.alpha, this.beta);
    }

    public double getVariance() {
        return LoglogisticDist.getVariance(this.alpha, this.beta);
    }

    public double getStandardDeviation() {
        return LoglogisticDist.getStandardDeviation(this.alpha, this.beta);
    }

    public static double density(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0 || d3 >= 8.988465674311579E307) {
            return 0.0;
        }
        if (d3 <= d2) {
            double d4 = Math.pow(d3 / d2, d);
            double d5 = 1.0 + d4;
            d5 *= d5 * d2;
            return d * d4 * d2 / (d3 * d5);
        }
        double d6 = Math.pow(d2 / d3, d);
        double d7 = 1.0 + d6;
        d7 *= d7 * d2;
        return d * d6 * d2 / (d3 * d7);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        if (d3 >= 8.988465674311579E307) {
            return 1.0;
        }
        double d4 = d3 / d2;
        if (d4 >= 1.0) {
            return 1.0 / (1.0 + Math.pow(1.0 / d4, d));
        }
        double d5 = Math.pow(d4, d);
        return d5 / (d5 + 1.0);
    }

    public static double barF(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 <= 0.0) {
            return 1.0;
        }
        if (d3 >= 8.988465674311579E307) {
            return 0.0;
        }
        double d4 = d3 / d2;
        if (d4 <= 1.0) {
            return 1.0 / (1.0 + Math.pow(d4, d));
        }
        double d5 = Math.pow(1.0 / d4, d);
        return d5 / (d5 + 1.0);
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u not in (0, 1]");
        }
        if (d3 >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        if (d3 <= 0.5) {
            return d2 * Math.pow(d3 / (1.0 - d3), 1.0 / d);
        }
        return d2 / Math.pow((1.0 - d3) / d3, 1.0 / d);
    }

    public static double[] getMLE(double[] dArray, int n) {
        int n2;
        double d;
        double d2 = 0.0;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        Optim optim = new Optim(dArray, n);
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        int[] nArray = new int[2];
        double[][] dArray7 = new double[3][3];
        double[] dArray8 = new double[3];
        dArray4[2] = EmpiricalDist.getMedian(dArray, n);
        if (dArray4[2] < 0.0) {
            throw new IllegalArgumentException("median < 0");
        }
        if (dArray4[2] <= 0.0) {
            dArray4[2] = 1.0;
        }
        if ((d = Misc.quickSelect(dArray, n, n2 = Math.round((float)n / 4.0f))) < 0.0) {
            throw new IllegalArgumentException("x[i] < 0");
        }
        dArray4[1] = d > 0.0 ? Math.log(3.0) / (Math.log(dArray4[2]) - Math.log(d)) : 1.0;
        Uncmin_f77.optif0_f77((int)2, (double[])dArray4, (Uncmin_methods)optim, (double[])dArray3, (double[])dArray5, (double[])dArray6, (int[])nArray, (double[][])dArray7, (double[])dArray8);
        for (int i = 0; i < 2; ++i) {
            dArray2[i] = dArray3[i + 1];
        }
        return dArray2;
    }

    public static double[] getMaximumLikelihoodEstimate(double[] dArray, int n) {
        return LoglogisticDist.getMLE(dArray, n);
    }

    public static LoglogisticDist getInstanceFromMLE(double[] dArray, int n) {
        double[] dArray2 = LoglogisticDist.getMaximumLikelihoodEstimate(dArray, n);
        return new LoglogisticDist(dArray2[0], dArray2[1]);
    }

    public static double getMean(double d, double d2) {
        if (d <= 1.0) {
            throw new IllegalArgumentException("alpha <= 1");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double d3 = Math.PI / d;
        return d2 * d3 / Math.sin(d3);
    }

    public static double getVariance(double d, double d2) {
        if (d <= 2.0) {
            throw new IllegalArgumentException("alpha <= 2");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double d3 = Math.PI / d;
        return d2 * d2 * d3 * (2.0 / Math.sin(2.0 * d3) - d3 / (Math.sin(d3) * Math.sin(d3)));
    }

    public static double getStandardDeviation(double d, double d2) {
        return Math.sqrt(LoglogisticDist.getVariance(d, d2));
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = d;
        this.beta = d2;
        this.supportA = 0.0;
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.alpha, this.beta};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", beta = " + this.beta;
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] xi;

        public Optim(double[] dArray, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(dArray, 0, this.xi, 0, n);
        }

        public double f_to_minimize(double[] dArray) {
            if (dArray[1] <= 0.0 || dArray[2] <= 0.0) {
                return 1.0E200;
            }
            double d = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double d2 = LoglogisticDist.density(dArray[1], dArray[2], this.xi[i]);
                if (d2 > 0.0) {
                    d -= Math.log(d2);
                    continue;
                }
                d += 709.0;
            }
            return d;
        }

        public void gradient(double[] dArray, double[] dArray2) {
        }

        public void hessian(double[] dArray, double[][] dArray2) {
        }
    }
}

