/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionUtil;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class TruncatedDist
extends ContinuousDistribution {
    public static int NUMINTERVALS = 500;
    private ContinuousDistribution dist;
    private double fa;
    private double fb;
    private double fbfa;
    private double a;
    private double b;
    private double approxMean;
    private double approxVariance;
    private double approxStandardDeviation;

    public TruncatedDist(ContinuousDistribution continuousDistribution, double d, double d2) {
        this.setParams(continuousDistribution, d, d2);
    }

    public double density(double d) {
        return this.dist.density(d) / this.fbfa;
    }

    public double cdf(double d) {
        if (d <= this.a) {
            return 0.0;
        }
        if (d >= this.b) {
            return 1.0;
        }
        return this.dist.cdf(d) / this.fbfa;
    }

    public double barF(double d) {
        if (d <= this.a) {
            return 1.0;
        }
        if (d >= this.b) {
            return 0.0;
        }
        return this.dist.barF(d) / this.fbfa;
    }

    public double inverseF(double d) {
        return this.dist.inverseF(this.fa + this.fbfa * d);
    }

    public double getMean() {
        if (Double.isNaN(this.approxMean)) {
            throw new UnsupportedOperationException("Undefined mean");
        }
        return this.approxMean;
    }

    public double getVariance() {
        if (Double.isNaN(this.approxVariance)) {
            throw new UnsupportedOperationException("Unknown variance");
        }
        return this.approxVariance;
    }

    public double getStandardDeviation() {
        if (Double.isNaN(this.approxStandardDeviation)) {
            throw new UnsupportedOperationException("Unknown standard deviation");
        }
        return this.approxStandardDeviation;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getFa() {
        return this.fa;
    }

    public double getFb() {
        return this.fb;
    }

    public double getArea() {
        return this.fbfa;
    }

    public void setParams(ContinuousDistribution continuousDistribution, double d, double d2) {
        this.dist = continuousDistribution;
        if (d >= d2) {
            throw new IllegalArgumentException("a must be smaller than b.");
        }
        this.supportA = this.a = d;
        this.supportB = this.b = d2;
        this.fa = d == Double.NEGATIVE_INFINITY ? 0.0 : continuousDistribution.cdf(d);
        this.fb = d2 == Double.POSITIVE_INFINITY ? 1.0 : continuousDistribution.cdf(d2);
        this.fbfa = this.fb - this.fa;
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            this.approxStandardDeviation = Double.NaN;
            this.approxVariance = Double.NaN;
            this.approxMean = Double.NaN;
        } else {
            MomentFunction momentFunction = new MomentFunction(continuousDistribution, 1);
            this.approxMean = MathFunctionUtil.simpsonIntegral(momentFunction, d, d2, NUMINTERVALS) / this.fbfa;
            MomentFunction momentFunction2 = new MomentFunction(continuousDistribution, 2, this.approxMean);
            this.approxVariance = MathFunctionUtil.simpsonIntegral(momentFunction2, d, d2, NUMINTERVALS) / this.fbfa;
            this.approxStandardDeviation = Math.sqrt(this.approxVariance);
        }
    }

    public double[] getParams() {
        double[] dArray = new double[]{this.a, this.b, this.fa, this.fb, this.fbfa};
        return dArray;
    }

    public String toString() {
        return this.getClass().getName() + " : a = " + this.a + ", b = " + this.b + ", F(a) = " + this.fa + ", F(b) = " + this.fb + ", F(b)-F(a) = " + this.fbfa;
    }

    private static class MomentFunction
    implements MathFunction {
        private ContinuousDistribution dist;
        private int moment;
        private double offset;

        public MomentFunction(ContinuousDistribution continuousDistribution, int n) {
            this.dist = continuousDistribution;
            this.moment = n;
        }

        public MomentFunction(ContinuousDistribution continuousDistribution, int n, double d) {
            this(continuousDistribution, n);
            this.offset = d;
        }

        public double evaluate(double d) {
            double d2 = this.dist.density(d);
            double d3 = d - this.offset;
            for (int i = 0; i < this.moment; ++i) {
                d2 *= d3;
            }
            return d2;
        }
    }
}

