/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdistmulti;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdistmulti.ContinuousDistribution2Dim;

public class BiNormalDist
extends ContinuousDistribution2Dim {
    protected int ndigit;
    protected double mu1;
    protected double mu2;
    protected double sigma1;
    protected double sigma2;
    protected double rho;
    protected double racRho;
    protected double detS;
    protected static final double RHO_SMALL = 1.0E-8;
    private static final double[] Z = new double[]{0.04691008, 0.23076534, 0.5, 0.76923466, 0.95308992};
    private static final double[] W = new double[]{0.018854042, 0.038088059, 0.0452707394, 0.038088059, 0.018854042};
    private static final double[] AGauss = new double[]{-0.72657601, 0.71070688, -0.142248368, 0.127414796};

    public BiNormalDist(double d) {
        this.setParams(0.0, 1.0, 0.0, 1.0, d);
    }

    public BiNormalDist(double d, double d2, double d3, double d4, double d5) {
        this.setParams(d, d2, d3, d4, d5);
    }

    public double density(double d, double d2) {
        if (Math.abs(this.rho) == 1.0) {
            throw new IllegalArgumentException("|rho| = 1");
        }
        double d3 = (d - this.mu1) / this.sigma1;
        double d4 = (d2 - this.mu2) / this.sigma2;
        double d5 = (d3 * d3 - 2.0 * this.rho * d3 * d4 + d4 * d4) / (2.0 * this.racRho * this.racRho);
        return Math.exp(-d5) / this.detS;
    }

    public static double density(double d, double d2, double d3) {
        return BiNormalDist.density(0.0, 1.0, d, 0.0, 1.0, d2, d3);
    }

    public static double density(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(d7) >= 1.0) {
            throw new IllegalArgumentException("|rho| >= 1");
        }
        double d8 = (d3 - d) / d2;
        double d9 = (d6 - d4) / d5;
        double d10 = (1.0 - d7) * (1.0 + d7);
        double d11 = (d8 * d8 - 2.0 * d7 * d8 * d9 + d9 * d9) / (2.0 * d10);
        return Math.exp(-d11) / (Math.PI * 2 * d2 * d5 * Math.sqrt(d10));
    }

    protected static double Gauss(double d) {
        double d2 = 1.0 / (1.0 + 0.23164189 * Math.abs(d));
        double d3 = 0.53070271;
        for (int i = 0; i < 4; ++i) {
            d3 = d3 * d2 + AGauss[i];
        }
        d3 = d3 * d2 * Math.exp(-d * d / 2.0);
        if (d > 0.0) {
            d3 = 1.0 - d3;
        }
        return d3;
    }

    protected static double specialCDF(double d, double d2, double d3, double d4) {
        if (Math.abs(d3) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        if (d == 0.0 && d2 == 0.0) {
            return 0.25 + Math.asin(d3) / (Math.PI * 2);
        }
        if (d3 == 1.0) {
            if (d2 < d) {
                d = d2;
            }
            return NormalDist.cdf01(d);
        }
        if (d3 == -1.0) {
            if (d2 <= -d) {
                return 0.0;
            }
            return NormalDist.cdf01(d) - NormalDist.cdf01(-d2);
        }
        if (Math.abs(d3) < 1.0E-8) {
            return NormalDist.cdf01(d) * NormalDist.cdf01(d2);
        }
        if (d <= -d4 || d2 <= -d4) {
            return 0.0;
        }
        if (d >= d4) {
            return NormalDist.cdf01(d2);
        }
        if (d2 >= d4) {
            return NormalDist.cdf01(d);
        }
        return -2.0;
    }

    public static double cdf(double d, double d2, double d3) {
        double d4 = BiNormalDist.specialCDF(d, d2, d3, 20.0);
        if (d4 >= 0.0) {
            return d4;
        }
        d4 = 0.0;
        double d5 = -d;
        double d6 = -d2;
        double d7 = (d5 * d5 + d6 * d6) / 2.0;
        if (Math.abs(d3) >= 0.7) {
            double d8;
            double d9 = (1.0 - d3) * (1.0 + d3);
            double d10 = Math.sqrt(d9);
            if (d3 < 0.0) {
                d6 = -d6;
            }
            double d11 = (d8 = d5 * d6) < 300.0 ? Math.exp(-d8 / 2.0) : 0.0;
            if (d9 != 0.0) {
                double d12 = Math.abs(d5 - d6);
                double d13 = d12 * d12 / 2.0;
                double d14 = 0.5 - d8 / 8.0;
                double d15 = 3.0 - 2.0 * d14 * d13;
                d4 = 0.13298076 * (d12 /= d10) * d15 * (1.0 - BiNormalDist.Gauss(d12)) - Math.exp(-d13 / d9) * (d15 + d14 * d9) * 0.053051647;
                for (int i = 0; i < 5; ++i) {
                    double d16 = d10 * Z[i];
                    double d17 = d16 * d16;
                    d9 = Math.sqrt(1.0 - d17);
                    d4 -= W[i] * Math.exp(-d13 / d17) * (Math.exp(-d8 / (1.0 + d9)) / d9 / d11 - 1.0 - d14 * d17);
                }
            }
            if (d3 > 0.0) {
                d4 = d4 * d10 * d11 + (1.0 - BiNormalDist.Gauss(Math.max(d5, d6)));
            } else if (d3 < 0.0) {
                d4 = (d5 < d6 ? BiNormalDist.Gauss(d6) - BiNormalDist.Gauss(d5) : 0.0) - d4 * d10 * d11;
            }
        } else {
            double d18 = d5 * d6;
            for (int i = 0; i < 5; ++i) {
                double d19 = d3 * Z[i];
                double d20 = 1.0 - d19 * d19;
                d4 += W[i] * Math.exp((d19 * d18 - d7) / d20) / Math.sqrt(d20);
            }
            d4 = (1.0 - BiNormalDist.Gauss(d5)) * (1.0 - BiNormalDist.Gauss(d6)) + d3 * d4;
        }
        if (d4 <= 0.0) {
            return 0.0;
        }
        if (d4 <= 1.0) {
            return d4;
        }
        return 1.0;
    }

    public double cdf(double d, double d2) {
        return BiNormalDist.cdf((d - this.mu1) / this.sigma1, (d2 - this.mu2) / this.sigma2, this.rho);
    }

    public static double cdf(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double d8 = (d3 - d) / d2;
        double d9 = (d6 - d4) / d5;
        return BiNormalDist.cdf(d8, d9, d7);
    }

    public static double barF(double d, double d2, double d3) {
        return BiNormalDist.cdf(-d, -d2, d3);
    }

    public double barF(double d, double d2) {
        return BiNormalDist.barF((d - this.mu1) / this.sigma1, (d2 - this.mu2) / this.sigma2, this.rho);
    }

    public static double barF(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        double d8 = (d3 - d) / d2;
        double d9 = (d6 - d4) / d5;
        return BiNormalDist.barF(d8, d9, d7);
    }

    public double[] getMean() {
        return BiNormalDist.getMean(this.mu1, this.mu2, this.sigma1, this.sigma2, this.rho);
    }

    public static double[] getMean(double d, double d2, double d3, double d4, double d5) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(d5) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[] dArray = new double[]{d, d3};
        return dArray;
    }

    public double[][] getCovariance() {
        return BiNormalDist.getCovariance(this.mu1, this.sigma1, this.mu2, this.sigma2, this.rho);
    }

    public static double[][] getCovariance(double d, double d2, double d3, double d4, double d5) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(d5) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[][] dArray = new double[2][2];
        dArray[0][0] = d2 * d2;
        dArray[0][1] = d5 * d2 * d4;
        dArray[1][0] = dArray[0][1];
        dArray[1][1] = d4 * d4;
        return dArray;
    }

    public double[][] getCorrelation() {
        return BiNormalDist.getCovariance(this.mu1, this.sigma1, this.mu2, this.sigma2, this.rho);
    }

    public static double[][] getCorrelation(double d, double d2, double d3, double d4, double d5) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(d5) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        double[][] dArray = new double[2][2];
        dArray[0][0] = 1.0;
        dArray[0][1] = d5;
        dArray[1][0] = d5;
        dArray[1][1] = 1.0;
        return dArray;
    }

    public double getMu1() {
        return this.mu1;
    }

    public double getMu2() {
        return this.mu2;
    }

    public double getSigma1() {
        return this.sigma1;
    }

    public double getSigma2() {
        return this.sigma2;
    }

    protected void setParams(double d, double d2, double d3, double d4, double d5) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma1 <= 0");
        }
        if (d4 <= 0.0) {
            throw new IllegalArgumentException("sigma2 <= 0");
        }
        if (Math.abs(d5) > 1.0) {
            throw new IllegalArgumentException("|rho| > 1");
        }
        this.dimension = 2;
        this.mu1 = d;
        this.sigma1 = d2;
        this.mu2 = d3;
        this.sigma2 = d4;
        this.rho = d5;
        this.racRho = Math.sqrt((1.0 - d5) * (1.0 + d5));
        this.detS = Math.PI * 2 * d2 * d4 * this.racRho;
    }
}

