/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.regression.DecoratedTsVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.LaggedTsVariable;
import java.util.Map;
import java.util.Objects;

public class TsVariableDescriptor
implements Cloneable,
InformationSetSerializable {
    public static final String NAME = "name";
    public static final String EFFECT = "effect";
    public static final String FIRSTLAG = "firstlag";
    public static final String LASTLAG = "lastlag";
    private String m_name;
    private int m_firstlag;
    private int m_lastlag;
    private UserComponentType m_effect = UserComponentType.Undefined;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, NAME), String.class);
        dic.put(InformationSet.item(prefix, EFFECT), String.class);
        dic.put(InformationSet.item(prefix, FIRSTLAG), Integer.class);
        dic.put(InformationSet.item(prefix, LASTLAG), Integer.class);
    }

    public TsVariableDescriptor() {
    }

    public TsVariableDescriptor(String name) {
        this.m_name = name;
    }

    public TsVariableDescriptor clone() {
        try {
            return (TsVariableDescriptor)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public String toString() {
        if (this.m_name == null) {
            return "Unnamed";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_name);
        if (this.m_firstlag != 0 || this.m_lastlag != 0) {
            builder.append('[').append(this.m_firstlag);
            if (this.m_firstlag != this.m_lastlag) {
                builder.append(" : ").append(this.m_lastlag);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public ITsVariable toTsVariable(ProcessingContext context) {
        ITsVariable var = context.getTsVariable(this.m_name);
        if (var == null) {
            return null;
        }
        DecoratedTsVariable x = new DecoratedTsVariable(var, this.m_name);
        if (this.m_firstlag == 0 && this.m_lastlag == 0) {
            return x;
        }
        return new LaggedTsVariable(x, this.m_firstlag, this.m_lastlag);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String value) {
        this.m_name = value;
    }

    public int getFirstLag() {
        return this.m_firstlag;
    }

    public int getLastLag() {
        return this.m_lastlag;
    }

    public void setFirstLag(int start) {
        if (start > this.m_lastlag) {
            return;
        }
        this.m_firstlag = start;
    }

    public void setLastLag(int end) {
        if (this.m_firstlag > end) {
            return;
        }
        this.m_lastlag = end;
    }

    public void setLags(int start, int end) {
        if (start > end) {
            throw new TsException("Invalid lags");
        }
        this.m_firstlag = start;
        this.m_lastlag = end;
    }

    public UserComponentType getEffect() {
        return this.m_effect;
    }

    public void setEffect(UserComponentType value) {
        this.m_effect = value;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TsVariableDescriptor && this.equals((TsVariableDescriptor)obj);
    }

    private boolean equals(TsVariableDescriptor other) {
        return other.m_firstlag == this.m_firstlag && other.m_lastlag == this.m_lastlag && other.m_name.equals(this.m_name) && other.m_effect == this.m_effect;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.m_name);
        hash = 37 * hash + this.m_firstlag;
        hash = 37 * hash + this.m_lastlag;
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        if (this.m_name != null) {
            info.add(NAME, this.m_name);
        }
        if (verbose || this.m_firstlag != 0) {
            info.add(FIRSTLAG, Integer.valueOf(this.m_firstlag));
        }
        if (verbose || this.m_lastlag != 0) {
            info.add(LASTLAG, Integer.valueOf(this.m_lastlag));
        }
        if (verbose || this.m_effect != UserComponentType.Undefined) {
            info.add(EFFECT, this.m_effect.name());
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        String effect;
        Integer llag;
        this.m_name = info.get(NAME, String.class);
        Integer flag = info.get(FIRSTLAG, Integer.class);
        if (flag != null) {
            this.m_firstlag = flag;
        }
        if ((llag = info.get(LASTLAG, Integer.class)) != null) {
            this.m_lastlag = llag;
        }
        if ((effect = info.get(EFFECT, String.class)) != null) {
            this.m_effect = UserComponentType.from(effect);
        }
        return true;
    }

    public static enum UserComponentType {
        Undefined,
        Series,
        Trend,
        Seasonal,
        SeasonallyAdjusted,
        Irregular;


        public static UserComponentType of(ComponentType type) {
            switch (type) {
                case Series: {
                    return Series;
                }
                case Trend: {
                    return Trend;
                }
                case Irregular: {
                    return Irregular;
                }
                case SeasonallyAdjusted: {
                    return SeasonallyAdjusted;
                }
                case Seasonal: 
                case CalendarEffect: {
                    return Seasonal;
                }
            }
            return Undefined;
        }

        public static UserComponentType from(String s) {
            UserComponentType type = UserComponentType.valueOf(s);
            if (type != null) {
                return type;
            }
            ComponentType ctype = ComponentType.valueOf(s);
            if (ctype != null) {
                return UserComponentType.of(ctype);
            }
            return Undefined;
        }

        public ComponentType type() {
            switch (this.ordinal()) {
                case 1: {
                    return ComponentType.Series;
                }
                case 2: {
                    return ComponentType.Trend;
                }
                case 5: {
                    return ComponentType.Irregular;
                }
                case 4: {
                    return ComponentType.SeasonallyAdjusted;
                }
                case 3: {
                    return ComponentType.Seasonal;
                }
            }
            return ComponentType.Undefined;
        }
    }
}

