/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v20;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.api.SdmxAttribute;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.parser.v21.CodelistParser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataStructureParser
implements Parser<List<DataFlowStructure>> {
    private static final String sourceClass = DataStructureParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String DATASTRUCTURE = "KeyFamily";
    static final String CODELISTS = "CodeLists";
    static final String CODELIST = "CodeList";
    static final String CODELISTAGENCY = "codelistAgency";
    static final String CODE = "Code";
    static final String CODE_ID = "value";
    static final String CODE_DESCRIPTION = "Description";
    static final String CONCEPTS = "Concepts";
    static final String CONCEPTSCHEME = "ConceptScheme";
    static final String CONCEPT = "Concept";
    static final String COMPONENTS = "Components";
    static final String NAME = "Name";
    static final String DIMENSION = "Dimension";
    static final String ATTRIBUTE = "Attribute";
    static final String TIMEDIMENSION = "TimeDimension";
    static final String PRIMARYMEASURE = "PrimaryMeasure";
    static final String CONCEPT_REF = "conceptRef";
    static final String ID = "id";
    static final String AGENCYID = "agencyID";
    static final String LOCAL_REPRESENTATION = "LocalRepresentation";
    static final String REF = "Ref";

    @Override
    public List<DataFlowStructure> parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        ArrayList<DataFlowStructure> arrayList = new ArrayList<DataFlowStructure>();
        Map<String, Codelist> map = null;
        Map<String, String> map2 = null;
        DataFlowStructure dataFlowStructure = null;
        LocalizedText localizedText = new LocalizedText(list);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == CODELISTS) {
                    map = DataStructureParser.getCodelists(xMLEventReader, list);
                } else if (startElement.getName().getLocalPart() == CONCEPTS) {
                    map2 = DataStructureParser.getConcepts(xMLEventReader, list);
                } else if (startElement.getName().getLocalPart() == DATASTRUCTURE) {
                    localizedText = new LocalizedText(list);
                    String string = null;
                    String string2 = null;
                    for (Attribute attribute : startElement::getAttributes) {
                        switch (attribute.getName().toString()) {
                            case "id": {
                                string = attribute.getValue();
                                break;
                            }
                            case "agencyID": {
                                string2 = attribute.getValue();
                            }
                        }
                    }
                    dataFlowStructure = new DataFlowStructure(string, string2, null);
                } else if (startElement.getName().getLocalPart().equals(NAME)) {
                    if (dataFlowStructure != null) {
                        localizedText.setText(startElement, xMLEventReader);
                    }
                } else if (startElement.getName().getLocalPart().equals(COMPONENTS)) {
                    if (dataFlowStructure != null) {
                        DataStructureParser.setStructureDimensionsAndAttributes(dataFlowStructure, xMLEventReader, map, map2);
                    } else {
                        throw new RuntimeException("Error during Structure Parsing. Null current structure.");
                    }
                }
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(DATASTRUCTURE)) continue;
            logger.finer("Adding data structure. " + dataFlowStructure);
            dataFlowStructure.setName(localizedText.getText());
            arrayList.add(dataFlowStructure);
        }
        logger.exiting(sourceClass, "parse");
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setStructureDimensionsAndAttributes(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader, Map<String, Codelist> map, Map<String, String> map2) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureDimensions");
        String string = dataFlowStructure.getAgency();
        int n = 0;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object4;
                Object object2;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals(DIMENSION) || startElement.getName().getLocalPart().equals(ATTRIBUTE)) {
                    Object object3;
                    boolean bl = startElement.getName().getLocalPart().equals(DIMENSION);
                    logger.finer(bl ? "Got dimension" : "Got attribute");
                    object2 = null;
                    object4 = null;
                    String string2 = null;
                    String string3 = null;
                    Codelist codelist = null;
                    for (Attribute attribute : startElement::getAttributes) {
                        if (attribute.getName().toString().equals(CONCEPT_REF)) {
                            object2 = attribute.getValue();
                            continue;
                        }
                        if (attribute.getName().toString().equalsIgnoreCase(CODELIST)) {
                            string2 = attribute.getValue();
                            continue;
                        }
                        if (!attribute.getName().toString().equals(CODELISTAGENCY)) continue;
                        string3 = attribute.getValue();
                    }
                    if (object2 == null || ((String)object2).isEmpty()) {
                        throw new RuntimeException("Error during Structure Parsing. Invalid id: " + object2);
                    }
                    if (map2 != null) {
                        object4 = map2.get(string + "/" + (String)object2);
                    }
                    if (string2 != null && !string2.isEmpty()) {
                        object3 = new SDMXReference(string2, string3 != null ? string3 : string, null);
                        if (map != null) {
                            codelist = map.get(((SDMXReference)object3).getFullIdentifier());
                        }
                    } else if (bl) {
                        throw new RuntimeException("Error during Structure Parsing. Invalid CODELIST: " + string2);
                    }
                    if (bl) {
                        object3 = new Dimension((String)object2, (String)object4, codelist, ++n);
                        logger.finer("Adding dimension: " + object3);
                        dataFlowStructure.addDimension((Dimension)object3);
                    } else {
                        object3 = new SdmxAttribute((String)object2, (String)object4, codelist);
                        logger.finer("Adding attribute: " + object3);
                        dataFlowStructure.addAttribute((SdmxAttribute)object3);
                    }
                } else if (startElement.getName().getLocalPart().equals(TIMEDIMENSION)) {
                    logger.finer("Got time dimension");
                    String string4 = null;
                    for (Object object4 : startElement::getAttributes) {
                        if (!object4.getName().toString().equals(CONCEPT_REF)) continue;
                        string4 = object4.getValue();
                    }
                    if (string4 == null || string4.isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid time dimension: " + string4);
                    if (dataFlowStructure == null) throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                    logger.finer("Adding time dimension: " + string4);
                    dataFlowStructure.setTimeDimension(string4);
                } else if (startElement.getName().getLocalPart().equals(PRIMARYMEASURE)) {
                    logger.finer("Got primary measure");
                    Iterator<Attribute> iterator = startElement.getAttributes();
                    object2 = null;
                    while (iterator.hasNext()) {
                        object4 = iterator.next();
                        if (!object4.getName().toString().equals(CONCEPT_REF)) continue;
                        object2 = object4.getValue();
                    }
                    if (object2 == null || ((String)object2).isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid primary measure: " + object2);
                    if (dataFlowStructure == null) throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                    logger.finer("Adding primary measure: " + (String)object2);
                    dataFlowStructure.setMeasure((String)object2);
                    continue;
                }
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(COMPONENTS)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureDimensions");
    }

    private static Map<String, Codelist> getCodelists(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        HashMap<String, Codelist> hashMap = new HashMap<String, Codelist>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object;
                StartElement startElement = xMLEvent.asStartElement();
                if (!startElement.getName().getLocalPart().equalsIgnoreCase(CODELIST)) continue;
                Iterator<Attribute> iterator = startElement.getAttributes();
                String string = null;
                String string2 = null;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object.getName().toString().equals(ID)) {
                        string = object.getValue();
                        continue;
                    }
                    if (!object.getName().toString().equals(AGENCYID)) continue;
                    string2 = object.getValue();
                }
                logger.finer("Got codelist: " + string);
                object = CodelistParser.getCodes(new SDMXReference(string, string2, null), xMLEventReader, list, CODE_ID, CODE_DESCRIPTION);
                hashMap.put(((SDMXReference)object).getFullIdentifier(), (Codelist)object);
                continue;
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CODELISTS)) continue;
            break;
        }
        return hashMap;
    }

    private static Map<String, String> getConcepts(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object;
                Iterator<Attribute> iterator;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals(CONCEPTSCHEME)) {
                    iterator = startElement.getAttributes();
                    string = null;
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (!object.getName().toString().equals(AGENCYID)) continue;
                        string = object.getValue();
                    }
                    logger.finer("Got conceptSchemeAgency: " + string);
                    continue;
                }
                if (!startElement.getName().getLocalPart().equals(CONCEPT)) continue;
                iterator = startElement.getAttributes();
                object = null;
                String string2 = null;
                String string3 = "";
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equals(ID)) {
                        object = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equals(AGENCYID)) continue;
                    string2 = attribute.getValue();
                }
                if (string2 == null && string != null) {
                    string2 = string;
                }
                string3 = string2 + "/" + (String)object;
                logger.finer("Got concept: " + string3);
                hashMap.put(string3, DataStructureParser.getConceptName(xMLEventReader, list));
                continue;
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CONCEPTS)) continue;
            break;
        }
        return hashMap;
    }

    private static String getConceptName(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        LocalizedText localizedText = new LocalizedText(list);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() != NAME) continue;
                localizedText.setText(startElement, xMLEventReader);
                continue;
            }
            if (!xMLEvent.isEndElement() || !CONCEPT.equals(xMLEvent.asEndElement().getName().getLocalPart())) continue;
            break;
        }
        return localizedText.getText();
    }
}

