/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.DoubleObservation;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class GenericDataParser
implements Parser<DataParsingResult> {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String SERIES = "Series";
    private static final String SERIES_KEY = "SeriesKey";
    private static final String VALUE = "value";
    private static final String ID = "id";
    private static final String OBS = "Obs";
    private static final String OBS_TIME = "ObsDimension";
    private static final String OBS_VALUE = "ObsValue";
    private static final String ATTRIBUTES = "Attributes";
    private static final String ATTRIBUTEVALUE = "Value";
    private DataFlowStructure dsd;
    private Dataflow dataflow;
    private boolean data;

    public GenericDataParser(DataFlowStructure dataFlowStructure, Dataflow dataflow, boolean bl) {
        this.dsd = dataFlowStructure;
        this.dataflow = dataflow;
        this.data = bl;
    }

    @Override
    public DataParsingResult parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        DataParsingResult dataParsingResult = new DataParsingResult();
        ArrayList<PortableTimeSeries<Double>> arrayList = new ArrayList<PortableTimeSeries<Double>>();
        Map<String, Map.Entry<String, String>> map = null;
        Map<String, String> map2 = null;
        ArrayList<DoubleObservation> arrayList2 = new ArrayList<DoubleObservation>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                switch (startElement.getName().getLocalPart()) {
                    case "SeriesKey": {
                        map = this.getSeriesKey(xMLEventReader, this.dsd);
                        break;
                    }
                    case "Attributes": {
                        map2 = GenericDataParser.getSeriesAttributes(xMLEventReader);
                        break;
                    }
                    case "Obs": {
                        if (!this.data) break;
                        arrayList2.add(GenericDataParser.getObservation(xMLEventReader));
                    }
                }
                continue;
            }
            if (!xMLEvent.isEndElement() || xMLEvent.asEndElement().getName().getLocalPart() != SERIES) continue;
            arrayList.add(new PortableTimeSeries(this.dataflow, map, map2, arrayList2));
        }
        dataParsingResult.setData(arrayList);
        return dataParsingResult;
    }

    private Map<String, Map.Entry<String, String>> getSeriesKey(XMLEventReader xMLEventReader, DataFlowStructure dataFlowStructure) throws XMLStreamException {
        String string = null;
        int n = dataFlowStructure.getDimensions().size();
        Map.Entry[] entryArray = new Map.Entry[n];
        String[] stringArray = new String[n];
        LinkedHashMap<String, Map.Entry<String, String>> linkedHashMap = new LinkedHashMap<String, Map.Entry<String, String>>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (!VALUE.equalsIgnoreCase(startElement.getName().getLocalPart())) continue;
                for (Attribute attribute : startElement::getAttributes) {
                    if (ID.equalsIgnoreCase(attribute.getName().toString())) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!VALUE.equalsIgnoreCase(attribute.getName().toString())) continue;
                    String string2 = attribute.getValue();
                    stringArray[dataFlowStructure.getDimensionPosition((String)string) - 1] = string;
                    entryArray[dataFlowStructure.getDimensionPosition((String)string) - 1] = new AbstractMap.SimpleEntry<String, String>(string2, "");
                }
                continue;
            }
            if (!xMLEvent.isEndElement() || !SERIES_KEY.equals(xMLEvent.asEndElement().getName().getLocalPart())) continue;
            for (int i = 0; i < n; ++i) {
                linkedHashMap.put(stringArray[i], entryArray[i]);
            }
            return linkedHashMap;
        }
        throw new XMLStreamException("EOF while reading dimensions.");
    }

    private static Map<String, String> getSeriesAttributes(XMLEventReader xMLEventReader) throws XMLStreamException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (!startElement.getName().getLocalPart().equalsIgnoreCase(VALUE)) continue;
                String string = null;
                String string2 = null;
                for (Attribute attribute : startElement::getAttributes) {
                    if (attribute.getName().toString().equalsIgnoreCase(ID)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equalsIgnoreCase(VALUE)) continue;
                    string2 = attribute.getValue();
                }
                hashMap.put(string, string2);
                continue;
            }
            if (!xMLEvent.isEndElement() || xMLEvent.asEndElement().getName().getLocalPart() != ATTRIBUTES) continue;
            return hashMap;
        }
        throw new XMLStreamException("EOF while reading attributes.");
    }

    private static DoubleObservation getObservation(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        String string = null;
        String string2 = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object2;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == OBS_TIME) {
                    for (Object object2 : startElement::getAttributes) {
                        if (!object2.getName().toString().equals(VALUE)) continue;
                        string = object2.getValue();
                    }
                    continue;
                }
                if (startElement.getName().getLocalPart() == OBS_VALUE) {
                    for (Object object2 : startElement::getAttributes) {
                        if (!object2.getName().toString().equals(VALUE)) continue;
                        string2 = object2.getValue();
                    }
                    continue;
                }
                if (startElement.getName().getLocalPart() != ATTRIBUTEVALUE) continue;
                String string3 = startElement.getAttributeByName(new QName(ID)).getValue();
                object2 = startElement.getAttributeByName(new QName(VALUE)).getValue();
                hashMap.put(string3, (String)object2);
                continue;
            }
            if (!xMLEvent.isEndElement() || xMLEvent.asEndElement().getName().getLocalPart() != OBS) continue;
            try {
                return new DoubleObservation(string, Double.valueOf(string2), hashMap);
            }
            catch (NumberFormatException numberFormatException) {
                logger.fine("Non-numeric value for observation at date " + string + ". Using NaN instead.");
                return new DoubleObservation(string, Double.NaN, hashMap);
            }
        }
        throw new XMLStreamException("EOF while reading an observation.");
    }
}

