/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Hashtable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.meta.nestedDichotomies.ClassBalancedND;
import weka.classifiers.meta.nestedDichotomies.DataNearBalancedND;
import weka.classifiers.meta.nestedDichotomies.ND;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Randomizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class END
extends RandomizableIteratedSingleClassifierEnhancer
implements TechnicalInformationHandler {
    static final long serialVersionUID = -4143242362912214956L;
    protected Hashtable m_hashtable = null;

    public END() {
        this.m_Classifier = new ND();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.meta.nestedDichotomies.ND";
    }

    public String globalInfo() {
        return "A meta classifier for handling multi-class datasets with 2-class classifiers by building an ensemble of nested dichotomies.\n\nFor more info, check\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Lin Dong and Eibe Frank and Stefan Kramer");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Ensembles of Balanced Nested Dichotomies for Multi-class Problems");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "PKDD");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "84-95");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Stefan Kramer");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Ensembles of nested dichotomies for multi-class problems");
        technicalInformation2.setValue(TechnicalInformation.Field.BOOKTITLE, "Twenty-first International Conference on Machine Learning");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2004");
        technicalInformation2.setValue(TechnicalInformation.Field.PUBLISHER, "ACM");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.setMinimumNumberInstances(1);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (!(this.m_Classifier instanceof ND || this.m_Classifier instanceof ClassBalancedND || this.m_Classifier instanceof DataNearBalancedND)) {
            throw new IllegalArgumentException("END only works with ND, ClassBalancedND or DataNearBalancedND classifier");
        }
        this.m_hashtable = new Hashtable();
        this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, this.m_NumIterations);
        Random random = instances.getRandomNumberGenerator(this.m_Seed);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            ((Randomizable)((Object)this.m_Classifiers[i])).setSeed(random.nextInt());
            if (this.m_Classifier instanceof ND) {
                ((ND)this.m_Classifiers[i]).setHashtable(this.m_hashtable);
            } else if (this.m_Classifier instanceof ClassBalancedND) {
                ((ClassBalancedND)this.m_Classifiers[i]).setHashtable(this.m_hashtable);
            } else if (this.m_Classifier instanceof DataNearBalancedND) {
                ((DataNearBalancedND)this.m_Classifiers[i]).setHashtable(this.m_hashtable);
            }
            this.m_Classifiers[i].buildClassifier(instances);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            if (instance.classAttribute().isNumeric()) {
                dArray[0] = dArray[0] + this.m_Classifiers[i].classifyInstance(instance);
                continue;
            }
            double[] dArray2 = this.m_Classifiers[i].distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        if (instance.classAttribute().isNumeric()) {
            dArray[0] = dArray[0] / (double)this.m_NumIterations;
            return dArray;
        }
        if (Utils.eq(Utils.sum(dArray), 0.0)) {
            return dArray;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "END: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("All the base classifiers: \n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        END.runClassifier(new END(), stringArray);
    }
}

