/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelGetter;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.shared.JenaException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class OntModelSpecAssembler
extends AssemblerBase
implements Assembler {
    private static final OntModelSpec DEFAULT = OntModelSpec.OWL_MEM_RDFS_INF;

    public Object open(Assembler a, Resource root, Mode irrelevant) {
        if (root.hasProperty(null, (RDFNode)null)) {
            this.checkType(root, JA.OntModelSpec);
            OntModelSpec spec = new OntModelSpec(this.getDefault(root));
            spec.setDocumentManager(this.getDocumentManager(a, root));
            spec.setReasonerFactory(this.getReasonerFactory(a, root));
            spec.setLanguage(this.getLanguage(a, root));
            spec.setImportModelGetter(this.getModelSource(a, root));
            return spec;
        }
        OntModelSpec oms = OntModelSpecAssembler.getOntModelSpecField(root.getLocalName());
        if (oms == null) {
            throw new JenaException("no such OntModelSpec: " + root);
        }
        return oms;
    }

    private OntModelSpec getDefault(Resource root) {
        if (root.getNameSpace().equals("http://jena.hpl.hp.com/2005/11/Assembler#")) {
            OntModelSpec oms = OntModelSpecAssembler.getOntModelSpecField(root.getLocalName());
            return oms == null ? DEFAULT : oms;
        }
        return DEFAULT;
    }

    private ModelGetter getModelSource(Assembler a, Resource root) {
        Resource source = OntModelSpecAssembler.getUniqueResource(root, JA.importSource);
        return source == null ? DEFAULT.getImportModelGetter() : (ModelGetter)a.open(source);
    }

    private String getLanguage(Assembler a, Resource root) {
        Resource lang = OntModelSpecAssembler.getUniqueResource(root, JA.ontLanguage);
        return lang == null ? DEFAULT.getLanguage() : lang.getURI();
    }

    private ReasonerFactory getReasonerFactory(Assembler a, Resource root) {
        Resource rf = OntModelSpecAssembler.getUniqueResource(root, JA.reasonerURL);
        return rf == null ? DEFAULT.getReasonerFactory() : (ReasonerFactory)a.open(rf);
    }

    private OntDocumentManager getDocumentManager(Assembler a, Resource root) {
        Resource dm = OntModelSpecAssembler.getUniqueResource(root, JA.documentManager);
        return dm == null ? OntDocumentManager.getInstance() : (OntDocumentManager)a.open(dm);
    }

    public static OntModelSpec getOntModelSpecField(String name) {
        try {
            Class omc = OntModelSpec.class;
            Field f = omc.getField(name);
            int mods = f.getModifiers();
            if (f.getType() == omc && OntModelSpecAssembler.isConstant(mods)) {
                return (OntModelSpec)f.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected static boolean isConstant(int mods) {
        return Modifier.isPublic(mods) && Modifier.isFinal(mods) && Modifier.isStatic(mods);
    }
}

