/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.ClassifierADLinear;

import java.io.FileNotFoundException;
import java.io.IOException;
import keel.Algorithms.Shared.Parsing.ProcessConfig;
import keel.Algorithms.Shared.Parsing.ProcessDataset;
import keel.Algorithms.Statistical_Classifiers.Shared.DiscrAnalysis.AD;
import org.core.Randomize;

public class ClassifierADLinear {
    static Randomize rand;

    private static void lda(boolean tty, ProcessConfig pc) {
        try {
            int i;
            ProcessDataset pd = new ProcessDataset();
            String line = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processClassifierDataset(line, true);
            } else {
                pd.oldClusteringProcess(line);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            double[][] X = pd.getX();
            int[] C = pd.getC();
            int[] Ct = new int[C.length];
            int nClasses = pd.getNclasses();
            pd.showDatasetStatistics();
            double[] maxInput = pd.getImaximum();
            double[] minInput = pd.getIminimum();
            int[] nInputFolds = new int[nInputs];
            double[][] Cbin = new double[nData][nClasses];
            for (i = 0; i < nData; ++i) {
                Cbin[i][C[i]] = 1.0;
            }
            for (i = 0; i < X.length; ++i) {
                Ct[i] = -1;
            }
            AD adlin = new AD(X, Cbin);
            double faults = 0.0;
            try {
                boolean lineal = true;
                adlin.computeParameter(lineal);
                for (int i2 = 0; i2 < X.length; ++i2) {
                    double[] resp = adlin.distances(X[i2]);
                    int theClass = AD.argmax(resp);
                    if (theClass != C[i2]) {
                        faults += 1.0;
                    }
                    Ct[i2] = theClass;
                }
                System.out.println("Train error=" + (faults /= (double)nData));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            pc.trainingResults(C, Ct);
            ProcessDataset pdt = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(2);
            if (ProcessConfig.parNewFormat) {
                pdt.processClassifierDataset(line, false);
            } else {
                pdt.oldClusteringProcess(line);
            }
            int nTest = pdt.getNdata();
            int npVariables = pdt.getNvariables();
            int npInputs = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (npInputs != nInputs) {
                throw new IOException("IOERR test file");
            }
            double[][] Xp = pdt.getX();
            int[] Cp = pdt.getC();
            int[] Co = new int[Cp.length];
            try {
                faults = 0.0;
                for (int i3 = 0; i3 < Xp.length; ++i3) {
                    double[] resp = adlin.distances(Xp[i3]);
                    int aClass = AD.argmax(resp);
                    if (aClass != Cp[i3]) {
                        faults += 1.0;
                    }
                    Co[i3] = aClass;
                }
                System.out.println("test error=" + (faults /= (double)Xp.length));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            pc.results(Cp, Co);
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Train file not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read Error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algo = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        ClassifierADLinear a = new ClassifierADLinear();
        ClassifierADLinear.lda(tty, pc);
    }
}

