/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm.niching;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.algorithm.classic.SG;
import net.sourceforge.jclec.selector.BettersSelector;
import net.sourceforge.jclec.selector.WorsesSelector;

public abstract class SpatialNiching
extends SG {
    protected List<IIndividual> nset = new ArrayList<IIndividual>();
    protected BettersSelector bettersSelector = new BettersSelector(this);
    protected WorsesSelector worsesSelector = new WorsesSelector(this);

    @Override
    protected void doSelection() {
        this.nset.clear();
        this.createNiches();
        this.pset = this.parentsSelector.select(this.nset, this.bset.size());
    }

    @Override
    protected void doGeneration() {
        for (IIndividual ind : this.pset) {
            ind.setFitness(null);
        }
        super.doGeneration();
    }

    @Override
    protected void doUpdate() {
        if (this.cset.size() < this.bset.size()) {
            this.cset.addAll(this.bettersSelector.select(this.bset, this.bset.size() - this.cset.size()));
        } else {
            IIndividual bestInC;
            IIndividual bestInB = this.bettersSelector.select(this.bset, 1).get(0);
            if (this.compareIndividuals(bestInB, bestInC = this.bettersSelector.select(this.cset, 1).get(0)) == 1) {
                IIndividual worstInC = this.worsesSelector.select(this.cset, 1).get(0);
                this.cset.remove(worstInC);
                this.cset.add(bestInB);
            }
        }
        this.bset = this.cset;
        this.cset = null;
        this.rset = null;
        this.pset = null;
    }

    protected abstract void createNiches();

    private final int compareIndividuals(IIndividual one, IIndividual two) {
        return this.evaluator.getComparator().compare(one.getFitness(), two.getFitness());
    }
}

