/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import keel.Algorithms.Decision_Trees.M5.M5Attribute;
import keel.Algorithms.Decision_Trees.M5.M5Instance;
import keel.Algorithms.Decision_Trees.M5.M5Instances;
import keel.Algorithms.Decision_Trees.M5.M5SparseInstance;
import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;
import keel.Algorithms.Decision_Trees.M5.Queue;

public class ReplaceMissingValuesFilter {
    private double[] m_ModesAndMeans = null;
    private boolean m_Debug = false;
    private M5Instances m_OutputFormat = null;
    private Queue m_OutputQueue = null;
    private int[] m_OutputStringAtts = null;
    private int[] m_InputStringAtts = null;
    private M5Instances m_InputFormat = null;
    protected boolean m_NewBatch = true;

    public boolean setInputFormat(M5Instances instanceInfo) throws Exception {
        this.superSetInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_ModesAndMeans = null;
        return true;
    }

    protected int[] getStringIndices(M5Instances insts) {
        int[] index = new int[insts.numAttributes()];
        int indexSize = 0;
        for (int i = 0; i < insts.numAttributes(); ++i) {
            if (insts.attribute(i).type() != 2) continue;
            index[indexSize++] = i;
        }
        int[] result = new int[indexSize];
        System.arraycopy(index, 0, result, 0, indexSize);
        return result;
    }

    protected void setOutputFormat(M5Instances outputFormat) {
        if (outputFormat != null) {
            this.m_OutputFormat = outputFormat.stringFreeStructure();
            this.m_OutputStringAtts = this.getStringIndices(this.m_OutputFormat);
            String relationName = outputFormat.relationName() + "-" + this.getClass().getName();
            this.m_OutputFormat.setRelationName(relationName);
        } else {
            this.m_OutputFormat = null;
        }
        this.m_OutputQueue = new Queue();
    }

    public boolean superSetInputFormat(M5Instances instanceInfo) throws Exception {
        this.m_InputFormat = instanceInfo.stringFreeStructure();
        this.m_InputStringAtts = this.getStringIndices(instanceInfo);
        this.m_OutputFormat = null;
        this.m_OutputQueue = new Queue();
        this.m_NewBatch = true;
        return false;
    }

    protected M5Instances getInputFormat() {
        return this.m_InputFormat;
    }

    public boolean input(M5Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_ModesAndMeans == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    protected void resetQueue() {
        this.m_OutputQueue = new Queue();
    }

    protected void bufferInput(M5Instance instance) {
        if (instance != null) {
            this.copyStringValues(instance, this.m_InputFormat, this.m_InputStringAtts);
            instance.setDataset(this.m_InputFormat);
            this.m_InputFormat.add(instance);
        }
    }

    private void copyStringValues(M5Instance inst, M5Instances destDataset, int[] strAtts) {
        if (strAtts.length == 0) {
            return;
        }
        if (inst.dataset() == null) {
            throw new IllegalArgumentException("Instance has no dataset assigned!!");
        }
        if (inst.dataset().numAttributes() != destDataset.numAttributes()) {
            throw new IllegalArgumentException("Src and Dest differ in # of attributes!!");
        }
        this.copyStringValues(inst, true, inst.dataset(), strAtts, destDataset, strAtts);
    }

    protected void copyStringValues(M5Instance instance, boolean instSrcCompat, M5Instances srcDataset, M5Instances destDataset) {
        this.copyStringValues(instance, instSrcCompat, srcDataset, this.m_InputStringAtts, destDataset, this.m_OutputStringAtts);
    }

    protected void copyStringValues(M5Instance instance, boolean instSrcCompat, M5Instances srcDataset, int[] srcStrAtts, M5Instances destDataset, int[] destStrAtts) {
        if (srcDataset == destDataset) {
            return;
        }
        if (srcStrAtts.length != destStrAtts.length) {
            throw new IllegalArgumentException("Src and Dest string indices differ in length!!");
        }
        for (int i = 0; i < srcStrAtts.length; ++i) {
            int instIndex = instSrcCompat ? srcStrAtts[i] : destStrAtts[i];
            M5Attribute src = srcDataset.attribute(srcStrAtts[i]);
            M5Attribute dest = destDataset.attribute(destStrAtts[i]);
            if (instance.isMissing(instIndex)) continue;
            int valIndex = dest.addStringValue(src, (int)instance.value(instIndex));
            instance.setValue(instIndex, (double)valIndex);
        }
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_ModesAndMeans == null) {
            int i;
            double sumOfWeights = this.getInputFormat().sumOfWeights();
            double[][] counts = new double[this.getInputFormat().numAttributes()][];
            for (int i2 = 0; i2 < this.getInputFormat().numAttributes(); ++i2) {
                if (!this.getInputFormat().attribute(i2).isNominal()) continue;
                counts[i2] = new double[this.getInputFormat().attribute(i2).numValues()];
                counts[i2][0] = sumOfWeights;
            }
            double[] sums = new double[this.getInputFormat().numAttributes()];
            for (int i3 = 0; i3 < sums.length; ++i3) {
                sums[i3] = sumOfWeights;
            }
            double[] results = new double[this.getInputFormat().numAttributes()];
            for (int j = 0; j < this.getInputFormat().numInstances(); ++j) {
                M5Instance inst = this.getInputFormat().instance(j);
                for (int i4 = 0; i4 < inst.numValues(); ++i4) {
                    if (!inst.isMissingSparse(i4)) {
                        double value = inst.valueSparse(i4);
                        if (inst.attributeSparse(i4).isNominal()) {
                            double[] dArray = counts[inst.index(i4)];
                            int n = (int)value;
                            dArray[n] = dArray[n] + inst.weight();
                            double[] dArray2 = counts[inst.index(i4)];
                            dArray2[0] = dArray2[0] - inst.weight();
                            continue;
                        }
                        if (!inst.attributeSparse(i4).isNumeric()) continue;
                        int n = inst.index(i4);
                        results[n] = results[n] + inst.weight() * inst.valueSparse(i4);
                        continue;
                    }
                    if (inst.attributeSparse(i4).isNominal()) {
                        double[] dArray = counts[inst.index(i4)];
                        dArray[0] = dArray[0] - inst.weight();
                        continue;
                    }
                    if (!inst.attributeSparse(i4).isNumeric()) continue;
                    int n = inst.index(i4);
                    sums[n] = sums[n] - inst.weight();
                }
            }
            this.m_ModesAndMeans = new double[this.getInputFormat().numAttributes()];
            for (i = 0; i < this.getInputFormat().numAttributes(); ++i) {
                if (this.getInputFormat().attribute(i).isNominal()) {
                    this.m_ModesAndMeans[i] = M5StaticUtils.maxIndex(counts[i]);
                    continue;
                }
                if (!this.getInputFormat().attribute(i).isNumeric() || !M5StaticUtils.gr(sums[i], 0.0)) continue;
                this.m_ModesAndMeans[i] = results[i] / sums[i];
            }
            for (i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.convertInstance(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    protected void flushInput() {
        if (this.m_InputStringAtts.length > 0) {
            this.m_InputFormat = this.m_InputFormat.stringFreeStructure();
        } else {
            this.m_InputFormat.delete();
        }
    }

    public int numPendingOutput() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        return this.m_OutputQueue.size();
    }

    private void convertInstance(M5Instance instance) throws Exception {
        M5Instance inst = null;
        if (instance instanceof M5SparseInstance) {
            double[] vals = new double[instance.numValues()];
            int[] indices = new int[instance.numValues()];
            int num = 0;
            for (int j = 0; j < instance.numValues(); ++j) {
                if (instance.isMissingSparse(j) && (instance.attributeSparse(j).isNominal() || instance.attributeSparse(j).isNumeric())) {
                    if (this.m_ModesAndMeans[instance.index(j)] == 0.0) continue;
                    vals[num] = this.m_ModesAndMeans[instance.index(j)];
                    indices[num] = instance.index(j);
                    ++num;
                    continue;
                }
                vals[num] = instance.valueSparse(j);
                indices[num] = instance.index(j);
                ++num;
            }
            if (num == instance.numValues()) {
                inst = new M5SparseInstance(instance.weight(), vals, indices, instance.numAttributes());
            } else {
                double[] tempVals = new double[num];
                int[] tempInd = new int[num];
                System.arraycopy(vals, 0, tempVals, 0, num);
                System.arraycopy(indices, 0, tempInd, 0, num);
                inst = new M5SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
            }
        } else {
            double[] vals = new double[this.getInputFormat().numAttributes()];
            for (int j = 0; j < instance.numAttributes(); ++j) {
                vals[j] = instance.isMissing(j) && (this.getInputFormat().attribute(j).isNominal() || this.getInputFormat().attribute(j).isNumeric()) ? this.m_ModesAndMeans[j] : instance.value(j);
            }
            inst = new M5Instance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst);
    }

    protected void push(M5Instance instance) {
        if (instance != null) {
            this.copyStringValues(instance, this.m_OutputFormat, this.m_OutputStringAtts);
            instance.setDataset(this.m_OutputFormat);
            this.m_OutputQueue.push(instance);
        }
    }

    public static M5Instances useFilter(M5Instances data, ReplaceMissingValuesFilter filter) throws Exception {
        M5Instance processed;
        for (int i = 0; i < data.numInstances(); ++i) {
            filter.input(data.instance(i));
        }
        filter.batchFinished();
        M5Instances newData = filter.getOutputFormat();
        while ((processed = filter.output()) != null) {
            newData.add(processed);
        }
        return newData;
    }

    public final M5Instances getOutputFormat() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output format defined.");
        }
        return new M5Instances(this.m_OutputFormat, 0);
    }

    public M5Instance output() {
        if (this.m_OutputFormat == null) {
            throw new NullPointerException("No output instance format defined");
        }
        if (this.m_OutputQueue.empty()) {
            return null;
        }
        M5Instance result = (M5Instance)this.m_OutputQueue.pop();
        if (this.m_OutputQueue.empty() && this.m_NewBatch && this.m_OutputStringAtts.length > 0) {
            this.m_OutputFormat = this.m_OutputFormat.stringFreeStructure();
        }
        return result;
    }
}

