/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms.GeneticAlgorithm;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividual;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidFitness;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import keel.Algorithms.Shared.Exceptions.invalidOptim;
import org.core.Randomize;

public class GeneticAlgorithmGenerational
extends GeneticAlgorithm {
    GeneticIndividual[][] population;
    GeneticIndividual[][] intermediatePopulation;
    GeneticIndividual[] elite;
    double[][] fitnessCache;
    double[][] fitnessMark;
    double CROSSOVERPROB;
    double MUTATIONPROB;
    double MUTATIONAMPL;
    double MIGRATIONPROB;
    double LOCALOPTPROB;
    int LOCALOPTITER;
    double[] fitnessMean;
    double[] bestFitness;
    static Randomize rand;
    int CROSSOVERID;
    int MUTATIONID;
    int LOID;

    public GeneticAlgorithmGenerational(GeneticIndividual initialIndividual, int pPopSize, int nGenerations, double PM, double AMP, double PMIG, double pLOptProb, int NOL, int IOL, Randomize r, int pCrossoverID, int pMutationID) {
        rand = r;
        this.population = new GeneticIndividual[nGenerations][pPopSize];
        this.intermediatePopulation = new GeneticIndividual[nGenerations][pPopSize];
        this.fitnessCache = new double[nGenerations][pPopSize];
        this.fitnessMark = new double[nGenerations][pPopSize];
        this.fitnessMean = new double[nGenerations];
        this.bestFitness = new double[nGenerations];
        this.elite = new GeneticIndividual[nGenerations];
        this.MUTATIONPROB = PM;
        this.MUTATIONAMPL = AMP;
        this.MIGRATIONPROB = PMIG;
        this.CROSSOVERID = pCrossoverID;
        this.MUTATIONID = pMutationID;
        this.LOCALOPTPROB = pLOptProb;
        this.LOCALOPTITER = NOL;
        this.LOID = IOL;
        try {
            for (int p = 0; p < nGenerations; ++p) {
                this.elite[p] = initialIndividual.clone();
                for (int i = 0; i < pPopSize; ++i) {
                    System.out.println("Inicialiting the population[" + i + "]");
                    this.population[p][i] = initialIndividual.clone();
                    this.intermediatePopulation[p][i] = initialIndividual.clone();
                    this.population[p][i].Random();
                    this.fitnessCache[p][i] = this.population[p][i].fitness();
                    int n = p;
                    this.fitnessMean[n] = this.fitnessMean[n] + this.fitnessCache[p][i];
                    if (!(this.fitnessCache[p][i] < this.bestFitness[p]) && i != 0) continue;
                    this.bestFitness[p] = this.fitnessCache[p][i];
                }
            }
        }
        catch (invalidFitness e) {
            System.out.println("Unsupported fitness function");
        }
    }

    @Override
    public GeneticIndividual evolve(int MAXITER) throws invalidCrossover, invalidMutation, invalidOptim {
        int p;
        System.out.println("Calculating " + MAXITER + " generations");
        int nGenerations = this.population.length;
        int pPopSize = this.population[0].length;
        int[] lBestIndividual = new int[nGenerations];
        double[] fitnesselite = new double[nGenerations];
        double[] bestFitness = new double[nGenerations];
        double[] lTheWorstFitness = new double[nGenerations];
        for (int i = 0; i < MAXITER; ++i) {
            int j;
            System.out.println("Generation=" + i);
            for (p = 0; p < nGenerations; ++p) {
                bestFitness[p] = this.fitnessCache[p][0];
                lTheWorstFitness[p] = this.fitnessCache[p][0];
                for (j = 1; j < pPopSize; ++j) {
                    if (this.fitnessCache[p][j] < bestFitness[p]) {
                        bestFitness[p] = this.fitnessCache[p][j];
                    }
                    if (!(this.fitnessCache[p][j] > lTheWorstFitness[p])) continue;
                    lTheWorstFitness[p] = this.fitnessCache[p][j];
                }
                for (j = 0; j < pPopSize; ++j) {
                    this.fitnessMark[p][j] = 1.0 - (this.fitnessCache[p][j] - bestFitness[p]) / (lTheWorstFitness[p] - bestFitness[p]);
                }
                for (j = 1; j < pPopSize; ++j) {
                    double[] dArray = this.fitnessMark[p];
                    int n = j;
                    dArray[n] = dArray[n] + this.fitnessMark[p][j - 1];
                }
            }
            for (p = 0; p < nGenerations; ++p) {
                for (j = 0; j < pPopSize; ++j) {
                    int origen = p;
                    if (rand.Rand() < this.MIGRATIONPROB) {
                        origen = (int)(rand.Rand() * (double)this.population.length);
                    }
                    double fit = rand.Rand() * this.fitnessMark[origen][pPopSize - 1];
                    int k = 0;
                    while (this.fitnessMark[origen][k] < fit) {
                        ++k;
                    }
                    this.intermediatePopulation[p][j] = this.population[origen][k].clone();
                }
                for (j = 0; j < pPopSize; j += 2) {
                    this.intermediatePopulation[p][j].crossover(this.intermediatePopulation[p][j + 1], this.population[p][j], this.population[p][j + 1], this.CROSSOVERID);
                    if (rand.Rand() < this.MUTATIONPROB) {
                        this.population[p][j].mutation(this.MUTATIONAMPL, this.MUTATIONID);
                    }
                    if (rand.Rand() < this.MUTATIONPROB) {
                        this.population[p][j + 1].mutation(this.MUTATIONAMPL, this.MUTATIONID);
                    }
                    if (rand.Rand() < this.LOCALOPTPROB) {
                        this.population[p][j].localOptimization(this.LOCALOPTITER, this.LOID);
                    }
                    if (!(rand.Rand() < this.LOCALOPTPROB)) continue;
                    this.population[p][j + 1].localOptimization(this.LOCALOPTITER, this.LOID);
                }
                try {
                    this.fitnessMean[p] = 0.0;
                    bestFitness[p] = 0.0;
                    lBestIndividual[p] = 0;
                    for (j = 0; j < pPopSize; ++j) {
                        this.fitnessCache[p][j] = this.population[p][j].fitness();
                        int n = p;
                        this.fitnessMean[n] = this.fitnessMean[n] + this.fitnessCache[p][j];
                        if (!(this.fitnessCache[p][j] < bestFitness[p]) && j != 0) continue;
                        bestFitness[p] = this.fitnessCache[p][j];
                        lBestIndividual[p] = j;
                    }
                    int n = p;
                    this.fitnessMean[n] = this.fitnessMean[n] / (double)pPopSize;
                }
                catch (invalidFitness e) {
                    System.out.println("Unsupported fitness function");
                    return this.population[0][0].clone();
                }
                if (i == 0 || bestFitness[p] < fitnesselite[p]) {
                    this.elite[p] = this.population[p][lBestIndividual[p]].clone();
                    fitnesselite[p] = bestFitness[p];
                }
                System.out.println("The best fitness in the Elite pop=" + fitnesselite[p] + " the best fitness in the pop=" + bestFitness[p] + " the mean fitness value=" + this.fitnessMean[p]);
            }
        }
        int theBestInElite = 0;
        for (p = 1; p < nGenerations; ++p) {
            if (!(fitnesselite[p] < fitnesselite[theBestInElite])) continue;
            theBestInElite = p;
        }
        return this.elite[theBestInElite].clone();
    }
}

