/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.PDFCS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.PDFCS.FuzzyRuleSet;
import keel.Algorithms.SVM.SMO.SMO;
import keel.Algorithms.SVM.SMO.core.Instances;
import keel.Algorithms.SVM.SMO.supportVector.Kernel;
import keel.Algorithms.SVM.SMO.supportVector.PDRFKernel;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Files;
import org.core.Randomize;

public class PDFC
extends SMO {
    protected SMO.BinarySMO[] m_classifiers = null;
    protected FuzzyRuleSet[] m_ruleSet = null;
    protected double m_d = 1.0;

    public PDFC(String fileParam) {
        this.config_read(fileParam);
        Randomize.setSeed(this.m_seed);
    }

    public PDFC() {
    }

    @Override
    public void buildClassifier(Instances insts) throws Exception {
        keel.Algorithms.SVM.SMO.core.Instance inst;
        int i;
        this.m_classIndex = insts.classIndex();
        this.m_classAttribute = insts.classAttribute();
        this.m_KernelIsLinear = false;
        this.m_NumClasses = insts.numClasses();
        Instances[] subsets = new Instances[insts.numClasses()];
        for (i = 0; i < insts.numClasses(); ++i) {
            subsets[i] = new Instances(insts, insts.numInstances());
        }
        for (int j = 0; j < insts.numInstances(); ++j) {
            inst = insts.instance(j);
            subsets[(int)inst.classValue()].add(inst);
        }
        for (i = 0; i < insts.numClasses(); ++i) {
            subsets[i].compactify();
        }
        if (this.m_NumClasses == 2) {
            this.m_classifiers = new SMO.BinarySMO[1];
            this.m_ruleSet = new FuzzyRuleSet[1];
        } else {
            this.m_classifiers = new SMO.BinarySMO[insts.numClasses()];
            this.m_ruleSet = new FuzzyRuleSet[insts.numClasses()];
        }
        for (i = 0; i < this.m_classifiers.length; ++i) {
            this.m_classifiers[i] = new SMO.BinarySMO(this);
            this.m_classifiers[i].setKernel(Kernel.makeCopy(this.getKernel()));
            Instances data = new Instances(insts, insts.numInstances());
            for (int k = 0; k < subsets[i].numInstances(); ++k) {
                inst = new keel.Algorithms.SVM.SMO.core.Instance(subsets[i].instance(k));
                inst.setDataset(insts);
                inst.setClassValue(0.0);
                data.add(inst);
            }
            for (int j = 0; j < insts.numClasses(); ++j) {
                if (j == i) continue;
                for (int k = 0; k < subsets[j].numInstances(); ++k) {
                    inst = new keel.Algorithms.SVM.SMO.core.Instance(subsets[j].instance(k));
                    inst.setDataset(insts);
                    inst.setClassValue(1.0);
                    data.add(inst);
                }
            }
            data.compactify();
            data.randomize();
            this.m_classifiers[i].buildClassifier(data, 1, 0, this.m_fitLogisticModels, this.m_numFolds, this.m_randomSeed);
            this.m_ruleSet[i] = new FuzzyRuleSet(this.m_classifiers[i], data, this.m_kernel);
        }
    }

    @Override
    public double[] distributionForInstance(keel.Algorithms.SVM.SMO.core.Instance inst) throws Exception {
        double[] result = new double[inst.numClasses()];
        if (inst.numClasses() == 2) {
            double output = this.m_ruleSet[0].unthresholdedOutput(inst);
            if (Math.signum(output) < 0.0) {
                result[1] = result[1] + 1.0;
            } else {
                result[0] = result[0] + 1.0;
            }
        } else {
            double output;
            double max = output = this.m_ruleSet[0].unthresholdedOutput(inst);
            int index = 0;
            for (int j = 1; j < inst.numClasses(); ++j) {
                output = this.m_ruleSet[j].unthresholdedOutput(inst);
                if (!(output > max)) continue;
                max = output;
                index = j;
            }
            int n = index;
            result[n] = result[n] + 1.0;
        }
        return result;
    }

    @Override
    public void runModel() {
        int j;
        int claseObt;
        double[] dist;
        keel.Algorithms.SVM.SMO.core.Instance instWeka;
        Instance inst;
        int i;
        String[] instanciasOUT;
        String[] instanciasIN;
        int tipo;
        Attribute a;
        Instances isWeka;
        InstanceSet IS = new InstanceSet();
        InstanceSet ISval = new InstanceSet();
        try {
            IS.readSet(this.input_train_name, true);
            if (this.m_filterType == 1) {
                this.computeStats(IS);
            }
            isWeka = this.InstancesKEEL2Weka(IS, this.m_filterType, this.m_nominalToBinary);
            this.buildClassifier(isWeka);
            ISval.readSet(this.input_validation_name, false);
            isWeka = this.InstancesKEEL2Weka(ISval, this.m_filterType, this.m_nominalToBinary);
            a = Attributes.getOutputAttribute(0);
            tipo = a.getType();
            instanciasIN = new String[ISval.getNumInstances()];
            instanciasOUT = new String[ISval.getNumInstances()];
            for (i = 0; i < isWeka.numInstances(); ++i) {
                inst = ISval.getInstance(i);
                instWeka = isWeka.instance(i);
                instWeka.setDataset(isWeka);
                dist = this.distributionForInstance(instWeka);
                claseObt = 0;
                for (j = 1; j < this.m_NumClasses; ++j) {
                    if (!(dist[j] > dist[claseObt])) continue;
                    claseObt = j;
                }
                if (tipo != 0) {
                    instanciasIN[i] = new String(String.valueOf(inst.getOutputRealValues(0)));
                    instanciasOUT[i] = new String(String.valueOf(claseObt));
                    continue;
                }
                instanciasIN[i] = new String(inst.getOutputNominalValues(0));
                instanciasOUT[i] = new String(a.getNominalValue(claseObt));
            }
            PDFC.writeOutput(this.output_train_name, instanciasIN, instanciasOUT, Attributes.getInputAttributes(), Attributes.getOutputAttribute(0), Attributes.getInputNumAttributes(), "relation");
        }
        catch (Exception ex) {
            System.err.println("Fatal Error building the PDFC model!");
            ex.printStackTrace();
        }
        try {
            IS.readSet(this.input_test_name, false);
            isWeka = this.InstancesKEEL2Weka(IS, this.m_filterType, this.m_nominalToBinary);
            a = Attributes.getOutputAttribute(0);
            tipo = a.getType();
            instanciasIN = new String[IS.getNumInstances()];
            instanciasOUT = new String[IS.getNumInstances()];
            for (i = 0; i < isWeka.numInstances(); ++i) {
                inst = IS.getInstance(i);
                instWeka = isWeka.instance(i);
                instWeka.setDataset(isWeka);
                dist = this.distributionForInstance(instWeka);
                claseObt = 0;
                for (j = 1; j < this.m_NumClasses; ++j) {
                    if (!(dist[j] > dist[claseObt])) continue;
                    claseObt = j;
                }
                if (tipo != 0) {
                    instanciasIN[i] = new String(String.valueOf(inst.getOutputRealValues(0)));
                    instanciasOUT[i] = new String(String.valueOf(claseObt));
                    continue;
                }
                instanciasIN[i] = new String(inst.getOutputNominalValues(0));
                instanciasOUT[i] = new String(a.getNominalValue(claseObt));
            }
            PDFC.writeOutput(this.output_test_name, instanciasIN, instanciasOUT, Attributes.getInputAttributes(), Attributes.getOutputAttribute(0), Attributes.getInputNumAttributes(), "relation");
        }
        catch (Exception ex) {
            System.err.println("Fatal Error performing test by the PDFC model!");
            ex.printStackTrace();
        }
        this.printRuleBase();
    }

    protected void printRuleBase() {
        int ruleNumber = 0;
        for (int i = 0; i < this.m_ruleSet.length; ++i) {
            ruleNumber += this.m_ruleSet[i].getNumRules();
        }
        Files.writeFile(this.method_output, "Number of rules: " + ruleNumber + "\n");
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_validation_name = new String(out[1].substring(0, out[1].length() - 1));
            this.input_test_name = new String(out[2].substring(0, out[2].length() - 1));
            if (this.input_validation_name.charAt(this.input_validation_name.length() - 1) == '\"') {
                this.input_validation_name = this.input_validation_name.substring(0, this.input_validation_name.length() - 1);
            }
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            this.method_output = new String(out[2].substring(0, out[2].length() - 1));
            if (this.method_output.charAt(this.method_output.length() - 1) == '\"') {
                this.method_output = this.method_output.substring(0, this.method_output.length() - 1);
            }
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("seed = ");
            this.m_seed = new Integer(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("C = ");
            this.m_C = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("d = ");
            this.m_d = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("toleranceParameter = ");
            this.m_tol = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("epsilon = ");
            this.m_eps = new Double(out[1]);
            this.m_kernel = new PDRFKernel();
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("PDRFtype = ");
            String pdrfType = new String(out[1]);
            if (pdrfType.compareTo("SymmetricTriangle") == 0) {
                ((PDRFKernel)this.m_kernel).setPDRFType(PDRFKernel.SymmetricTriangle);
            } else if (pdrfType.compareTo("Gaussian") == 0) {
                ((PDRFKernel)this.m_kernel).setPDRFType(PDRFKernel.Gaussian);
            } else if (pdrfType.compareTo("Cauchy") == 0) {
                ((PDRFKernel)this.m_kernel).setPDRFType(PDRFKernel.Cauchy);
            } else if (pdrfType.compareTo("Laplace") == 0) {
                ((PDRFKernel)this.m_kernel).setPDRFType(PDRFKernel.Laplace);
            } else if (pdrfType.compareTo("HyperbolicSecant") == 0) {
                ((PDRFKernel)this.m_kernel).setPDRFType(PDRFKernel.HyperbolicSecant);
            } else {
                ((PDRFKernel)this.m_kernel).setPDRFType(PDRFKernel.SquaredSinc);
            }
            ((PDRFKernel)this.m_kernel).setD(this.m_d);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("ConvertNominalAttributesToBinary = ");
            boolean bl = this.m_nominalToBinary = new String(out[1]).compareTo("True") == 0;
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("PreprocessType = ");
            String preprocess = new String(out[1]);
            this.m_filterType = preprocess.compareTo("Normalize") == 0 ? 0 : (preprocess.compareTo("Standardize") == 0 ? 1 : 2);
        }
        catch (IOException e) {
            System.out.println("Parameter reading exception: " + e);
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

