/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Lazy_Learning.NM;

import keel.Algorithms.Lazy_Learning.LazyAlgorithm;

public class NM
extends LazyAlgorithm {
    double[][] means;
    private int[] meanClass;

    public NM(String script) {
        this.readDataFiles(script);
        this.name = "Nearest Mean";
        this.means = new double[this.nClasses][this.inputAtt];
        this.meanClass = new int[this.nClasses];
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
    }

    @Override
    protected int evaluate(double[] example) {
        double min = Double.MAX_VALUE;
        int output = -1;
        for (int i = 0; i < this.means.length; ++i) {
            double aux = this.euclideanDistance(example, this.means[i]);
            if (!(aux < min)) continue;
            min = aux;
            output = i;
        }
        output = this.meanClass[output];
        return output;
    }

    public void calculateMeans() {
        int j;
        int i;
        for (i = 0; i < this.nClasses; ++i) {
            for (j = 0; j < this.inputAtt; ++j) {
                this.means[i][j] = 0.0;
            }
            this.meanClass[i] = i;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            int isClass = this.trainOutput[i];
            for (j = 0; j < this.inputAtt; ++j) {
                double[] dArray = this.means[isClass];
                int n = j;
                dArray[n] = dArray[n] + this.trainData[i][j];
            }
        }
        for (i = 0; i < this.nClasses; ++i) {
            for (j = 0; j < this.inputAtt; ++j) {
                if (this.nInstances[i] <= 0) continue;
                double[] dArray = this.means[i];
                int n = j;
                dArray[n] = dArray[n] / (double)this.nInstances[i];
            }
        }
    }
}

