/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Discretizers.Id3_Discretizer;

import keel.Algorithms.Discretizers.Basic.ParserParameters;
import keel.Algorithms.Discretizers.Id3_Discretizer.Id3Discretizer;
import keel.Algorithms.Genetic_Rule_Learning.Globals.LogManager;
import keel.Algorithms.Genetic_Rule_Learning.Globals.Parameters;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceSet;

public class Main {
    public static void main(String[] args) {
        ParserParameters.doParse(args[0]);
        LogManager.initLogManager();
        InstanceSet is = new InstanceSet();
        try {
            is.readSet(Parameters.trainInputFile, true);
        }
        catch (Exception e) {
            LogManager.printErr(e.toString());
            System.exit(1);
        }
        Main.checkDataset();
        String name = Parameters.algorithmName;
        Id3Discretizer dis = new Id3Discretizer();
        dis.buildCutPoints(is);
        dis.applyDiscretization(Parameters.trainInputFile, Parameters.trainOutputFile);
        dis.applyDiscretization(Parameters.testInputFile, Parameters.testOutputFile);
        LogManager.closeLog();
    }

    static void checkDataset() {
        Attribute[] outputs = Attributes.getOutputAttributes();
        if (outputs.length != 1) {
            LogManager.printErr("Only datasets with one output are supported");
            System.exit(1);
        }
        if (outputs[0].getType() != 0) {
            LogManager.printErr("Output attribute should be nominal");
            System.exit(1);
        }
        Parameters.numClasses = outputs[0].getNumNominalValues();
        Parameters.numAttributes = Attributes.getInputAttributes().length;
    }
}

