/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.utilities;

public class Pair<F, S> {
    protected F first;
    protected S second;

    public Pair(F f, S s) {
        this.first = f;
        this.second = s;
    }

    public F first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public String toString() {
        return "(" + this.first.toString() + ", " + this.second.toString() + ")";
    }

    public void set(F f, S s) {
        this.first = f;
        this.second = s;
    }

    public Pair<S, F> invert() {
        return new Pair<S, F>(this.second, this.first);
    }

    public boolean equals(Pair<S, F> other) {
        return this.first.equals(other.first) && this.second.equals(other.second);
    }

    public boolean contains(Pair<S, F> other) {
        boolean straight = this.first == other.first && this.second == other.second;
        boolean inverted = this.first == other.second && this.second == other.first;
        return straight || inverted;
    }

    public boolean containsSomeElementOf(Pair<S, F> other) {
        boolean isFirst = this.first == other.first || this.first == other.second;
        boolean isSecond = this.second == other.first || this.second == other.second;
        return isFirst || isSecond;
    }
}

