/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec;

import java.io.File;
import net.sf.jclec.AlgorithmRunner;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

public class RunExperiment {
    private static final String USAGE_MES = "\tnet.sf.jclec.RunExperiment <experiment file>\t\t(Execute experiment)";

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage:");
            RunExperiment.showUsageMessage();
            System.exit(1);
        } else {
            System.out.println("Initializing job...");
            RunExperiment.executeJob(args[0]);
        }
    }

    private static void showUsageMessage() {
        System.out.println(USAGE_MES);
    }

    private static void executeJob(String jobFilename) {
        File jobFile = new File(jobFilename);
        if (jobFile.exists()) {
            try {
                XMLConfiguration jobConf = new XMLConfiguration(jobFile);
                int numberOfProcesses = jobConf.getList("process.algorithm[@type]").size();
                int i = 0;
                while (i < numberOfProcesses) {
                    String header = "process(" + i + ")";
                    AlgorithmRunner runner = new AlgorithmRunner();
                    runner.configure(jobConf.subset(header));
                    runner.run();
                    ++i;
                }
            }
            catch (ConfigurationException e) {
                System.out.println("Configuration error");
                System.exit(1);
            }
        } else {
            System.out.println("Job file not found");
            System.exit(1);
        }
    }
}

