/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree;

import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractCreator;
import net.sf.jclec.syntaxtree.ISyntaxTreeSpecies;
import net.sf.jclec.syntaxtree.SyntaxTree;
import net.sf.jclec.syntaxtree.SyntaxTreeIndividual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxTreeCreator<I extends SyntaxTreeIndividual>
extends AbstractCreator<I> {
    private static final long serialVersionUID = 1656008967644548798L;
    protected transient ISyntaxTreeSpecies<I> species;
    protected transient ISyntaxTreeSpecies.ISyntaxTreeSchema[] schema;

    public boolean equals(Object other) {
        return other instanceof SyntaxTreeCreator;
    }

    @Override
    protected void prepareCreation() {
        ISpecies species = this.context.getSpecies();
        if (!(species instanceof ISyntaxTreeSpecies)) {
            throw new IllegalStateException("Invalid species in context");
        }
        this.species = (ISyntaxTreeSpecies)species;
        this.schema = this.species.getGenotypeSchema();
    }

    @Override
    protected void createNext() {
        int gl = this.schema.length;
        SyntaxTree[] genotype = new SyntaxTree[gl];
        int i = 0;
        while (i < gl) {
            int actDerivSize = this.randgen.choose(this.schema[i].getMinDerivSize(), this.schema[i].getMaxDerivSize());
            genotype[i] = this.schema[i].createSyntaxTree(actDerivSize, this.randgen);
            ++i;
        }
        this.createdBuffer.add(this.species.createIndividual(genotype));
    }
}

