/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Slipper;

import java.util.Arrays;
import java.util.Vector;
import keel.Algorithms.Rule_Learning.Slipper.Trio;
import keel.Algorithms.Rule_Learning.Slipper.Utilities;

public class Score {
    private Vector trios = new Vector();
    static int POSITIVE = Trio.POSITIVE;
    static int NEGATIVE = Trio.NEGATIVE;

    public void addKey(double key) {
        Trio t = new Trio(key);
        this.trios.add(t);
    }

    public void addKey(double key, double value, int sign) {
        Trio t = new Trio(key);
        if (sign == POSITIVE) {
            t.addPositive(value);
        } else if (sign == NEGATIVE) {
            t.addNegative(value);
        }
        this.trios.add(t);
    }

    public void addPositive(int pos, double value) {
        ((Trio)this.trios.elementAt(pos)).addPositive(value);
    }

    public void addPositive(double key, double value) {
        int pos = this.findKey(key);
        ((Trio)this.trios.elementAt(pos)).addPositive(value);
    }

    public void addNegative(int pos, double value) {
        ((Trio)this.trios.elementAt(pos)).addNegative(value);
    }

    public void addNegative(double key, double value) {
        int pos = this.findKey(key);
        ((Trio)this.trios.elementAt(pos)).addNegative(value);
    }

    public int findKey(double key) {
        int i;
        for (i = 0; i < this.trios.size() && ((Trio)this.trios.elementAt(i)).getKey() != key; ++i) {
        }
        if (i < this.trios.size()) {
            return i;
        }
        return -1;
    }

    public double getKey(int pos) {
        return ((Trio)this.trios.elementAt(pos)).getKey();
    }

    public double getPositive(int pos) {
        return ((Trio)this.trios.elementAt(pos)).getPositive();
    }

    public double getPositive(double key) {
        int pos = this.findKey(key);
        return ((Trio)this.trios.elementAt(pos)).getPositive();
    }

    public double getNegative(int pos) {
        return ((Trio)this.trios.elementAt(pos)).getNegative();
    }

    public double getNegative(double key) {
        int pos = this.findKey(key);
        return ((Trio)this.trios.elementAt(pos)).getNegative();
    }

    public double getTotal(int pos) {
        return ((Trio)this.trios.elementAt(pos)).getNegative() + ((Trio)this.trios.elementAt(pos)).getPositive();
    }

    public double getTotal(double key) {
        int pos = this.findKey(key);
        return ((Trio)this.trios.elementAt(pos)).getNegative() + ((Trio)this.trios.elementAt(pos)).getPositive();
    }

    public void sort() {
        if (this.trios.size() > 1) {
            Trio[] t = new Trio[this.trios.size()];
            this.trios.toArray(t);
            Utilities.mergeSort(t, this.trios.size());
            this.trios = new Vector<Trio>(Arrays.asList(t));
        }
    }

    public int size() {
        return this.trios.size();
    }

    public String toString() {
        String outcome = "";
        for (int i = 0; i < this.trios.size(); ++i) {
            outcome = outcome + (Trio)this.trios.elementAt(i) + "\n";
        }
        return outcome;
    }

    public String toString(int a) {
        String outcome = "";
        for (int i = 0; i < this.trios.size(); ++i) {
            outcome = outcome + ((Trio)this.trios.elementAt(i)).toString(a) + "\n";
        }
        return outcome;
    }
}

