/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.C45Rules;

import java.util.Vector;
import keel.Algorithms.Rule_Learning.C45Rules.IncrementalMask;
import keel.Algorithms.Rule_Learning.C45Rules.Mask;
import keel.Algorithms.Rule_Learning.C45Rules.MyDataset;
import keel.Algorithms.Rule_Learning.C45Rules.Rule;
import keel.Algorithms.Rule_Learning.C45Rules.Stats;
import keel.Algorithms.Rule_Learning.C45Rules.Utilities;

public class Ruleset {
    private Vector rules = new Vector();
    private String type;

    public void addRule(Rule r) {
        this.rules.add(r);
    }

    public Stats apply(MyDataset data) {
        Stats stats = new Stats();
        Mask positives = new Mask(data.size());
        data.filterByClass(positives, this.type);
        Mask negatives = positives.complement();
        int npositives = positives.getnActive();
        int nnegatives = negatives.getnActive();
        for (int i = 0; i < this.rules.size(); ++i) {
            data.substract(positives, (Rule)this.rules.elementAt(i));
            data.substract(negatives, (Rule)this.rules.elementAt(i));
        }
        stats.fn = positives.getnActive();
        stats.tp = npositives - stats.fn;
        stats.tn = negatives.getnActive();
        stats.fp = nnegatives - stats.tn;
        return stats;
    }

    public Stats apply(MyDataset data, Mask positives, Mask negatives) {
        Stats stats = new Stats();
        int npositives = positives.getnActive();
        int nnegatives = negatives.getnActive();
        Mask p = positives.copy();
        Mask n = negatives.copy();
        for (int i = 0; i < this.rules.size(); ++i) {
            data.substract(p, (Rule)this.rules.elementAt(i));
            data.substract(n, (Rule)this.rules.elementAt(i));
        }
        stats.fn = p.getnActive();
        stats.tp = npositives - stats.fn;
        stats.tn = n.getnActive();
        stats.fp = nnegatives - stats.tn;
        return stats;
    }

    public double getExceptionCost(MyDataset data, Mask positives, Mask negatives) {
        Stats quartet = this.apply(data, positives, negatives);
        double tp = quartet.tp;
        double tn = quartet.tn;
        double fp = quartet.fp;
        double fn = quartet.fn;
        double U = tn + fn;
        double C = tp + fp;
        double D = U + C;
        double e = fn + fp;
        if (C > 0.5 * D) {
            return Utilities.log2(D + 1.0) + this.biased(C, fp, 0.5 * e) + this.biased(U, fn, fn);
        }
        return Utilities.log2(D + 1.0) + this.biased(C, fp, fp) + this.biased(U, fn, 0.5 * e);
    }

    public double biased(double N, double E, double ExpE) {
        if (ExpE <= 1.0E-6) {
            return E == 0.0 ? 0.0 : 1000000.0;
        }
        if (ExpE >= N - 1.0E-6) {
            return E == N ? 0.0 : 1000000.0;
        }
        double Rate = ExpE / N;
        return -E * Utilities.log2(Rate) - (N - E) * Utilities.log2(1.0 - Rate);
    }

    public double getExceptionCost(MyDataset data) {
        Mask positives = new Mask(data.size());
        data.filterByClass(positives, this.type);
        Mask negatives = positives.complement();
        return this.getExceptionCost(data, positives, negatives);
    }

    public double getMDL(MyDataset data) {
        if (this.size() == 0) {
            return Double.MAX_VALUE;
        }
        return this.getTheoryCost(data) + this.getExceptionCost(data);
    }

    public double getExceptionCost(MyDataset data, Mask positives, Mask negatives, IncrementalMask rulesetMask) {
        int tp = rulesetMask.and(positives).getnActive();
        int fp = rulesetMask.and(negatives).getnActive();
        int fn = positives.getnActive() - tp;
        int tn = negatives.getnActive() - fp;
        double mdl_ruleset = Rule.getExceptionCost(data, tp, tn, fp, fn);
        return mdl_ruleset;
    }

    public double getTheoryCost(MyDataset data) {
        double total = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            total += this.getRule(i).theoryDL(data);
        }
        return total;
    }

    public void pulish(MyDataset data, Mask positives, Mask negatives) {
        IncrementalMask rulesetMask = new IncrementalMask(data.size());
        Mask[] ruleMask = new Mask[this.rules.size()];
        for (int i = 0; i < this.rules.size(); ++i) {
            ruleMask[i] = new Mask(data.size());
            data.filter(ruleMask[i], this.getRule(i));
            rulesetMask.plus(ruleMask[i]);
        }
        double thCost = this.getTheoryCost(data);
        int tp = rulesetMask.and(positives).getnActive();
        int fp = rulesetMask.and(negatives).getnActive();
        int fn = positives.getnActive() - tp;
        int tn = negatives.getnActive() - fp;
        double mdl_ruleset = thCost + Rule.getExceptionCost(data, tp, tn, fp, fn);
        for (int i = 0; i < this.rules.size(); ++i) {
            rulesetMask.minus(ruleMask[i]);
            tp = rulesetMask.and(positives).getnActive();
            fp = rulesetMask.and(negatives).getnActive();
            fn = positives.getnActive() - tp;
            tn = negatives.getnActive() - fp;
            double mdl_whithout_i = (thCost -= this.getRule(i).theoryDL(data)) + Rule.getExceptionCost(data, tp, tn, fp, fn);
            if (mdl_whithout_i < mdl_ruleset) {
                this.rules.remove(i);
                --i;
                mdl_ruleset = mdl_whithout_i;
                continue;
            }
            rulesetMask.plus(ruleMask[i]);
            thCost += this.getRule(i).theoryDL(data);
        }
    }

    public Rule getRule(int pos) {
        return (Rule)this.rules.elementAt(pos);
    }

    public String getType() {
        return this.type;
    }

    public void insertRule(Rule r, int pos) {
        this.rules.insertElementAt(r, pos);
    }

    public void removeRule(int pos) {
        this.rules.remove(pos);
    }

    public void setType(String type) {
        this.type = type;
    }

    public int size() {
        return this.rules.size();
    }

    public String toString() {
        String output = "";
        for (int i = 0; i < this.rules.size(); ++i) {
            output = output + ((Rule)this.rules.elementAt(i)).toString() + "\n";
        }
        return output;
    }
}

