/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GENAR;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GENAR.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GENAR.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GENAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.GENAR.myDataset;
import org.core.Randomize;

public class GENARProcess {
    private myDataset ds;
    private double[] weights;
    private double[] allow_ampl;
    ArrayList<Chromosome> bestRules;
    ArrayList<AssociationRule> assoc_rules;
    private int nRules;
    private int trials;
    private int nTrials;
    private int popsize;
    private double pm;
    private double pf;
    private int limit;

    public GENARProcess(myDataset ds, int nRules, int nTrials, int popsize, double ps, double pm, double pf, double AF) {
        this.nRules = nRules;
        this.nTrials = nTrials / nRules + 1;
        this.popsize = popsize;
        this.pm = pm;
        this.pf = pf;
        this.limit = (int)Math.ceil((double)popsize * ps);
        this.ds = ds;
        this.weights = new double[this.ds.getnTrans()];
        this.allow_ampl = new double[this.ds.getnVars()];
        for (int i = 0; i < this.allow_ampl.length; ++i) {
            this.allow_ampl[i] = !this.ds.isReal(i) ? (double)((int)((this.ds.getMax(i) - this.ds.getMin(i)) / AF)) : (this.ds.getMax(i) - this.ds.getMin(i)) / AF;
        }
    }

    public void run() {
        this.bestRules = new ArrayList();
        this.trials = 0;
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = 1.0;
        }
        do {
            System.out.println("Number of Rules Selected: " + this.bestRules.size());
            int nGn = 0;
            this.trials = 0;
            ArrayList<Chromosome> popCurrent = this.initialize();
            do {
                System.out.println("Generation: " + nGn);
                ArrayList<Chromosome> popNew = this.select(popCurrent);
                this.crossover(popNew);
                this.mutate(popNew);
                popCurrent.clear();
                popCurrent = popNew;
                ++nGn;
            } while (this.trials < this.nTrials);
            Chromosome chromoBest = this.chooseTheBest(popCurrent);
            this.penalizeRecordsCoveredBy(chromoBest);
            this.bestRules.add(chromoBest.copy());
        } while (this.bestRules.size() < this.nRules && !this.allRecordsCovered());
        this.genRules();
    }

    public void printReport(double minConfidence, double minSupport) {
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int length = 0;
        int countRules = 0;
        for (int i = 0; i < this.assoc_rules.size(); ++i) {
            AssociationRule rule = this.assoc_rules.get(i);
            if (!(rule.getConfidence() >= minConfidence) || !(rule.getAll_support() >= minSupport)) continue;
            ++countRules;
            length += rule.getLength();
            avg_sup += rule.getAll_support();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
        }
        System.out.println("Number of Frequent Itemsets generated: -");
        System.out.println("Number of Association Rules generated: " + countRules);
        if (countRules != 0) {
            System.out.println("Average SupportRules: " + GENARProcess.roundDouble(avg_sup / (double)countRules, 2));
            System.out.println("Average Confidence: " + GENARProcess.roundDouble(avg_conf / (double)countRules, 2));
            System.out.println("Average Lift: " + GENARProcess.roundDouble(avg_lift / (double)countRules, 2));
            System.out.println("Average Conviction: " + GENARProcess.roundDouble(avg_conv / (double)countRules, 2));
            System.out.println("Average Certain Factor: " + GENARProcess.roundDouble(avg_CF / (double)countRules, 2));
            System.out.println("Average Netconf: " + GENARProcess.roundDouble(avg_netConf / (double)countRules, 2));
            System.out.println("Average YulesQ: " + GENARProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            System.out.println("Average Length of the Rules generated: " + GENARProcess.roundDouble((double)length / (double)countRules, 2));
            System.out.println("Number of Covered Records(%): " + 100.0 * (double)this.numCoveredRecords(minSupport) / (double)this.ds.getnTrans());
        } else {
            System.out.println("Average Support: 0.0");
            System.out.println("Average Confidence: 0.0");
            System.out.println("Average Lift: 0.0");
            System.out.println("Average Conviction: 0.0");
            System.out.println("Average Certain Factor: 0.0");
            System.out.println("Average Netconf: 0.0");
            System.out.println("Average Antecedents Length: 0.0");
            System.out.println("Number of Covered Records (%): 0.0");
        }
    }

    public static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public String printRules(ArrayList<AssociationRule> rules) {
        boolean stop = false;
        String rulesList = "";
        rulesList = rulesList + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < rules.size() && !stop; ++i) {
            int lenghtrule = rules.get(i).getAntecedent().size() + rules.get(i).getConsequent().size();
            rulesList = rulesList + "" + GENARProcess.roundDouble(rules.get(i).getAll_support(), 2) + "\t" + GENARProcess.roundDouble(rules.get(i).getSupport(), 2) + "\t" + GENARProcess.roundDouble(rules.get(i).getSupport_cons(), 2) + "\t" + GENARProcess.roundDouble(rules.get(i).getConfidence(), 2) + "\t" + GENARProcess.roundDouble(rules.get(i).getLift(), 2) + "\t" + GENARProcess.roundDouble(rules.get(i).getConv(), 2) + "\t" + GENARProcess.roundDouble(rules.get(i).getCF(), 2) + "\t" + GENARProcess.roundDouble(rules.get(i).getNetConf(), 2) + "\t" + GENARProcess.roundDouble(rules.get(i).getYulesQ(), 2) + "\t" + lenghtrule + "\n";
        }
        return rulesList;
    }

    public void saveReport(double minSupport, PrintWriter w) {
        double avg_yulesQ = 0.0;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        int length = 0;
        int countRules = 0;
        for (int i = 0; i < this.assoc_rules.size(); ++i) {
            AssociationRule rule = this.assoc_rules.get(i);
            if (!(rule.getAll_support() >= minSupport)) continue;
            ++countRules;
            length += rule.getLength();
            avg_sup += rule.getAll_support();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
        }
        w.println("\nNumber of Frequent Itemsets generated: -");
        System.out.println("Number of Frequent Itemsets generated: -");
        w.println("\nNumber of Association Rules generated: " + countRules);
        System.out.println("Number of Association Rules generated: " + countRules);
        if (countRules != 0) {
            w.println("Average Support: " + GENARProcess.roundDouble(avg_sup / (double)countRules, 2));
            System.out.println("Average SupportRules: " + GENARProcess.roundDouble(avg_sup / (double)countRules, 2));
            w.println("Average Confidence: " + GENARProcess.roundDouble(avg_conf / (double)countRules, 2));
            System.out.println("Average Confidence: " + GENARProcess.roundDouble(avg_conf / (double)countRules, 2));
            w.println("Average Lift: " + GENARProcess.roundDouble(avg_lift / (double)countRules, 2));
            System.out.println("Average Lift: " + GENARProcess.roundDouble(avg_lift / (double)countRules, 2));
            w.println("Average Conviction: " + GENARProcess.roundDouble(avg_conv / (double)countRules, 2));
            System.out.println("Average Conviction: " + GENARProcess.roundDouble(avg_conv / (double)countRules, 2));
            w.println("Average Certain Factor: " + GENARProcess.roundDouble(avg_CF / (double)countRules, 2));
            System.out.println("Average Certain Factor: " + GENARProcess.roundDouble(avg_CF / (double)countRules, 2));
            w.println("Average Netconf: " + GENARProcess.roundDouble(avg_netConf / (double)countRules, 2));
            System.out.println("Average Netconf: " + GENARProcess.roundDouble(avg_netConf / (double)countRules, 2));
            w.println("Average YulesQ: " + GENARProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            System.out.println("Average YulesQ: " + GENARProcess.roundDouble(avg_yulesQ / (double)countRules, 2));
            w.println("Average Antecedents Length: " + GENARProcess.roundDouble((double)length / (double)countRules, 2));
            System.out.println("Average Length of the Rules generated: " + GENARProcess.roundDouble((double)length / (double)countRules, 2));
            w.println("Number of Covered Records (%): " + GENARProcess.roundDouble(100.0 * (double)this.numCoveredRecords(minSupport) / (double)this.ds.getnTrans(), 2));
            System.out.println("Number of Covered Records(%): " + 100.0 * (double)this.numCoveredRecords(minSupport) / (double)this.ds.getnTrans());
        } else {
            w.println("Average Support: 0.0");
            System.out.println("Average Support: 0.0");
            w.println("Average Confidence: 0.0");
            System.out.println("Average Confidence: 0.0");
            w.println("Average Lift: 0.0");
            System.out.println("Average Lift: 0.0");
            w.println("Average Conviction: 0.0");
            System.out.println("Average Conviction: 0.0");
            w.println("Average Certain Factor: 0.0");
            System.out.println("Average Certain Factor: 0.0");
            w.println("Average Netconf: 0.0");
            System.out.println("Average Netconf: 0.0");
            w.println("Average Antecedents Length: 0.0");
            System.out.println("Average Antecedents Length: 0.0");
            w.println("Number of Covered Records (%): 0.0");
            System.out.println("Number of Covered Records (%): 0.0");
        }
    }

    public ArrayList<AssociationRule> getSetRules(double minSupport) {
        ArrayList<AssociationRule> selectRules = new ArrayList<AssociationRule>();
        for (int i = 0; i < this.assoc_rules.size(); ++i) {
            AssociationRule rule = this.assoc_rules.get(i);
            if (!(rule.getAll_support() >= minSupport)) continue;
            selectRules.add(rule.copy());
        }
        return selectRules;
    }

    private ArrayList<Chromosome> initialize() {
        ArrayList<Chromosome> popInit = new ArrayList<Chromosome>();
        int nVars = this.ds.getnVars();
        while (popInit.size() < this.popsize) {
            Gene[] genes = new Gene[nVars];
            double[][] trans = this.ds.getRealTransactions();
            int tr = Randomize.Randint(0, this.ds.getnTrans());
            for (int g = 0; g < nVars; ++g) {
                double ub;
                double lb;
                genes[g] = new Gene();
                int attr = g;
                genes[g].setAttr(attr);
                genes[g].setType(this.ds.getAttributeType(attr));
                double max_attr = this.ds.getMax(attr);
                double min_attr = this.ds.getMin(attr);
                if (!this.ds.isNominal(attr)) {
                    if (this.ds.isReal(attr)) {
                        lb = Math.max(trans[tr][attr] - this.allow_ampl[attr] / 2.0, min_attr);
                        ub = Math.min(trans[tr][attr] + this.allow_ampl[attr] / 2.0, max_attr);
                    } else {
                        lb = Math.max(trans[tr][attr] - (double)((int)this.allow_ampl[attr] / 2), min_attr);
                        ub = Math.min(trans[tr][attr] + (double)((int)this.allow_ampl[attr] / 2), max_attr);
                    }
                } else {
                    lb = ub = trans[tr][attr];
                }
                genes[g].setL(lb);
                genes[g].setU(ub);
            }
            Chromosome c = new Chromosome(genes);
            c.setFit(this.fitness(c));
            popInit.add(c);
        }
        return popInit;
    }

    private ArrayList<Chromosome> select(ArrayList<Chromosome> pop) {
        ArrayList<Chromosome> popTmp = new ArrayList<Chromosome>();
        Collections.sort(pop);
        for (int i = 0; i <= this.limit && i < pop.size(); ++i) {
            popTmp.add(pop.get(i).copy());
        }
        return popTmp;
    }

    private void crossover(ArrayList<Chromosome> pop) {
        int nVars = this.ds.getnVars();
        Gene[] genesOff1 = new Gene[nVars];
        Gene[] genesOff2 = new Gene[nVars];
        while (pop.size() < this.popsize) {
            Gene gen2;
            Gene gen1;
            int i;
            Chromosome dad = pop.get(Randomize.Randint(0, pop.size()));
            Chromosome mom = pop.get(Randomize.Randint(0, pop.size()));
            int pos = Randomize.Randint(1, nVars - 1);
            for (i = 0; i < pos; ++i) {
                gen1 = dad.getGen(i);
                gen2 = mom.getGen(i);
                genesOff1[i] = gen1.copy();
                genesOff2[i] = gen2.copy();
            }
            for (i = pos; i < nVars; ++i) {
                gen1 = dad.getGen(i);
                gen2 = mom.getGen(i);
                genesOff1[i] = gen2.copy();
                genesOff2[i] = gen1.copy();
            }
            Chromosome off1 = new Chromosome(genesOff1);
            Chromosome off2 = new Chromosome(genesOff2);
            off1.setFit(this.fitness(off1));
            off2.setFit(this.fitness(off2));
            Chromosome off_best = off1.getFit() > off2.getFit() ? off1 : off2;
            if (!(off_best.getFit() > 0.0)) continue;
            pop.add(off_best);
        }
    }

    private void mutate(ArrayList<Chromosome> pop) {
        int nVars = this.ds.getnVars();
        for (int i = 0; i < this.popsize; ++i) {
            double top;
            if (!(Randomize.Rand() < this.pm)) continue;
            Chromosome chromo = pop.get(i);
            int index = Randomize.Randint(0, nVars);
            Gene g = chromo.getGen(index);
            int attr = g.getAttr();
            double max_attr = this.ds.getMax(attr);
            double min_attr = this.ds.getMin(attr);
            if (!this.ds.isNominal(attr)) {
                if (this.ds.isReal(attr)) {
                    if (Randomize.Rand() < 0.5) {
                        top = Math.max(g.getU() - this.allow_ampl[attr], min_attr);
                        g.setL(Randomize.RanddoubleClosed(top, g.getL()));
                    } else {
                        g.setL(Randomize.Randdouble(g.getL(), g.getU()));
                    }
                    if (Randomize.Rand() < 0.5) {
                        top = Math.min(g.getL() + this.allow_ampl[attr], max_attr);
                        g.setU(Randomize.RanddoubleClosed(g.getU(), top));
                    } else {
                        g.setU(Randomize.RanddoubleClosed(g.getL() + 1.0E-4, g.getU()));
                    }
                } else {
                    if (Randomize.Rand() < 0.5) {
                        top = Math.max(g.getU() - this.allow_ampl[attr], min_attr);
                        g.setL(Randomize.RandintClosed((int)top, (int)g.getL()));
                    } else {
                        g.setL(Randomize.Randint((int)g.getL(), (int)g.getU()));
                    }
                    if (Randomize.Rand() < 0.5) {
                        top = Math.min(g.getL() + this.allow_ampl[attr], max_attr);
                        g.setU(Randomize.RandintClosed((int)g.getU(), (int)top));
                    } else {
                        g.setU(Randomize.RandintClosed((int)g.getL() + 1, (int)g.getU()));
                    }
                }
            } else {
                top = Randomize.RandintClosed((int)min_attr, (int)max_attr);
                g.setL(top);
                g.setU(top);
            }
            chromo.setFit(this.fitness(chromo));
        }
    }

    private double fitness(Chromosome c) {
        ArrayList<Integer> tid_lst = this.countSupport(c.getGenes());
        double cov = 0.0;
        for (int t = 0; t < tid_lst.size(); ++t) {
            cov += this.weights[tid_lst.get(t)];
        }
        ++this.trials;
        return cov / (double)this.ds.getnTrans();
    }

    private ArrayList<Integer> countSupport(Gene[] genes) {
        ArrayList<Integer> tid_list = new ArrayList<Integer>();
        double[][] trans = this.ds.getRealTransactions();
        int nTrans = this.ds.getnTrans();
        for (int t = 0; t < nTrans; ++t) {
            boolean ok = true;
            for (int g = 0; g < genes.length && ok; ++g) {
                int attr = genes[g].getAttr();
                double lb = genes[g].getL();
                double ub = genes[g].getU();
                if (!(trans[t][attr] < lb) && !(trans[t][attr] > ub)) continue;
                ok = false;
            }
            if (!ok) continue;
            tid_list.add(t);
        }
        return tid_list;
    }

    private void penalizeRecordsCoveredBy(Chromosome c) {
        ArrayList<Integer> tid_lst = this.countSupport(c.getGenes());
        for (int i = 0; i < tid_lst.size(); ++i) {
            int tr = tid_lst.get(i);
            if (this.weights[tr] != 1.0) continue;
            this.weights[tr] = 1.0 - this.pf;
        }
    }

    private void genRules() {
        double nTrans = this.ds.getnTrans();
        this.assoc_rules = new ArrayList();
        for (int i = 0; i < this.bestRules.size(); ++i) {
            int j;
            Chromosome chromo = this.bestRules.get(i);
            AssociationRule rule = new AssociationRule();
            Gene[] genes_ant = new Gene[chromo.length() - 1];
            Gene[] genes_con = new Gene[1];
            for (j = 0; j < chromo.length() - 1; ++j) {
                rule.addAntecedent(chromo.getGen(j).copy());
                genes_ant[j] = chromo.getGen(j);
            }
            rule.addConsequent(chromo.getGen(j).copy());
            genes_con[0] = chromo.getGen(j);
            ArrayList<Integer> tid_lst_all = this.countSupport(chromo.getGenes());
            double all_sup = (double)tid_lst_all.size() / nTrans;
            ArrayList<Integer> tid_lst_ant = this.countSupport(genes_ant);
            double ant_sup = (double)tid_lst_ant.size() / nTrans;
            ArrayList<Integer> tid_lst_con = this.countSupport(genes_con);
            double cons_sup = (double)tid_lst_con.size() / nTrans;
            double conf = all_sup / ant_sup;
            double lift = cons_sup == 0.0 || ant_sup == 0.0 ? 1.0 : all_sup / (ant_sup * cons_sup);
            double conv = cons_sup == 1.0 || ant_sup == 0.0 ? 1.0 : ant_sup * (1.0 - cons_sup) / (ant_sup - all_sup);
            double netConf = ant_sup == 0.0 || ant_sup == 1.0 || Math.abs(ant_sup * (1.0 - ant_sup)) <= 0.001 ? 0.0 : (all_sup - ant_sup * cons_sup) / (ant_sup * (1.0 - ant_sup));
            double numeratorYules = all_sup * (1.0 - cons_sup - ant_sup + all_sup) - (ant_sup - all_sup) * (cons_sup - all_sup);
            double denominatorYules = all_sup * (1.0 - cons_sup - ant_sup + all_sup) + (ant_sup - all_sup) * (cons_sup - all_sup);
            double yulesQ = ant_sup == 0.0 || ant_sup == 1.0 || cons_sup == 0.0 || cons_sup == 1.0 || Math.abs(denominatorYules) <= 0.001 ? 0.0 : numeratorYules / denominatorYules;
            double CF = 0.0;
            if (conf > cons_sup) {
                CF = (conf - cons_sup) / (1.0 - cons_sup);
            } else if (conf < cons_sup) {
                CF = (conf - cons_sup) / cons_sup;
            }
            rule.setSupport(ant_sup);
            rule.setSupport_cons(cons_sup);
            rule.setAll_support(all_sup);
            rule.setConfidence(conf);
            rule.setLift(lift);
            rule.setConv(conv);
            rule.setCF(CF);
            rule.setNetConf(netConf);
            rule.setYulesQ(yulesQ);
            this.assoc_rules.add(rule);
        }
    }

    private Chromosome chooseTheBest(ArrayList<Chromosome> pop) {
        double nTrans = this.ds.getnTrans();
        double max_prod = 0.0;
        Chromosome chromo_the_best = pop.get(0);
        Gene[] ant_genes = new Gene[this.ds.getnVars() - 1];
        for (int i = 1; i < pop.size(); ++i) {
            double ant_sup;
            double conf;
            Chromosome chromo = pop.get(i);
            Gene[] genes = chromo.getGenes();
            ArrayList<Integer> tid_lst_all = this.countSupport(genes);
            for (int j = 0; j < genes.length - 1; ++j) {
                ant_genes[j] = genes[j];
            }
            ArrayList<Integer> tid_lst_ant = this.countSupport(ant_genes);
            double all_sup = (double)tid_lst_all.size() / nTrans;
            double prod = all_sup * (conf = all_sup / (ant_sup = (double)tid_lst_ant.size() / nTrans)) * chromo.getFit();
            if (!(prod > max_prod)) continue;
            max_prod = prod;
            chromo_the_best = chromo;
        }
        return chromo_the_best;
    }

    private boolean allRecordsCovered() {
        for (int i = 0; i < this.weights.length; ++i) {
            if (this.weights[i] != 1.0) continue;
            return false;
        }
        return true;
    }

    private int numCoveredRecords(double minSupport) {
        int i;
        int nTrans = this.ds.getnTrans();
        boolean[] marked = new boolean[nTrans];
        for (i = 0; i < marked.length; ++i) {
            marked[i] = false;
        }
        for (i = 0; i < this.assoc_rules.size(); ++i) {
            int j;
            AssociationRule rule = this.assoc_rules.get(i);
            if (!(rule.getAll_support() >= minSupport)) continue;
            ArrayList<Gene> ant = rule.getAntecedent();
            Gene[] genes = new Gene[ant.size()];
            for (j = 0; j < ant.size(); ++j) {
                genes[j] = ant.get(j);
            }
            ArrayList<Integer> tidCovered = this.countSupport(genes);
            for (j = 0; j < tidCovered.size(); ++j) {
                int tr = tidCovered.get(j);
                if (marked[tr]) continue;
                marked[tr] = true;
            }
        }
        int covered = 0;
        for (i = 0; i < marked.length; ++i) {
            if (!marked[i]) continue;
            ++covered;
        }
        return covered;
    }
}

